/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.upload.cloud.amazon.AmazonCloudDriveApi;
import net.doo.snap.upload.cloud.amazon.ForbiddenException;
import net.doo.snap.upload.cloud.amazon.model.AmazonFile;
import net.doo.snap.upload.cloud.amazon.model.AmazonFolder;
import net.doo.snap.util.log.DebugLog;
import retrofit.mime.TypedFile;

public class AmazonCloudDriveUploader
implements CloudUploader {
    @Inject
    private AmazonCloudDriveApi amazonCloudDriveApi;
    @Inject
    private SharedPreferences preferences;

    @Inject
    public AmazonCloudDriveUploader() {
    }

    @Override
    public void upload(UploadInfo info, OnFileUploadListener onFileUploadListener) throws IOException {
        String uploadFolderName = null;
        Uri uploadFolderUri = CloudStorage.AMAZON_CLOUD_DRIVE.getDefaultFolder(this.preferences);
        if (uploadFolderUri != null) {
            String uploadFolderCloudId = uploadFolderUri.getQueryParameter("id");
            uploadFolderName = uploadFolderUri.getQueryParameter("folder_name");
            if (!TextUtils.isEmpty((CharSequence)uploadFolderCloudId)) {
                try {
                    AmazonFile folderMetadata = this.amazonCloudDriveApi.getMetadata(uploadFolderCloudId);
                    if (folderMetadata != null && !TextUtils.isEmpty((CharSequence)folderMetadata.getId())) {
                        this.uploadToExistingFolder(folderMetadata, info, onFileUploadListener);
                        return;
                    }
                }
                catch (ForbiddenException e) {
                    DebugLog.logException((Throwable)e);
                    onFileUploadListener.onUploadAuthorizationFailed(info.getId(), CloudStorage.AMAZON_CLOUD_DRIVE);
                    return;
                }
            }
        }
        this.createFolderAndUploadFile(uploadFolderName, info, onFileUploadListener);
    }

    private void uploadToExistingFolder(AmazonFile folderMetadata, UploadInfo info, OnFileUploadListener onFileUploadListener) {
        String mime = info.getFile().getName().endsWith(".jpg") ? "image/jpeg" : "application/pdf";
        TypedFile file = new TypedFile(mime, info.getFile());
        try {
            AmazonFile overWritten;
            AmazonFile metadata;
            if (!TextUtils.isEmpty((CharSequence)info.getCloudFileId()) && (metadata = this.amazonCloudDriveApi.getMetadata(info.getCloudFileId())) != null && (overWritten = this.amazonCloudDriveApi.overwriteFile(metadata.getId(), file)) != null) {
                onFileUploadListener.onUploadFinished(info.getId(), CloudStorage.AMAZON_CLOUD_DRIVE, overWritten.getId());
                return;
            }
            metadata = new AmazonFile(info.getFile().getName(), folderMetadata.getId());
            AmazonFile uploadedFileMetaData = this.amazonCloudDriveApi.uploadFile(metadata, file);
            if (uploadedFileMetaData != null) {
                onFileUploadListener.onUploadFinished(info.getId(), CloudStorage.AMAZON_CLOUD_DRIVE, uploadedFileMetaData.getId());
            } else {
                onFileUploadListener.onUploadFailed(info.getId(), CloudStorage.AMAZON_CLOUD_DRIVE);
            }
        }
        catch (IOException | ForbiddenException e) {
            DebugLog.logException((Throwable)e);
            onFileUploadListener.onUploadAuthorizationFailed(info.getId(), CloudStorage.AMAZON_CLOUD_DRIVE);
        }
    }

    private void createFolderAndUploadFile(String uploadFolderName, UploadInfo info, OnFileUploadListener onFileUploadListener) {
        if (TextUtils.isEmpty((CharSequence)uploadFolderName)) {
            uploadFolderName = "Scanbot";
        }
        try {
            AmazonFolder uploadFolder;
            AmazonFolder rootFolder = this.amazonCloudDriveApi.getRootFolder();
            if (rootFolder != null && (uploadFolder = this.amazonCloudDriveApi.createFolder(uploadFolderName, rootFolder.getId())) != null) {
                Uri folderUri = new Uri.Builder().appendQueryParameter("folder_name", uploadFolder.getName()).appendQueryParameter("id", String.valueOf(uploadFolder.getId())).build();
                SharedPreferences.Editor edit = this.preferences.edit();
                edit.putString(CloudStorage.AMAZON_CLOUD_DRIVE.getDefaultFolderKey(), folderUri.toString());
                edit.commit();
                this.uploadToExistingFolder(uploadFolder, info, onFileUploadListener);
                return;
            }
            onFileUploadListener.onUploadFailed(info.getId(), CloudStorage.AMAZON_CLOUD_DRIVE);
        }
        catch (IOException | ForbiddenException e) {
            DebugLog.logException((Throwable)e);
            onFileUploadListener.onUploadAuthorizationFailed(info.getId(), CloudStorage.AMAZON_CLOUD_DRIVE);
        }
    }
}

