/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.upload.cloud.slack.SlackApi;
import net.doo.snap.upload.cloud.slack.model.ChannelResponse;
import net.doo.snap.upload.cloud.slack.model.FileResponse;
import net.doo.snap.util.log.DebugLog;

public class SlackUploader
implements CloudUploader {
    public static final String TARGETS_EXTRA = "TARGETS_EXTRA";
    public static final String COMMENT_EXTRA = "COMMENT_EXTRA";
    public static final String TITLE_EXTRA = "TITLE_EXTRA";
    @Inject
    private SlackApi slackApi;
    @Inject
    private SharedPreferences preferences;

    @Inject
    public SlackUploader() {
    }

    @Override
    public void upload(UploadInfo info, OnFileUploadListener onFileUploadListener) throws IOException {
        Uri uploadFolderUri;
        String uploadFolderCloudId = null;
        Bundle extras = info.getExtras();
        if (extras != null && extras.containsKey(TARGETS_EXTRA)) {
            uploadFolderCloudId = extras.getString(TARGETS_EXTRA);
        }
        if (TextUtils.isEmpty(uploadFolderCloudId) && (uploadFolderUri = CloudStorage.SLACK.getDefaultFolder(this.preferences)) != null) {
            uploadFolderCloudId = uploadFolderUri.getQueryParameter("id");
            String uploadFolderName = uploadFolderUri.getQueryParameter("folder_name");
            if (TextUtils.isEmpty((CharSequence)uploadFolderCloudId) && !TextUtils.isEmpty((CharSequence)uploadFolderName)) {
                this.createChannelAndUploadFile(uploadFolderName, info, onFileUploadListener);
                return;
            }
        }
        if (!TextUtils.isEmpty(uploadFolderCloudId)) {
            this.uploadToExistingChannel(uploadFolderCloudId, info, onFileUploadListener);
        } else {
            onFileUploadListener.onUploadFailed(info.getId(), CloudStorage.SLACK);
        }
    }

    private void uploadToExistingChannel(String channels, UploadInfo info, OnFileUploadListener onFileUploadListener) {
        String title = info.getFile().getName();
        String comment = null;
        Bundle extras = info.getExtras();
        if (extras != null) {
            String extraComment;
            String extraTitle = extras.getString(TITLE_EXTRA, null);
            if (!TextUtils.isEmpty((CharSequence)extraTitle)) {
                title = extraTitle;
            }
            if (!TextUtils.isEmpty((CharSequence)(extraComment = extras.getString(COMMENT_EXTRA, null)))) {
                comment = extraComment;
            }
        }
        try {
            FileResponse fileResponse = this.slackApi.uploadFile(info.getFile(), channels, title, comment);
            if (fileResponse.isOk()) {
                onFileUploadListener.onUploadFinished(info.getId(), CloudStorage.SLACK, fileResponse.getFile().getId());
                return;
            }
            if (fileResponse.getError().equalsIgnoreCase("invalid_auth")) {
                onFileUploadListener.onUploadAuthorizationFailed(info.getId(), CloudStorage.SLACK);
                return;
            }
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
        }
        onFileUploadListener.onUploadFailed(info.getId(), CloudStorage.SLACK);
    }

    private void createChannelAndUploadFile(String uploadFolderName, UploadInfo info, OnFileUploadListener onFileUploadListener) {
        try {
            ChannelResponse channelResponse = this.slackApi.createChannel(uploadFolderName);
            if (channelResponse.isOk()) {
                this.uploadToExistingChannel(channelResponse.getChannel().getId(), info, onFileUploadListener);
                return;
            }
            if (channelResponse.getError().equalsIgnoreCase("invalid_auth")) {
                onFileUploadListener.onUploadAuthorizationFailed(info.getId(), CloudStorage.SLACK);
                return;
            }
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
        }
        onFileUploadListener.onUploadFailed(info.getId(), CloudStorage.SLACK);
    }
}

