/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import com.google.inject.Inject;
import com.yandex.disk.client.Credentials;
import com.yandex.disk.client.ProgressListener;
import com.yandex.disk.client.TransportClient;
import com.yandex.disk.client.exceptions.DuplicateFolderException;
import com.yandex.disk.client.exceptions.IntermediateFolderNotExistException;
import com.yandex.disk.client.exceptions.PreconditionFailedException;
import com.yandex.disk.client.exceptions.ServerWebdavException;
import com.yandex.disk.client.exceptions.UnknownServerWebdavException;
import com.yandex.disk.client.exceptions.UnsupportedMediaTypeException;
import com.yandex.disk.client.exceptions.WebdavClientInitException;
import com.yandex.disk.client.exceptions.WebdavNotAuthorizedException;
import com.yandex.disk.client.exceptions.WebdavUserNotInitialized;
import java.io.File;
import java.io.IOException;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.util.log.DebugLog;

class YandexDiskUploader
implements CloudUploader {
    @Inject
    private SharedPreferences preferences;
    @Inject
    private Context context;
    private TransportClient transportClient;

    @Inject
    YandexDiskUploader() {
    }

    @Override
    public synchronized void upload(UploadInfo info, OnFileUploadListener listener) throws IOException {
        String id2 = info.getId();
        this.initYandexDiskAPI(id2, listener);
        try {
            this.createFolderAndSaveFile(info, listener);
        }
        catch (IntermediateFolderNotExistException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.YANDEX_DISK);
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.YANDEX_DISK);
        }
        catch (WebdavUserNotInitialized webdavUserNotInitialized) {
            DebugLog.logException((Throwable)webdavUserNotInitialized);
            listener.onUploadFailed(id2, CloudStorage.YANDEX_DISK);
        }
        catch (PreconditionFailedException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.YANDEX_DISK);
        }
        catch (WebdavNotAuthorizedException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadAuthorizationFailed(id2, CloudStorage.YANDEX_DISK);
        }
        catch (ServerWebdavException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.YANDEX_DISK);
        }
        catch (UnknownServerWebdavException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.YANDEX_DISK);
        }
        catch (UnsupportedMediaTypeException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.YANDEX_DISK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFolderAndSaveFile(UploadInfo info, OnFileUploadListener listener) throws IOException, PreconditionFailedException, UnsupportedMediaTypeException, WebdavNotAuthorizedException, WebdavUserNotInitialized, UnknownServerWebdavException, IntermediateFolderNotExistException, ServerWebdavException {
        String folderPath = File.separator + "Scanbot";
        try {
            if (this.preferences.contains(CloudStorage.YANDEX_DISK.getDefaultFolderKey())) {
                Uri folder = CloudStorage.YANDEX_DISK.getDefaultFolder(this.preferences);
                folderPath = folder.getQueryParameter("id");
            } else {
                this.transportClient.makeFolder(folderPath);
            }
        }
        catch (DuplicateFolderException e) {
            DebugLog.logException((Throwable)e);
        }
        finally {
            this.saveFileToYandexDisk(folderPath, info, listener);
        }
    }

    private void saveFileToYandexDisk(String folderPath, UploadInfo info, OnFileUploadListener listener) throws IOException, UnknownServerWebdavException, PreconditionFailedException, IntermediateFolderNotExistException, WebdavUserNotInitialized, ServerWebdavException, WebdavNotAuthorizedException {
        File file = info.getFile();
        this.transportClient.uploadFile(file, folderPath + File.separator, file.getName(), TransportClient.makeHash((File)file, (TransportClient.HashType)TransportClient.HashType.MD5), null, new ProgressListener(){

            public void updateProgress(long l, long l2) {
            }

            public boolean hasCancelled() {
                return false;
            }
        });
        listener.onUploadFinished(info.getId(), CloudStorage.YANDEX_DISK, folderPath + File.separator + file.getName());
    }

    private void initYandexDiskAPI(String id2, OnFileUploadListener listener) {
        try {
            this.transportClient = TransportClient.getInstance((Context)this.context, (Credentials)new Credentials(null, this.preferences.getString("YANDEX_TOKEN_KEY", "")));
        }
        catch (WebdavClientInitException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.YANDEX_DISK);
        }
    }
}

