/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud.wunderlist;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import net.doo.snap.upload.cloud.wunderlist.ForbiddenException;
import net.doo.snap.upload.cloud.wunderlist.WunderlistAuthRestApi;
import net.doo.snap.upload.cloud.wunderlist.WunderlistEndpointsRestApi;
import net.doo.snap.upload.cloud.wunderlist.WunderlistUploadRestApi;
import net.doo.snap.upload.cloud.wunderlist.model.CreateFileRequest;
import net.doo.snap.upload.cloud.wunderlist.model.CreateListRequest;
import net.doo.snap.upload.cloud.wunderlist.model.CreateReminderRequest;
import net.doo.snap.upload.cloud.wunderlist.model.CreateTaskRequest;
import net.doo.snap.upload.cloud.wunderlist.model.CreateUploadRequest;
import net.doo.snap.upload.cloud.wunderlist.model.File;
import net.doo.snap.upload.cloud.wunderlist.model.List;
import net.doo.snap.upload.cloud.wunderlist.model.Part;
import net.doo.snap.upload.cloud.wunderlist.model.ProfileResponse;
import net.doo.snap.upload.cloud.wunderlist.model.Reminder;
import net.doo.snap.upload.cloud.wunderlist.model.Task;
import net.doo.snap.upload.cloud.wunderlist.model.TokenResponse;
import net.doo.snap.upload.cloud.wunderlist.model.UpdateReminderRequest;
import net.doo.snap.upload.cloud.wunderlist.model.UpdateTaskRequest;
import net.doo.snap.upload.cloud.wunderlist.model.Upload;
import net.doo.snap.upload.cloud.wunderlist.model.UploadFinishedRequest;
import net.doo.snap.upload.cloud.wunderlist.model.UploadFinishedResponse;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.ApacheClient;
import retrofit.client.Client;
import retrofit.client.Response;
import retrofit.mime.TypedFile;

public class WunderlistApi {
    private static final int NOT_AUTHORIZED_ERROR_CODE = 403;
    private static final String HEADER_TOKEN_KEY = "X-Access-Token";
    private static final String HEADER_CLIENT_ID_KEY = "X-Client-ID";
    private static final String CODE_KEY = "code";
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String CLIENT_SECRET_KEY = "client_secret";
    private static String accessToken;
    private WunderlistAuthRestApi wunderlistAuthRestApi;
    private WunderlistEndpointsRestApi wunderlistEndpointsRestApi;
    private WunderlistUploadRestApi wunderlistUploadRestApi;
    private SharedPreferences preferences;
    private final Context context;
    private RequestInterceptor requestInterceptor = new RequestInterceptor(){

        public void intercept(RequestInterceptor.RequestFacade requestFacade) {
            requestFacade.addHeader(WunderlistApi.HEADER_TOKEN_KEY, accessToken);
            requestFacade.addHeader(WunderlistApi.HEADER_CLIENT_ID_KEY, ManifestConstantsProvider.getConstantValue((Context)WunderlistApi.this.context, (String)"wunderlist_client_id"));
        }
    };
    private ErrorHandler errorHandler = new ErrorHandler(){

        public Throwable handleError(RetrofitError retrofitError) {
            DebugLog.logException((Throwable)retrofitError);
            if (retrofitError.getResponse() != null && retrofitError.getResponse().getStatus() == 403) {
                return new ForbiddenException((Throwable)retrofitError);
            }
            return new IOException((Throwable)retrofitError);
        }
    };

    @Inject
    public WunderlistApi(SharedPreferences preferences, Context context) {
        this.preferences = preferences;
        this.context = context;
        accessToken = preferences.getString("WUNDERLIST_ACCESS_TOKEN", null);
    }

    private void ensureAuthApi() {
        if (this.wunderlistAuthRestApi == null) {
            RestAdapter authRestAdapter = new RestAdapter.Builder().setEndpoint("https://www.wunderlist.com").setErrorHandler(this.errorHandler).setClient((Client)new ApacheClient()).build();
            this.wunderlistAuthRestApi = (WunderlistAuthRestApi)authRestAdapter.create(WunderlistAuthRestApi.class);
        }
    }

    private void ensureEndpointsApi() {
        if (this.wunderlistEndpointsRestApi == null) {
            RestAdapter authRestAdapter = new RestAdapter.Builder().setEndpoint("https://a.wunderlist.com/api/v1").setErrorHandler(this.errorHandler).setClient((Client)new ApacheClient()).setRequestInterceptor(this.requestInterceptor).build();
            this.wunderlistEndpointsRestApi = (WunderlistEndpointsRestApi)authRestAdapter.create(WunderlistEndpointsRestApi.class);
        }
    }

    private void ensureUploadApi(String endpoint) {
        RestAdapter authRestAdapter = new RestAdapter.Builder().setEndpoint(endpoint).setClient((Client)new ApacheClient()).build();
        this.wunderlistUploadRestApi = (WunderlistUploadRestApi)authRestAdapter.create(WunderlistUploadRestApi.class);
    }

    public TokenResponse getTokensByCode(String code) throws IOException {
        this.ensureAuthApi();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(CODE_KEY, code);
        fields.put(CLIENT_ID_KEY, ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"wunderlist_client_id"));
        fields.put(CLIENT_SECRET_KEY, ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"wunderlist_client_secret"));
        return this.wunderlistAuthRestApi.getTokens(fields);
    }

    public ProfileResponse getProfile() throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.getProfile();
    }

    public java.util.List<List> getLists() throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.getLists();
    }

    public List getList(long id2) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.getList(id2);
    }

    public List createList(CreateListRequest request) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.createList(request);
    }

    public java.util.List<Task> getTasks() throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.getTasks();
    }

    public Task createTask(CreateTaskRequest request) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.createTask(request);
    }

    public Task updateTask(long id2, UpdateTaskRequest request) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.updateTask(id2, request);
    }

    public Task getTask(long id2) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.getTask(id2);
    }

    public File createFile(CreateFileRequest request) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.createFile(request);
    }

    public Upload createUpload(CreateUploadRequest request) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.createUpload(request);
    }

    public Response uploadFile(Part part, TypedFile file) throws IOException {
        Uri uri = Uri.parse((String)part.getUrl());
        this.ensureUploadApi(part.getUrl().replace(uri.getQuery(), "").replace(uri.getPath(), "").replace("?", ""));
        return this.wunderlistUploadRestApi.uploadFile(uri.getPath().replaceFirst("/", "") + "?" + uri.getQuery(), part.getAuthorization(), " ", part.getDate(), file);
    }

    public UploadFinishedResponse markUploadFinished(long id2, UploadFinishedRequest request) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.markUploadFinished(id2, request);
    }

    public Reminder createReminder(CreateReminderRequest request) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.createReminder(request);
    }

    public java.util.List<Reminder> getReminder(long id2) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.getReminder(id2);
    }

    public Reminder updateReminder(long id2, UpdateReminderRequest request) throws ForbiddenException, IOException {
        this.ensureEndpointsApi();
        return this.wunderlistEndpointsRestApi.updateReminder(id2, request);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    void saveTokens(TokenResponse tokens) {
        accessToken = tokens.getAccessToken();
        this.preferences.edit().putString("WUNDERLIST_ACCESS_TOKEN", tokens.getAccessToken()).commit();
    }
}

