/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.Loader;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.google.inject.Inject;
import io.scanbot.sap.SapManager;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.ui.adapter.FoldersAdapter;
import net.doo.snap.ui.edit.RenameDocumentFragment;
import net.doo.snap.ui.edit.events.DocumentRenamedEvent;
import net.doo.snap.ui.themes.ThemesProvider;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.util.loading.SingleThreadLoader;
import org.jetbrains.annotations.NotNull;
import roboguice.event.Observes;

public abstract class ChooserActivity
extends CustomThemeActivity
implements LoaderManager.LoaderCallbacks<List<Uri>> {
    private static final String RENAME_FOLDER_FRAGMENT_TAG = "RENAME_FOLDER_FRAGMENT_TAG";
    protected List<Uri> foldersUris = new ArrayList<Uri>();
    protected FoldersAdapter adapter;
    protected LinkedList<Uri> foldersHierarchy = new LinkedList();
    protected Uri newChosenFolder;
    protected CloudStorage chooserStorage;
    protected boolean isActive;
    @Inject
    private SharedPreferences preferences;
    @Inject
    private SapManager sapManager;
    private ListView listView;
    private View progressBar;
    private View goUpView;
    private View createFolderView;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!this.sapManager.isLicenseActive() || !this.sapManager.isFeatureEnabled(128)) {
            this.finish();
            return;
        }
        this.isActive = true;
        this.setContentView(R.layout.activity_folder_chooser);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.startInitTask();
    }

    protected ThemesProvider initThemesProvider(String themeType) {
        return super.initThemesProvider("chooser_theme");
    }

    protected void onRestart() {
        super.onRestart();
    }

    protected void onDestroy() {
        this.isActive = false;
        super.onDestroy();
    }

    public void onBackPressed() {
        if (this.foldersHierarchy.size() > 1) {
            this.foldersHierarchy.removeLast();
            this.goUpView.setVisibility(this.foldersHierarchy.size() > 1 ? 0 : 8);
            this.reloadFoldersList();
        } else {
            super.onBackPressed();
        }
    }

    public Loader<List<Uri>> onCreateLoader(int i, Bundle bundle) {
        return new SingleThreadLoader<List<Uri>>((Context)this){

            protected List<Uri> doInBackground() {
                return ChooserActivity.this.loadFolders();
            }
        };
    }

    public void onLoadFinished(Loader<List<Uri>> listLoader, List<Uri> folderUris) {
        this.showProgress(false);
        this.foldersUris.clear();
        this.foldersUris.addAll(folderUris);
        this.adapter.notifyDataSetChanged();
    }

    public void onLoaderReset(Loader<List<Uri>> listLoader) {
        this.foldersUris.clear();
        this.adapter.notifyDataSetChanged();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected abstract void init();

    protected abstract void createFolder(String var1);

    protected abstract List<Uri> loadFolders();

    protected void reloadFoldersList() {
        this.showProgress(true);
        this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
    }

    private void startInitTask() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                ChooserActivity.this.init();
                return null;
            }

            protected void onPostExecute(Void aVoid) {
                super.onPostExecute((Object)aVoid);
                if (!ChooserActivity.this.isActive) {
                    return;
                }
                if (ChooserActivity.this.newChosenFolder == null && ChooserActivity.this.chooserStorage != null) {
                    ChooserActivity.this.newChosenFolder = ChooserActivity.this.chooserStorage.getDefaultFolder(ChooserActivity.this.preferences);
                }
                ChooserActivity.this.adapter = new StorageFoldersAdapter(ChooserActivity.this.newChosenFolder, (Context)ChooserActivity.this, ChooserActivity.this.foldersUris);
                ChooserActivity.this.progressBar = ChooserActivity.this.findViewById(R.id.progress_bar);
                ChooserActivity.this.listView = (ListView)ChooserActivity.this.findViewById(16908298);
                ChooserActivity.this.initHeader();
                ChooserActivity.this.listView.setAdapter((ListAdapter)ChooserActivity.this.adapter);
                ChooserActivity.this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)ChooserActivity.this);
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    protected View initHeader() {
        View header = View.inflate((Context)this, (int)R.layout.folder_chooser_header, null);
        this.goUpView = header.findViewById(R.id.go_up);
        this.goUpView.setVisibility(8);
        this.goUpView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChooserActivity.this.foldersHierarchy.size() > 1) {
                    ChooserActivity.this.foldersHierarchy.removeLast();
                    ChooserActivity.this.goUpView.setVisibility(ChooserActivity.this.foldersHierarchy.size() > 1 ? 0 : 8);
                    ChooserActivity.this.reloadFoldersList();
                }
            }
        });
        this.createFolderView = header.findViewById(R.id.new_folder);
        this.createFolderView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooserActivity.this.openNewFolderNameDialog();
            }
        });
        this.listView.addHeaderView(header, null, false);
        return header;
    }

    protected void openNewFolderNameDialog() {
        Bundle args = new Bundle();
        args.putString("CURRENT_NAME", "Scanbot");
        args.putInt("TITLE", R.string.folder_chooser_new_folder);
        args.putInt("HINT", R.string.folder_chooser_new_folder);
        RenameDocumentFragment renameFragment = RenameDocumentFragment.newInstance((Bundle)args);
        renameFragment.show(this.getSupportFragmentManager(), RENAME_FOLDER_FRAGMENT_TAG);
    }

    public void onDocumentRename(@Observes DocumentRenamedEvent event) {
        this.showProgress(true);
        this.startCreateFolderTask(event.getNewName());
    }

    protected void showProgress(boolean show) {
        this.listView.setVisibility(show ? 8 : 0);
        this.progressBar.setVisibility(show ? 0 : 8);
    }

    private void startCreateFolderTask(final String folderName) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                ChooserActivity.this.createFolder(folderName);
                return null;
            }

            protected void onPostExecute(Void aVoid) {
                super.onPostExecute((Object)aVoid);
                if (!ChooserActivity.this.isActive) {
                    return;
                }
                ChooserActivity.this.reloadFoldersList();
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    protected void setCreateFolderViewVisible(boolean visible) {
        this.createFolderView.setVisibility(visible ? 0 : 8);
    }

    private class StorageFoldersAdapter
    extends FoldersAdapter {
        public StorageFoldersAdapter(Uri currentChosenFolder, Context context, List<Uri> objects) {
            super(currentChosenFolder, context, objects);
        }

        @Override
        public boolean chooseItem(@NotNull Uri folder) {
            Intent data = new Intent();
            if (ChooserActivity.this.chooserStorage != null) {
                SharedPreferences.Editor edit = ChooserActivity.this.preferences.edit();
                edit.putString(ChooserActivity.this.chooserStorage.getDefaultFolderKey(), folder.toString());
                if (ChooserActivity.this.chooserStorage.equals((Object)CloudStorage.EVERNOTE)) {
                    edit.putBoolean("EVERNOTE_IS_FOLDER_BUSINESS", "true".equalsIgnoreCase(folder.getQueryParameter("business")));
                }
                edit.apply();
            } else {
                String newPath = folder.getQueryParameter("id");
                File newDir = new File(newPath);
                if (!newDir.canRead() || !newDir.canWrite()) {
                    return false;
                }
                data.putExtra("NEW_DIR_PATH", newPath);
            }
            ChooserActivity.this.newChosenFolder = folder;
            ChooserActivity.this.setResult(-1, data);
            ChooserActivity.this.finish();
            return true;
        }

        @Override
        public void openItem(Uri folder) {
            if (!ChooserActivity.this.foldersHierarchy.isEmpty()) {
                ChooserActivity.this.foldersHierarchy.add(folder);
                ChooserActivity.this.goUpView.setVisibility(0);
                ChooserActivity.this.reloadFoldersList();
            }
        }
    }
}

