/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.URLUtil;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.google.inject.Inject;
import de.aflx.sardine.Sardine;
import de.aflx.sardine.SardineFactory;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.security.AddCertificateDialogFragment;
import net.doo.snap.security.LocalKeystoreManager;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.auth.ConnectionResult;
import net.doo.snap.upload.webdav.SelfSignedCertificateException;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.ExecutionUtils;
import roboguice.event.Observes;

public class WebDavStorageActivity
extends CustomThemeActivity {
    private static final int CHOOSER_REQUEST_CODE = 1;
    public static final String ADD_CERTIFICATE_DIALOG_TAG = "ADD_CERTIFICATE_DIALOG";
    @Inject
    private SharedPreferences preferences;
    @Inject
    private SardineFactory sardineFactory;
    @Inject
    private LocalKeystoreManager localKeystoreManager;
    private EditText hostView;
    private EditText usernameView;
    private EditText passwordView;
    private ViewGroup progressView;
    private ViewGroup contentView;
    private Spinner webdavSpinner;
    private boolean destroyed = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_webdav);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.hostView = (EditText)this.findViewById(R.id.host);
        this.usernameView = (EditText)this.findViewById(R.id.username);
        this.passwordView = (EditText)this.findViewById(R.id.password);
        this.progressView = (ViewGroup)this.findViewById(R.id.progress);
        this.progressView.setVisibility(8);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.WEBDAV_STORAGE.getNameResource())}));
        this.contentView = (ViewGroup)this.findViewById(R.id.content_container);
        this.webdavSpinner = (Spinner)this.findViewById(R.id.webdavurls);
        ArrayAdapter adapter = ArrayAdapter.createFromResource((Context)this, (int)R.array.webdav_storages, (int)R.layout.webdav_spinner_item);
        adapter.setDropDownViewResource(R.layout.webdav_spinner_dropdown_item);
        this.webdavSpinner.setAdapter((SpinnerAdapter)adapter);
        this.webdavSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                WebDavStorageActivity.this.hostView.setText((CharSequence)WebDavStorageActivity.this.getResources().getStringArray(R.array.webdav_urls)[position]);
            }

            public void onNothingSelected(AdapterView<?> parent) {
                WebDavStorageActivity.this.hostView.setText((CharSequence)"");
            }
        });
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.WEBDAV_STORAGE, this.usernameView.getText().toString()));
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.webdav_menu, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (id2 == R.id.login) {
            if (TextUtils.isEmpty((CharSequence)this.usernameView.getText()) || TextUtils.isEmpty((CharSequence)this.passwordView.getText()) || TextUtils.isEmpty((CharSequence)this.hostView.getText())) {
                Toast.makeText((Context)this, (int)R.string.web_dav_fempty_fields_error, (int)1).show();
            } else if (!URLUtil.isValidUrl((String)this.hostView.getText().toString())) {
                Toast.makeText((Context)this, (int)R.string.web_dav_incorrect_url_error, (int)1).show();
            } else {
                this.finishAuthorization();
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void onCertificateApproved(@Observes AddCertificateDialogFragment.CertificateApprovedEvent event) {
        X509Certificate certificate = event.getCertificate();
        if (certificate != null) {
            new AddCertificateTask(certificate).execute(new Void[0]);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.destroyed = true;
    }

    private void finishAuthorization() {
        new AsyncTask<Void, Void, WebDavConnectionResult>(){

            protected void onPreExecute() {
                super.onPreExecute();
                WebDavStorageActivity.this.progressView.setVisibility(0);
                WebDavStorageActivity.this.contentView.setVisibility(8);
                InputMethodManager imm = (InputMethodManager)WebDavStorageActivity.this.getSystemService("input_method");
                imm.hideSoftInputFromWindow(WebDavStorageActivity.this.hostView.getWindowToken(), 0);
                imm.hideSoftInputFromWindow(WebDavStorageActivity.this.usernameView.getWindowToken(), 0);
                imm.hideSoftInputFromWindow(WebDavStorageActivity.this.passwordView.getWindowToken(), 0);
            }

            protected WebDavConnectionResult doInBackground(Void ... params) {
                block4: {
                    Uri.Builder uriBuilder = new Uri.Builder();
                    uriBuilder.encodedPath(WebDavStorageActivity.this.hostView.getText().toString() + File.separator);
                    Sardine sardine = WebDavStorageActivity.this.sardineFactory.begin(WebDavStorageActivity.this.usernameView.getText().toString(), WebDavStorageActivity.this.passwordView.getText().toString());
                    if (sardine != null) {
                        try {
                            List list = sardine.list(uriBuilder.toString());
                            if (list != null) {
                                return new WebDavConnectionResult(true, false);
                            }
                        }
                        catch (IOException e) {
                            DebugLog.logException((Throwable)e);
                            Throwable cause = e.getCause();
                            if (!(cause instanceof SelfSignedCertificateException)) break block4;
                            this.requestCertificateApproval((SelfSignedCertificateException)cause);
                            return new WebDavConnectionResult(false, false);
                        }
                    }
                }
                return new WebDavConnectionResult(false, true);
            }

            private void requestCertificateApproval(SelfSignedCertificateException cause) {
                final X509Certificate certificate = cause.getCertificate();
                WebDavStorageActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        this.showDialogIfNotDestroyed(certificate);
                    }
                });
            }

            private void showDialogIfNotDestroyed(X509Certificate certificate) {
                if (WebDavStorageActivity.this.destroyed) {
                    return;
                }
                FragmentManager fragmentManager = WebDavStorageActivity.this.getSupportFragmentManager();
                if (fragmentManager.findFragmentByTag(WebDavStorageActivity.ADD_CERTIFICATE_DIALOG_TAG) != null) {
                    return;
                }
                AddCertificateDialogFragment.newInstance(certificate).show(fragmentManager, WebDavStorageActivity.ADD_CERTIFICATE_DIALOG_TAG);
            }

            protected void onPostExecute(WebDavConnectionResult result) {
                if (result.isSuccessful()) {
                    WebDavStorageActivity.this.storeCredentials();
                    WebDavStorageActivity.this.preferences.edit().remove(CloudStorage.WEBDAV_STORAGE.getDefaultFolderKey()).commit();
                    Intent intent = new Intent((Context)WebDavStorageActivity.this, CloudStorage.getChooserActivity(CloudStorage.WEBDAV_STORAGE));
                    intent.putExtra("CLOUD_STORAGE", CloudStorage.WEBDAV_STORAGE.getDatabaseId());
                    WebDavStorageActivity.this.startActivityForResult(intent, 1);
                } else {
                    WebDavStorageActivity.this.progressView.setVisibility(8);
                    WebDavStorageActivity.this.contentView.setVisibility(0);
                    if (result.showErrorToast()) {
                        Toast.makeText((Context)WebDavStorageActivity.this, (int)R.string.webdav_invalid_toast, (int)1).show();
                    }
                }
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private void deliverConnectionResult(ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }

    private void storeCredentials() {
        this.preferences.edit().putString("WEBDAV_HOST", this.hostView.getText().toString()).putString("WEBDAV_USERNAME", this.usernameView.getText().toString()).putString("WEBDAV_PASS", this.passwordView.getText().toString()).commit();
    }

    private class WebDavConnectionResult {
        private final boolean result;
        private final boolean showInvalidCredentialsToast;

        WebDavConnectionResult(boolean result, boolean showToast) {
            this.result = result;
            this.showInvalidCredentialsToast = showToast;
        }

        public boolean isSuccessful() {
            return this.result;
        }

        public boolean showErrorToast() {
            return this.showInvalidCredentialsToast;
        }
    }

    private class AddCertificateTask
    extends AsyncTask<Void, Void, Boolean> {
        private final X509Certificate certificate;

        private AddCertificateTask(X509Certificate certificate) {
            this.certificate = certificate;
        }

        protected Boolean doInBackground(Void ... voids) {
            try {
                WebDavStorageActivity.this.localKeystoreManager.addCertificate(this.certificate);
                return true;
            }
            catch (KeyStoreException e) {
                DebugLog.logException((Throwable)e);
            }
            catch (CertificateException e) {
                DebugLog.logException((Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                DebugLog.logException((Throwable)e);
            }
            catch (IOException e) {
                DebugLog.logException((Throwable)e);
            }
            return false;
        }

        protected void onPostExecute(Boolean certificateAdded) {
            if (WebDavStorageActivity.this.destroyed) {
                return;
            }
            if (certificateAdded.booleanValue()) {
                WebDavStorageActivity.this.finishAuthorization();
            } else {
                ExecutionUtils.showToast((Context)WebDavStorageActivity.this, (int)R.string.save_certificate_error);
            }
        }
    }
}

