/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import com.google.inject.Inject;
import io.scanbot.shoeboxed.ApiApplication;
import io.scanbot.shoeboxed.ShoeboxedApi;
import io.scanbot.shoeboxed.ShoeboxedSession;
import io.scanbot.shoeboxed.UnauthorizedException;
import io.scanbot.shoeboxed.entity.Category;
import io.scanbot.shoeboxed.entity.Document;
import io.scanbot.shoeboxed.entity.request.CreateCategoryRequest;
import io.scanbot.shoeboxed.entity.request.CreateDocumentRequest;
import java.io.IOException;
import java.util.List;
import net.doo.snap.entity.DocumentType;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.MimeUtils;
import retrofit.mime.TypedFile;

class ShoeboxedUploader
implements CloudUploader {
    @Inject
    private SharedPreferences preferences;
    @Inject
    private Context context;
    private long accountId;
    private ShoeboxedApi shoeboxedApi;

    @Inject
    ShoeboxedUploader() {
    }

    @Override
    public synchronized void upload(UploadInfo info, OnFileUploadListener onFileUploadListener) {
        try {
            this.ensureApiInitialized();
            Document document = this.performUpload(info);
            onFileUploadListener.onUploadFinished(info.getId(), CloudStorage.SHOEBOXED, document.getId());
        }
        catch (UnauthorizedException e) {
            onFileUploadListener.onUploadAuthorizationFailed(info.getId(), CloudStorage.SHOEBOXED);
            DebugLog.logException((Throwable)e);
        }
        catch (IOException e) {
            onFileUploadListener.onUploadFailed(info.getId(), CloudStorage.SHOEBOXED);
            DebugLog.logException((Throwable)e);
        }
    }

    private Document performUpload(UploadInfo info) throws IOException {
        Category category = this.ensureCategory();
        TypedFile typedFile = new TypedFile(MimeUtils.getMimeByName((String)info.getFile().getName()), info.getFile());
        CreateDocumentRequest.Builder builder = new CreateDocumentRequest.Builder().appendCategory(category.getName()).notes(info.getOcr());
        switch (DocumentType.getByMimeType((String)info.getType())) {
            case BUSINESS_CARD: {
                builder.type(Document.Type.BUSINESS_CARD);
                break;
            }
            case RECEIPT: {
                builder.type(Document.Type.RECEIPT);
                break;
            }
            default: {
                builder.type(Document.Type.OTHER);
            }
        }
        CreateDocumentRequest request = builder.build();
        return this.shoeboxedApi.createDocument(this.accountId, typedFile, request);
    }

    private Category ensureCategory() throws IOException {
        Uri folderUri = CloudStorage.SHOEBOXED.getDefaultFolder(this.preferences);
        if (folderUri == null) {
            return this.ensureDefaultCategory();
        }
        long categoryId = Long.parseLong(folderUri.getQueryParameter("id"));
        List categories = this.shoeboxedApi.getCategories(this.accountId);
        for (Category category : categories) {
            if (category.getId() != categoryId) continue;
            return category;
        }
        DebugLog.d((String)("Category with given id was not found: " + categoryId));
        return this.createDefaultCategory();
    }

    private Category ensureDefaultCategory() throws IOException {
        List categories = this.shoeboxedApi.getCategories(this.accountId);
        for (Category category : categories) {
            if (!"Scanbot".equals(category.getName())) continue;
            return category;
        }
        return this.createDefaultCategory();
    }

    private Category createDefaultCategory() throws IOException {
        return this.shoeboxedApi.createCategory(this.accountId, new CreateCategoryRequest.Builder("Scanbot").build());
    }

    private void ensureApiInitialized() throws IOException {
        if (this.shoeboxedApi != null) {
            return;
        }
        if (!this.preferences.contains("SHOEBOXED_ACCOUNT_ID")) {
            throw new IOException("Account is not saved");
        }
        this.accountId = this.preferences.getLong("SHOEBOXED_ACCOUNT_ID", 0L);
        ApiApplication apiApplication = new ApiApplication(ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"shoeboxed_api_client_id"), ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"shoeboxed_api_secret"), ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"shoeboxed_api_redirect_url"));
        ShoeboxedSession session = new ShoeboxedSession.Builder(apiApplication).accessToken(this.preferences.getString("SHOEBOXED_ACCESS_TOKEN", null)).refreshToken(this.preferences.getString("SHOEBOXED_REFRESH_TOKEN", null)).build();
        this.shoeboxedApi = ShoeboxedApi.forSession((ShoeboxedSession)session);
    }
}

