/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.LoaderManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.android.AndroidAuthSession;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.upload.ChooserActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.ExecutionUtils;

public class DropboxChooserActivity
extends ChooserActivity
implements LoaderManager.LoaderCallbacks<List<Uri>> {
    private static final int REQUEST_ITEMS_LIMIT = 10000;
    private static final String ROOT_PATH = File.separator;
    private DropboxAPI<AndroidAuthSession> api;
    @Inject
    private SharedPreferences preferences;

    @Override
    protected void init() {
        this.chooserStorage = CloudStorage.DROPBOX;
        this.foldersHierarchy.add(new Uri.Builder().appendQueryParameter("folder_name", ROOT_PATH).appendQueryParameter("id", ROOT_PATH).build());
        this.initDropboxAPI();
    }

    private void initDropboxAPI() {
        AppKeyPair appKeys = new AppKeyPair(ManifestConstantsProvider.getConstantValue((Context)this, (String)"dropbox_app_key"), ManifestConstantsProvider.getConstantValue((Context)this, (String)"dropbox_app_secret"));
        AndroidAuthSession session = new AndroidAuthSession(appKeys, Session.AccessType.DROPBOX);
        this.api = new DropboxAPI((Session)session);
        if (this.preferences.contains("DROPBOX_TOKEN_KEY") && this.preferences.contains("DROPBOX_TOKEN_SECRET")) {
            AccessTokenPair tokens = new AccessTokenPair(this.preferences.getString("DROPBOX_TOKEN_KEY", null), this.preferences.getString("DROPBOX_TOKEN_SECRET", null));
            ((AndroidAuthSession)this.api.getSession()).setAccessTokenPair(tokens);
        }
    }

    @Override
    protected void createFolder(String name) {
        DropboxAPI.Entry response = null;
        try {
            response = this.api.createFolder(this.foldersHierarchy.isEmpty() ? "" : ((Uri)this.foldersHierarchy.getLast()).getQueryParameter("id") + File.separator + name);
        }
        catch (DropboxException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
        if (response != null && response.rev != null) {
            DebugLog.i((String)"Dropbox folder is created!");
        } else {
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
    }

    @Override
    protected List<Uri> loadFolders() {
        ArrayList<Uri> foldersUris = new ArrayList<Uri>();
        DropboxAPI.Entry response = null;
        try {
            response = this.api.metadata(((Uri)this.foldersHierarchy.getLast()).getQueryParameter("id"), 10000, null, true, null);
        }
        catch (DropboxException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
            return foldersUris;
        }
        if (response == null) {
            DebugLog.w((String)"Dropbox metadata request is failed!");
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
            return foldersUris;
        }
        for (DropboxAPI.Entry item : response.contents) {
            if (item.isDeleted || !item.isDir) continue;
            Uri uri = new Uri.Builder().appendQueryParameter("folder_name", item.fileName()).appendQueryParameter("id", item.path).build();
            foldersUris.add(uri);
        }
        return foldersUris;
    }
}

