/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.util.SparseArray;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.InvalidAuthenticationException;
import java.util.ArrayList;
import net.doo.snap.UploadConstants;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.ScanbotDialogFragment;
import net.doo.snap.ui.upload.AmazonCloudDriveActivity;
import net.doo.snap.ui.upload.AmazonCloudDriveChooserActivity;
import net.doo.snap.ui.upload.BoxActivity;
import net.doo.snap.ui.upload.DropboxActivity;
import net.doo.snap.ui.upload.DropboxChooserActivity;
import net.doo.snap.ui.upload.EvernoteActivity;
import net.doo.snap.ui.upload.EvernoteChooserActivity;
import net.doo.snap.ui.upload.GoogleDriveActivity;
import net.doo.snap.ui.upload.OneDriveActivity;
import net.doo.snap.ui.upload.OneDriveChooserActivity;
import net.doo.snap.ui.upload.ShoeboxedActivity;
import net.doo.snap.ui.upload.ShoeboxedChooserActivity;
import net.doo.snap.ui.upload.SlackActivity;
import net.doo.snap.ui.upload.SlackChooserActivity;
import net.doo.snap.ui.upload.SlackManualUploadFragment;
import net.doo.snap.ui.upload.TelekomCloudActivity;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.ui.upload.WebDavStorageActivity;
import net.doo.snap.ui.upload.WebdavChooserActivity;
import net.doo.snap.ui.upload.WunderlistActivity;
import net.doo.snap.ui.upload.WunderlistChooserActivity;
import net.doo.snap.ui.upload.YandexChooserActivity;
import net.doo.snap.ui.upload.YandexDiskActivity;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import org.jetbrains.annotations.Nullable;

public enum CloudStorage {
    DROPBOX(R.string.storage_dropbox, R.drawable.ui_settings_ico_dropbox, 1, "dropbox", DropboxActivity.class, 1),
    GOOGLE_DRIVE(R.string.storage_gdrive, R.drawable.ui_settings_ico_drive, 2, "google_drive", GoogleDriveActivity.class, 2),
    ONE_DRIVE(R.string.storage_onedrive, R.drawable.ui_settings_ico_onedrive, 3, "one_drive", OneDriveActivity.class, 3),
    BOX(R.string.storage_box, R.drawable.ui_settings_ico_box, 4, "box", BoxActivity.class, 4),
    EVERNOTE(R.string.storage_evernote, R.drawable.ui_settings_ico_evernote, 5, "evernote", EvernoteActivity.class, 5),
    SHOEBOXED(R.string.shoeboxed_title, R.drawable.ui_settings_ico_shoeboxed, 9, "shoeboxed", ShoeboxedActivity.class, 9),
    YANDEX_DISK(R.string.storage_yandex_disk, R.drawable.ui_settings_ico_yandex, 6, "yandex_disk", YandexDiskActivity.class, 6),
    WEBDAV_STORAGE(R.string.storage_webdav, R.drawable.ui_settings_ico_webdav, 7, "webdav_storage", WebDavStorageActivity.class, 7),
    TELEKOM_CLOUD(R.string.storage_telekom, R.drawable.ui_settings_ico_telekomcloud, 8, "telekom_cloud", TelekomCloudActivity.class, 8),
    AMAZON_CLOUD_DRIVE(R.string.storage_amazon, R.drawable.ui_settings_ico_amazon, 10, "amazon_cloud_drive", AmazonCloudDriveActivity.class, 10),
    WUNDERLIST(R.string.wunderlist_title, R.drawable.ui_reminder_ico_source_wunderlist, 11, "wunderlist", WunderlistActivity.class, 11),
    SLACK(R.string.storage_slack, R.drawable.ui_settings_ico_slack, 12, "slack", SlackActivity.class, 12);

    public static final String CLOUD_ID_KEY = "id";
    public static final String FOLDER_NAME_KEY = "folder_name";
    private static final SparseArray<CloudStorage> ids2Storages;
    private static final String DEFAULT_FOLDER_SUFFIX = "_default_folder";
    private final int nameResource;
    private final int iconResource;
    private final int databaseId;
    private final String accountNameKey;
    private final String defaultFolderKey;
    private final Class<? extends Activity> authActivityClass;
    private final int notificationId;

    private CloudStorage(int nameRes, int imgRes, int databaseId, String accountNameKey, Class<? extends Activity> authActivityClass, int notificationId) {
        this.nameResource = nameRes;
        this.iconResource = imgRes;
        this.databaseId = databaseId;
        this.accountNameKey = accountNameKey;
        this.defaultFolderKey = accountNameKey + DEFAULT_FOLDER_SUFFIX;
        this.authActivityClass = authActivityClass;
        this.notificationId = notificationId;
    }

    public int getNameResource() {
        return this.nameResource;
    }

    public int getIconResource() {
        return this.iconResource;
    }

    public int getDatabaseId() {
        return this.databaseId;
    }

    public static CloudStorage getByDatabaseId(int id2) {
        return (CloudStorage)((Object)ids2Storages.get(id2));
    }

    public Class<? extends Activity> getAuthActivityClass() {
        return this.authActivityClass;
    }

    public static boolean isConnected(CloudStorage target, Context context) {
        switch (target) {
            case DROPBOX: {
                SharedPreferences dropboxPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
                return dropboxPreferences.contains("DROPBOX_TOKEN_KEY") && dropboxPreferences.contains("DROPBOX_TOKEN_SECRET");
            }
            case GOOGLE_DRIVE: {
                SharedPreferences gdrivePreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
                return gdrivePreferences.contains(GOOGLE_DRIVE.getAccountNameKey());
            }
            case ONE_DRIVE: {
                SharedPreferences oneDrivePreferences = context.getSharedPreferences("com.microsoft.live", 0);
                return oneDrivePreferences.contains("refresh_token");
            }
            case BOX: {
                SharedPreferences boxPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
                return boxPreferences.contains("BOX_USERNAME") && boxPreferences.contains("BOX_PASS");
            }
            case EVERNOTE: {
                return EvernoteSession.getInstance((Context)context, (String)ManifestConstantsProvider.getConstantValue((Context)context, (String)"evernote_consumer_key"), (String)ManifestConstantsProvider.getConstantValue((Context)context, (String)"evernote_consumer_secret"), (EvernoteSession.EvernoteService)UploadConstants.EVERNOTE_HOST, (boolean)true).isLoggedIn();
            }
            case YANDEX_DISK: {
                SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
                return preferences.contains("YANDEX_TOKEN_KEY");
            }
            case WEBDAV_STORAGE: {
                SharedPreferences webdavPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
                return webdavPreferences.contains("WEBDAV_USERNAME") && webdavPreferences.contains("WEBDAV_PASS") && webdavPreferences.contains("WEBDAV_HOST");
            }
            case TELEKOM_CLOUD: {
                SharedPreferences telekomPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
                return telekomPreferences.contains("TELEKOM_USERNAME") && telekomPreferences.contains("TELEKOM_PASS");
            }
            case SHOEBOXED: {
                return PreferenceManager.getDefaultSharedPreferences((Context)context).contains("SHOEBOXED_REFRESH_TOKEN");
            }
            case AMAZON_CLOUD_DRIVE: {
                return PreferenceManager.getDefaultSharedPreferences((Context)context).contains("AMAZON_CLOUD_DRIVE_REFRESH_TOKEN");
            }
            case SLACK: {
                return PreferenceManager.getDefaultSharedPreferences((Context)context).contains("SLACK_ACCESS_TOKEN");
            }
            case WUNDERLIST: {
                return PreferenceManager.getDefaultSharedPreferences((Context)context).contains("WUNDERLIST_ACCESS_TOKEN");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void disconnect(CloudStorage target, Context context) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = preferences.edit();
        try {
            switch (target) {
                case DROPBOX: {
                    editor.remove("DROPBOX_TOKEN_KEY").remove("DROPBOX_TOKEN_SECRET");
                    return;
                }
                case GOOGLE_DRIVE: {
                    editor.remove(GOOGLE_DRIVE.getAccountNameKey());
                    return;
                }
                case BOX: {
                    editor.remove("BOX_USERNAME").remove("BOX_PASS");
                    return;
                }
                case YANDEX_DISK: {
                    editor.remove("YANDEX_TOKEN_KEY");
                    return;
                }
                case WEBDAV_STORAGE: {
                    editor.remove("WEBDAV_USERNAME").remove("WEBDAV_PASS").remove("WEBDAV_HOST");
                    return;
                }
                case TELEKOM_CLOUD: {
                    editor.remove("TELEKOM_USERNAME").remove("TELEKOM_PASS");
                    return;
                }
                case SHOEBOXED: {
                    editor.remove("SHOEBOXED_REFRESH_TOKEN").remove("SHOEBOXED_ACCESS_TOKEN");
                    return;
                }
                case EVERNOTE: {
                    EvernoteSession.getInstance((Context)context, (String)ManifestConstantsProvider.getConstantValue((Context)context, (String)"evernote_consumer_key"), (String)ManifestConstantsProvider.getConstantValue((Context)context, (String)"evernote_consumer_secret"), (EvernoteSession.EvernoteService)UploadConstants.EVERNOTE_HOST, (boolean)true).logOut(context);
                    return;
                }
                case ONE_DRIVE: {
                    SharedPreferences oneDrivePreferences = context.getSharedPreferences("com.microsoft.live", 0);
                    oneDrivePreferences.edit().remove("refresh_token").commit();
                    return;
                }
                case AMAZON_CLOUD_DRIVE: {
                    editor.remove("AMAZON_CLOUD_DRIVE_ACCESS_TOKEN").remove("AMAZON_CLOUD_DRIVE_REFRESH_TOKEN");
                    return;
                }
                case SLACK: {
                    editor.remove("SLACK_ACCESS_TOKEN");
                }
                case WUNDERLIST: {
                    editor.remove("WUNDERLIST_ACCESS_TOKEN");
                    return;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (InvalidAuthenticationException e) {
            DebugLog.logException((Throwable)e);
            return;
        }
        finally {
            editor.remove(target.getDefaultFolderKey());
            if (preferences.getInt("DEFAULT_STORAGE_ID", -1) == target.getDatabaseId()) {
                editor.remove("DEFAULT_STORAGE_ID");
            }
            editor.apply();
        }
    }

    public static Class<? extends Activity> getChooserActivity(CloudStorage target) {
        switch (target) {
            case DROPBOX: {
                return DropboxChooserActivity.class;
            }
            case EVERNOTE: {
                return EvernoteChooserActivity.class;
            }
            case GOOGLE_DRIVE: {
                return GoogleDriveActivity.class;
            }
            case ONE_DRIVE: {
                return OneDriveChooserActivity.class;
            }
            case YANDEX_DISK: {
                return YandexChooserActivity.class;
            }
            case BOX: 
            case WEBDAV_STORAGE: 
            case TELEKOM_CLOUD: {
                return WebdavChooserActivity.class;
            }
            case SHOEBOXED: {
                return ShoeboxedChooserActivity.class;
            }
            case AMAZON_CLOUD_DRIVE: {
                return AmazonCloudDriveChooserActivity.class;
            }
            case SLACK: {
                return SlackChooserActivity.class;
            }
            case WUNDERLIST: {
                return WunderlistChooserActivity.class;
            }
        }
        return null;
    }

    public static ScanbotDialogFragment getManualUploadFragment(CloudStorage target, ArrayList<UploadInfo> uploadInfos) {
        switch (target) {
            case SLACK: {
                return SlackManualUploadFragment.newInstance(uploadInfos);
            }
        }
        return null;
    }

    public String getAccountNameKey() {
        return this.accountNameKey;
    }

    public String getAccountName(SharedPreferences preferences) {
        return preferences.getString(this.accountNameKey, "");
    }

    public String getDefaultFolderKey() {
        return this.defaultFolderKey;
    }

    @Nullable
    public Uri getDefaultFolder(SharedPreferences preferences) {
        return preferences.contains(this.defaultFolderKey) ? Uri.parse((String)preferences.getString(this.defaultFolderKey, "")) : null;
    }

    public String getDefaultFolderInfo(SharedPreferences preferences) {
        String key;
        Uri defaultFolder = this.getDefaultFolder(preferences);
        switch (this) {
            case DROPBOX: {
                key = CLOUD_ID_KEY;
                break;
            }
            default: {
                key = FOLDER_NAME_KEY;
            }
        }
        return defaultFolder != null ? defaultFolder.getQueryParameter(key) : "Scanbot";
    }

    public boolean supportFolderChoosing() {
        switch (this) {
            case DROPBOX: 
            case GOOGLE_DRIVE: 
            case ONE_DRIVE: 
            case BOX: 
            case EVERNOTE: 
            case YANDEX_DISK: 
            case WEBDAV_STORAGE: 
            case TELEKOM_CLOUD: 
            case SHOEBOXED: 
            case AMAZON_CLOUD_DRIVE: 
            case SLACK: 
            case WUNDERLIST: {
                return true;
            }
        }
        return false;
    }

    public int getNotificationId() {
        return this.notificationId;
    }

    public String toString() {
        return this.name();
    }

    static {
        ids2Storages = new SparseArray();
        for (CloudStorage cloudStorage : CloudStorage.values()) {
            ids2Storages.put(cloudStorage.getDatabaseId(), (Object)cloudStorage);
        }
    }
}

