/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.evernote.client.android.EvernoteSession;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.Data;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.thrift.TException;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import net.doo.snap.UploadConstants;
import net.doo.snap.entity.DocumentType;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.EvernoteBusinessUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.MimeUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;

class EvernoteUploader
implements CloudUploader {
    private static final int BUFFER_SIZE_BYTES = 4096;
    @Inject
    private Context context;
    @Inject
    private SharedPreferences preferences;
    @Inject
    private EvernoteBusinessUploader businessUploader;
    private EvernoteSession evernoteSession;

    @Inject
    EvernoteUploader() {
    }

    @Override
    public synchronized void upload(UploadInfo info, OnFileUploadListener onFileUploadListener) throws IOException {
        if (this.evernoteSession == null) {
            this.evernoteSession = EvernoteSession.getInstance((Context)this.context, (String)ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"evernote_consumer_key"), (String)ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"evernote_consumer_secret"), (EvernoteSession.EvernoteService)UploadConstants.EVERNOTE_HOST, (boolean)true);
        }
        this.findNotebookAndSaveFile(info, onFileUploadListener);
    }

    private void findNotebookAndSaveFile(UploadInfo info, OnFileUploadListener listener) {
        String id2 = info.getId();
        try {
            this.ensureLoggedIn();
            if (!this.saveNoteIfNotebookExists(info, listener)) {
                Notebook scanbotNotebook = new Notebook();
                scanbotNotebook.setName("Scanbot");
                Notebook newNotebook = this.evernoteSession.getClientFactory().createNoteStoreClient().getClient().createNotebook(this.evernoteSession.getAuthToken(), scanbotNotebook);
                this.saveNoteToNotebook(info, newNotebook, listener);
            }
        }
        catch (EDAMUserException | AuthorizationException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadAuthorizationFailed(id2, CloudStorage.EVERNOTE);
        }
        catch (EDAMNotFoundException | EDAMSystemException | TException | IOException | NoSuchAlgorithmException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.EVERNOTE);
        }
    }

    private boolean saveNoteIfNotebookExists(UploadInfo info, OnFileUploadListener listener) throws TException, EDAMUserException, EDAMSystemException, IOException, NoSuchAlgorithmException, EDAMNotFoundException {
        String defaultNotebookName = this.preferences.contains(CloudStorage.EVERNOTE.getDefaultFolderKey()) ? CloudStorage.EVERNOTE.getDefaultFolder(this.preferences).getQueryParameter("id") : "Scanbot";
        List notebooks = this.evernoteSession.getClientFactory().createNoteStoreClient().getClient().listNotebooks(this.evernoteSession.getAuthToken());
        for (Notebook item : notebooks) {
            if (!item.getName().equals(defaultNotebookName)) continue;
            this.saveNoteToNotebook(info, item, listener);
            return true;
        }
        return false;
    }

    private void saveNoteToNotebook(UploadInfo info, Notebook notebook, OnFileUploadListener listener) throws IOException, NoSuchAlgorithmException, TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        Note note = null;
        if (!TextUtils.isEmpty((CharSequence)info.getCloudFileId())) {
            note = this.getNoteByGuid(info.getCloudFileId());
        }
        note = note == null ? this.createNoteAndSave(info, notebook) : this.saveExistingNote(info, note);
        listener.onUploadFinished(info.getId(), CloudStorage.EVERNOTE, note == null ? "" : note.getGuid());
    }

    private Note getNoteByGuid(String guid) throws TException, EDAMUserException, EDAMSystemException {
        Note note = null;
        try {
            note = this.evernoteSession.getClientFactory().createNoteStoreClient().getClient().getNote(this.evernoteSession.getAuthToken(), guid, false, false, false, false);
        }
        catch (EDAMNotFoundException e) {
            DebugLog.logException((Throwable)e);
        }
        return note;
    }

    private Note saveExistingNote(UploadInfo info, Note note) throws IOException, NoSuchAlgorithmException, TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        this.setNoteInfo(info, note);
        this.setNoteAttachment(info.getFile(), note);
        note = this.evernoteSession.getClientFactory().createNoteStoreClient().getClient().updateNote(this.evernoteSession.getAuthToken(), note);
        return note;
    }

    private Note createNoteAndSave(UploadInfo info, Notebook notebook) throws IOException, NoSuchAlgorithmException, TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        Note note = new Note();
        this.setNoteInfo(info, note);
        this.setNoteAttachment(info.getFile(), note);
        note.setNotebookGuid(notebook.getGuid());
        note = this.evernoteSession.getClientFactory().createNoteStoreClient().getClient().createNote(this.evernoteSession.getAuthToken(), note);
        return note;
    }

    protected void setNoteInfo(UploadInfo info, Note note) {
        note.setTitle(info.getFile().getName());
        DocumentType docType = DocumentType.getByMimeType((String)info.getType());
        if (docType != DocumentType.UNKNOWN) {
            note.setTagNames(Arrays.asList(docType.getDisplayName(this.context)));
        }
    }

    protected void setNoteAttachment(File file, Note note) throws NoSuchAlgorithmException, IOException {
        Data data = new Data();
        data.setBodyHash(this.getBodyMD5Hash(file));
        data.setBody(FileUtils.readFileToByteArray((File)file));
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setFileName(file.getName());
        Resource resource = new Resource();
        resource.setMime(MimeUtils.getMimeByName((String)file.getName()));
        resource.setData(data);
        resource.setAttributes(attributes);
        note.addToResources(resource);
        this.addAttachmentToNoteBody(note, resource);
    }

    protected void addAttachmentToNoteBody(Note note, Resource res) {
        String hexhash = new String(Hex.encodeHex((byte[])res.getData().getBodyHash()));
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\"><en-note><en-media type=\"" + res.getMime() + "\" hash=\"" + hexhash + "\"/>" + "</en-note>";
        note.setContent(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getBodyMD5Hash(File file) throws NoSuchAlgorithmException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] bytes = new byte[4096];
            int read = 0;
            while ((read = fis.read(bytes)) != -1) {
                digest.update(bytes, 0, read);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
    }

    private void ensureLoggedIn() throws AuthorizationException {
        if (this.evernoteSession == null || !this.evernoteSession.isLoggedIn()) {
            throw new AuthorizationException();
        }
    }

    public static class AuthorizationException
    extends Exception {
    }
}

