/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud.wunderlist;

import android.app.Activity;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.Loader;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.upload.cloud.wunderlist.WunderlistApi;
import net.doo.snap.upload.cloud.wunderlist.model.TokenResponse;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.loading.SingleThreadLoader;
import net.doo.snap.util.log.DebugLog;
import roboguice.activity.RoboFragmentActivity;

public class WunderlistAuthActivity
extends RoboFragmentActivity
implements LoaderManager.LoaderCallbacks<Boolean> {
    private static final String WUNDERLIST_AUTH_URL = "https://www.wunderlist.com/oauth/authorize";
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String STATE_KEY = "state";
    private static final String REDIRECT_URL_KEY = "redirect_uri";
    private static final String CODE_KEY = "code";
    private static final String RANDOM_STATE = "jhjeKJU432Hggwuun83gerjj";
    @Inject
    private WunderlistApi wunderlistApi;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        WebView webview = new WebView((Context)this);
        webview.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith(ManifestConstantsProvider.getConstantValue((Context)WunderlistAuthActivity.this, (String)"wunderlist_redirect_url"))) {
                    Uri uri = Uri.parse((String)url);
                    String code = uri.getQueryParameter(WunderlistAuthActivity.CODE_KEY);
                    view.setVisibility(8);
                    Bundle params = new Bundle();
                    params.putString(WunderlistAuthActivity.CODE_KEY, code);
                    WunderlistAuthActivity.this.getLoaderManager().restartLoader(0, params, (LoaderManager.LoaderCallbacks)WunderlistAuthActivity.this);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        });
        Uri uri = new Uri.Builder().encodedPath(WUNDERLIST_AUTH_URL).appendQueryParameter(CLIENT_ID_KEY, ManifestConstantsProvider.getConstantValue((Context)this, (String)"wunderlist_client_id")).appendQueryParameter(STATE_KEY, RANDOM_STATE).appendQueryParameter(REDIRECT_URL_KEY, ManifestConstantsProvider.getConstantValue((Context)this, (String)"wunderlist_redirect_url")).build();
        webview.loadUrl(uri.toString());
        this.setContentView((View)webview);
    }

    public Loader<Boolean> onCreateLoader(int id2, final Bundle args) {
        return new SingleThreadLoader<Boolean>((Context)this){

            protected Boolean doInBackground() {
                String code = args.getString(WunderlistAuthActivity.CODE_KEY, null);
                try {
                    TokenResponse tokens = WunderlistAuthActivity.this.wunderlistApi.getTokensByCode(code);
                    if (tokens != null) {
                        WunderlistAuthActivity.this.wunderlistApi.saveTokens(tokens);
                        return true;
                    }
                }
                catch (IOException e) {
                    DebugLog.logException((Throwable)e);
                }
                return false;
            }
        };
    }

    public void onLoadFinished(Loader<Boolean> loader, Boolean success) {
        Intent intent = new Intent();
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)(success != false ? -1 : 0), (Intent)intent);
    }

    public void onLoaderReset(Loader<Boolean> loader) {
    }
}

