/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.TextView;
import com.google.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;

public class AuthYandexDiskActivity
extends CustomThemeActivity {
    public static final String WAITING_FOR_RESULT = "WAITING_FOR_RESULT";
    private boolean waitingForResult;
    @Inject
    private SharedPreferences preferences;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_storage);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.YANDEX_DISK.getNameResource())}));
        if (savedInstanceState != null) {
            this.waitingForResult = savedInstanceState.getBoolean(WAITING_FOR_RESULT);
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.getIntent() != null && this.getIntent().getData() != null) {
            this.onLogin(this.getIntent());
            this.waitingForResult = false;
            return;
        }
        if (this.waitingForResult) {
            this.preferences.edit().remove("YANDEX_TOKEN_KEY").commit();
            this.finish();
        } else {
            this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://oauth.yandex.ru/authorize?response_type=token&client_id=" + ManifestConstantsProvider.getConstantValue((Context)this, (String)"yandex_client_id")))));
            this.waitingForResult = true;
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(WAITING_FOR_RESULT, this.waitingForResult);
    }

    private void onLogin(Intent intent) {
        Uri data = intent.getData();
        this.setIntent(null);
        Pattern pattern = Pattern.compile("access_token=(.*?)(&|$)");
        Matcher matcher = pattern.matcher(data.toString());
        if (matcher.find()) {
            String token = matcher.group(1);
            if (!TextUtils.isEmpty((CharSequence)token)) {
                DebugLog.d((String)("onLogin: token: " + token));
                this.saveToken(token);
            } else {
                DebugLog.e((String)"onRegistrationSuccess: empty token");
            }
        } else {
            DebugLog.e((String)"onRegistrationSuccess: token not found in return url");
        }
        this.finish();
    }

    private void saveToken(String token) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString("YANDEX_TOKEN_KEY", token);
        editor.commit();
    }
}

