/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.Loader;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.google.inject.Inject;
import io.scanbot.shoeboxed.ApiApplication;
import io.scanbot.shoeboxed.ShoeboxedApi;
import io.scanbot.shoeboxed.ShoeboxedSession;
import io.scanbot.shoeboxed.entity.Account;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.doo.snap.connectivity.ConnectionChecker;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.loading.SingleThreadLoader;
import net.doo.snap.util.log.DebugLog;
import roboguice.inject.InjectView;

public class ShoeboxedAccountChooserActivity
extends CustomThemeActivity
implements LoaderManager.LoaderCallbacks<List<Account>> {
    public static final String RESULT_ACCOUNT = "RESULT_ACCOUNT";
    @Inject
    private SharedPreferences preferences;
    @Inject
    private LayoutInflater layoutInflater;
    @Inject
    private ConnectionChecker connectionChecker;
    private View progressBar;
    @InjectView(value=16908298)
    private ListView listView;
    private final List<Account> accounts = new ArrayList<Account>();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_account_chooser);
        this.progressBar = this.findViewById(R.id.progress_bar);
        this.listView.setAdapter((ListAdapter)new AccountsAdapter());
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
                Account account = (Account)ShoeboxedAccountChooserActivity.this.listView.getItemAtPosition(position);
                ShoeboxedAccountChooserActivity.this.deliverResult(account);
            }
        });
        if (this.connectionChecker.isConnected()) {
            this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this).forceLoad();
        } else {
            this.deliverResult(null);
        }
    }

    public Loader<List<Account>> onCreateLoader(int i, Bundle bundle) {
        return new AccountsLoader((Context)this, this.preferences);
    }

    public void onLoadFinished(Loader<List<Account>> listLoader, List<Account> accounts) {
        switch (accounts.size()) {
            case 0: {
                this.deliverResult(null);
                break;
            }
            case 1: {
                this.deliverResult(accounts.get(0));
                break;
            }
            default: {
                this.accounts.clear();
                this.accounts.addAll(accounts);
                this.progressBar.setVisibility(8);
                this.listView.setVisibility(0);
            }
        }
    }

    public void onLoaderReset(Loader<List<Account>> listLoader) {
        this.progressBar.setVisibility(0);
        this.listView.setVisibility(8);
    }

    private void deliverResult(Account account) {
        if (account == null) {
            this.setResult(0);
        } else {
            Intent intent = new Intent();
            intent.putExtra(RESULT_ACCOUNT, (Serializable)account);
            this.setResult(-1, intent);
        }
        this.finish();
    }

    private static class AccountsLoader
    extends SingleThreadLoader<List<Account>> {
        private final SharedPreferences preferences;
        private ShoeboxedApi shoeboxedApi;

        public AccountsLoader(Context context, SharedPreferences preferences) {
            super(context);
            this.preferences = preferences;
        }

        protected List<Account> doInBackground() {
            this.ensureApiInitialized();
            try {
                return this.shoeboxedApi.getAccounts();
            }
            catch (Exception e) {
                DebugLog.logException((Throwable)e);
                return Collections.emptyList();
            }
        }

        private void ensureApiInitialized() {
            if (this.shoeboxedApi != null) {
                return;
            }
            ApiApplication apiApplication = new ApiApplication(ManifestConstantsProvider.getConstantValue((Context)this.getContext(), (String)"shoeboxed_api_client_id"), ManifestConstantsProvider.getConstantValue((Context)this.getContext(), (String)"shoeboxed_api_secret"), ManifestConstantsProvider.getConstantValue((Context)this.getContext(), (String)"shoeboxed_api_redirect_url"));
            ShoeboxedSession session = new ShoeboxedSession.Builder(apiApplication).accessToken(this.preferences.getString("SHOEBOXED_ACCESS_TOKEN", null)).refreshToken(this.preferences.getString("SHOEBOXED_REFRESH_TOKEN", null)).build();
            this.shoeboxedApi = ShoeboxedApi.forSession((ShoeboxedSession)session);
        }
    }

    private class AccountsAdapter
    extends BaseAdapter {
        private AccountsAdapter() {
        }

        public View getView(int position, View convertView, ViewGroup viewGroup) {
            View view = convertView;
            if (view == null) {
                view = ShoeboxedAccountChooserActivity.this.layoutInflater.inflate(R.layout.account_chooser_item, viewGroup, false);
                view.setTag((Object)new ViewHolder(view));
            }
            ViewHolder holder = (ViewHolder)view.getTag();
            holder.name.setText((CharSequence)((Account)ShoeboxedAccountChooserActivity.this.accounts.get(position)).getLabel());
            return view;
        }

        public int getCount() {
            return ShoeboxedAccountChooserActivity.this.accounts.size();
        }

        public Object getItem(int position) {
            return ShoeboxedAccountChooserActivity.this.accounts.get(position);
        }

        public long getItemId(int position) {
            return ((Account)ShoeboxedAccountChooserActivity.this.accounts.get(position)).getId();
        }

        class ViewHolder {
            final TextView name;

            ViewHolder(View item) {
                this.name = (TextView)item.findViewById(R.id.name);
            }
        }
    }
}

