/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcelable;
import android.widget.TextView;
import com.google.inject.Inject;
import com.microsoft.live.LiveAuthClient;
import com.microsoft.live.LiveAuthException;
import com.microsoft.live.LiveAuthListener;
import com.microsoft.live.LiveConnectClient;
import com.microsoft.live.LiveConnectSession;
import com.microsoft.live.LiveOperation;
import com.microsoft.live.LiveOperationException;
import com.microsoft.live.LiveOperationListener;
import com.microsoft.live.LiveStatus;
import java.util.Arrays;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.auth.ConnectionResult;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.log.DebugLog;
import org.json.JSONObject;

public class OneDriveActivity
extends CustomThemeActivity
implements LiveAuthListener {
    @Inject
    private SharedPreferences preferences;
    private static final String TAG = "OneDriveAuthClient";
    private static final String ACCOUNT_NAME = "ACCOUNT_NAME";
    private static final int CHOOSER_REQUEST_CODE = 1;
    private static final Iterable<String> SCOPES = Arrays.asList("wl.signin", "wl.skydrive_update", "wl.offline_access");
    private static final String USER_INFO_PATH = "me";
    private static final String JSON_NAME_KEY = "name";
    private LiveAuthClient auth;
    private LiveConnectClient client;
    private String accountName;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_storage);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.ONE_DRIVE.getNameResource())}));
        this.auth = new LiveAuthClient((Context)this, ManifestConstantsProvider.getConstantValue((Context)this, (String)"onedrive_client_id"));
        if (savedInstanceState != null) {
            this.accountName = savedInstanceState.getString(ACCOUNT_NAME);
        }
    }

    protected void onStart() {
        super.onStart();
        this.auth = new LiveAuthClient((Context)this, ManifestConstantsProvider.getConstantValue((Context)this, (String)"onedrive_client_id"));
        this.auth.login((Activity)this, SCOPES, (LiveAuthListener)this);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1) {
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.ONE_DRIVE, this.accountName));
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(ACCOUNT_NAME, this.accountName);
    }

    public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object userState) {
        if (status == LiveStatus.CONNECTED) {
            this.client = new LiveConnectClient(session);
            this.client.getAsync(USER_INFO_PATH, new LiveOperationListener(){

                public void onComplete(LiveOperation operation) {
                    JSONObject result = operation.getResult();
                    OneDriveActivity.this.accountName = result.optString(OneDriveActivity.JSON_NAME_KEY);
                    OneDriveActivity.this.preferences.edit().remove(CloudStorage.ONE_DRIVE.getDefaultFolderKey()).commit();
                    OneDriveActivity.this.startActivityForResult(new Intent((Context)OneDriveActivity.this, CloudStorage.getChooserActivity(CloudStorage.ONE_DRIVE)), 1);
                }

                public void onError(LiveOperationException exception, LiveOperation operation) {
                    OneDriveActivity.this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.ONE_DRIVE, null));
                }
            });
        } else {
            this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.ONE_DRIVE, null));
        }
    }

    public void onAuthError(LiveAuthException exception, Object userState) {
        DebugLog.e((String)TAG, (String)"LiveAuthClient connection failed!", (Throwable)exception);
        this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.ONE_DRIVE, null));
    }

    private void deliverConnectionResult(ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }
}

