/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.webdav;

import android.text.TextUtils;
import ch.boye.httpclientandroidlib.conn.ssl.TrustStrategy;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.doo.snap.upload.webdav.SelfSignedCertificateException;
import net.doo.snap.util.log.DebugLog;
import org.jetbrains.annotations.NotNull;

public class ImportKeystoreTrustStrategy
implements TrustStrategy {
    private static final String X509_ALGORITHM = "X509";
    private static X509TrustManager defaultTrustManager = null;
    private X509TrustManager localTrustManager = null;
    private KeyStoreProvider keyStoreProvider;

    public ImportKeystoreTrustStrategy(@NotNull KeyStoreProvider keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    private void initLocalTrustManager(KeyStore keyStore) {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(X509_ALGORITHM);
            factory.init(keyStore);
            this.localTrustManager = this.findX509TrustManager(factory);
        }
        catch (NoSuchAlgorithmException e) {
            DebugLog.logException((Throwable)e);
        }
        catch (KeyStoreException e) {
            DebugLog.logException((Throwable)e);
        }
    }

    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0 || TextUtils.isEmpty((CharSequence)authType)) {
            return false;
        }
        this.ensureLocalTrustManager();
        this.ensureDefaultTrustManager();
        if (this.localTrustManager != null) {
            try {
                this.localTrustManager.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        try {
            defaultTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            if (chain.length == 1) {
                throw new SelfSignedCertificateException(chain[0]);
            }
            throw e;
        }
        return true;
    }

    private void ensureLocalTrustManager() {
        if (this.localTrustManager != null) {
            return;
        }
        KeyStore keyStore = this.keyStoreProvider.getKeyStore();
        if (keyStore != null) {
            this.initLocalTrustManager(keyStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDefaultTrustManager() throws CertificateException {
        if (defaultTrustManager != null) {
            return;
        }
        ImportKeystoreTrustStrategy importKeystoreTrustStrategy = this;
        synchronized (importKeystoreTrustStrategy) {
            try {
                this.initDefaultTrustManager();
            }
            catch (NoSuchAlgorithmException e) {
                throw new CertificateException(e);
            }
            catch (KeyStoreException e) {
                throw new CertificateException(e);
            }
        }
    }

    private void initDefaultTrustManager() throws NoSuchAlgorithmException, CertificateException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(X509_ALGORITHM);
        factory.init((KeyStore)null);
        defaultTrustManager = this.findX509TrustManager(factory);
        if (defaultTrustManager == null) {
            throw new CertificateException();
        }
    }

    private X509TrustManager findX509TrustManager(TrustManagerFactory factory) {
        TrustManager[] trustManagers;
        for (TrustManager manager : trustManagers = factory.getTrustManagers()) {
            if (!(manager instanceof X509TrustManager)) continue;
            return (X509TrustManager)manager;
        }
        return null;
    }

    public static interface KeyStoreProvider {
        public KeyStore getKeyStore();
    }
}

