/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.Activity;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.Loader;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.widget.TextView;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.auth.ConnectionResult;
import net.doo.snap.upload.cloud.wunderlist.ForbiddenException;
import net.doo.snap.upload.cloud.wunderlist.WunderlistApi;
import net.doo.snap.upload.cloud.wunderlist.WunderlistAuthActivity;
import net.doo.snap.upload.cloud.wunderlist.model.ProfileResponse;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.loading.SingleThreadLoader;
import net.doo.snap.util.log.DebugLog;

public class WunderlistActivity
extends CustomThemeActivity
implements LoaderManager.LoaderCallbacks<ProfileResponse> {
    private static final int WUNDERLIST_AUTH_ACTIVITY_CODE = 23220;
    private static final int WUNDERLIST_CHOOSER_ACTIVITY_CODE = 23221;
    private static final String ACCOUNT_NAME = "ACCOUNT_NAME";
    @Inject
    private WunderlistApi wunderlistApi;
    @Inject
    private SharedPreferences preferences;
    private String accountName;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_storage);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.WUNDERLIST.getNameResource())}));
        if (savedInstanceState != null) {
            this.accountName = savedInstanceState.getString(ACCOUNT_NAME);
        }
        if (TextUtils.isEmpty((CharSequence)this.accountName)) {
            Intent intent = new Intent((Context)this, WunderlistAuthActivity.class);
            this.startActivityForResult(intent, 23220);
        } else {
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.WUNDERLIST, this.accountName));
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(ACCOUNT_NAME, this.accountName);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 23220) {
            if (resultCode == -1) {
                this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
            } else {
                this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.WUNDERLIST, null));
            }
        } else if (requestCode == 23221) {
            if (resultCode != -1) {
                Uri folderUri = new Uri.Builder().appendQueryParameter("folder_name", "Scanbot").build();
                SharedPreferences.Editor edit = this.preferences.edit();
                edit.putString(CloudStorage.WUNDERLIST.getDefaultFolderKey(), folderUri.toString());
                edit.apply();
            }
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.WUNDERLIST, this.accountName));
        }
    }

    private void deliverConnectionResult(ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }

    public Loader<ProfileResponse> onCreateLoader(int id2, Bundle args) {
        return new SingleThreadLoader<ProfileResponse>((Context)this){

            protected ProfileResponse doInBackground() {
                try {
                    return WunderlistActivity.this.wunderlistApi.getProfile();
                }
                catch (IOException | ForbiddenException e) {
                    DebugLog.logException((Throwable)e);
                    return null;
                }
            }
        };
    }

    public void onLoadFinished(Loader loader, ProfileResponse profile) {
        if (profile != null) {
            this.accountName = profile.getEmail();
            this.preferences.edit().remove(CloudStorage.WUNDERLIST.getDefaultFolderKey()).apply();
            this.startActivityForResult(new Intent((Context)this, CloudStorage.getChooserActivity(CloudStorage.WUNDERLIST)), 23221);
        } else {
            this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.WUNDERLIST, null));
        }
    }

    public void onLoaderReset(Loader loader) {
    }
}

