/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.Context;
import android.content.SharedPreferences;
import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.android.AndroidAuthSession;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.exception.DropboxUnlinkedException;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;

class DropboxUploader
implements CloudUploader {
    @Inject
    private SharedPreferences preferences;
    @Inject
    private Context context;
    private DropboxAPI<AndroidAuthSession> api;

    @Inject
    DropboxUploader() {
    }

    @Override
    public synchronized void upload(UploadInfo info, OnFileUploadListener listener) throws IOException {
        this.initDropboxAPI();
        this.saveFileToDropbox(info, listener);
    }

    private void saveFileToDropbox(UploadInfo info, OnFileUploadListener listener) {
        String id2 = info.getId();
        try {
            String path = this.preferences.contains(CloudStorage.DROPBOX.getDefaultFolderKey()) ? CloudStorage.DROPBOX.getDefaultFolder(this.preferences).getQueryParameter("id") : File.separator + "Scanbot";
            File file = info.getFile();
            FileInputStream stream = new FileInputStream(file);
            DropboxAPI.Entry response = this.api.putFileOverwrite(path + File.separator + file.getName(), (InputStream)stream, (long)stream.available(), null);
            if (response != null && response.rev != null) {
                DebugLog.i((String)("The uploaded file's rev is: " + response.rev));
                DebugLog.i((String)"File upload success");
                listener.onUploadFinished(id2, CloudStorage.DROPBOX, response.path);
            } else {
                DebugLog.w((String)"File upload failed!");
                listener.onUploadFailed(id2, CloudStorage.DROPBOX);
            }
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.DROPBOX);
        }
        catch (DropboxUnlinkedException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadAuthorizationFailed(id2, CloudStorage.DROPBOX);
        }
        catch (DropboxException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.DROPBOX);
        }
    }

    private void initDropboxAPI() {
        AppKeyPair appKeys = new AppKeyPair(ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"dropbox_app_key"), ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"dropbox_app_secret"));
        AndroidAuthSession session = new AndroidAuthSession(appKeys, Session.AccessType.DROPBOX);
        this.api = new DropboxAPI((Session)session);
        if (this.preferences.contains("DROPBOX_TOKEN_KEY") && this.preferences.contains("DROPBOX_TOKEN_SECRET")) {
            AccessTokenPair tokens = new AccessTokenPair(this.preferences.getString("DROPBOX_TOKEN_KEY", null), this.preferences.getString("DROPBOX_TOKEN_SECRET", null));
            ((AndroidAuthSession)this.api.getSession()).setAccessTokenPair(tokens);
        }
    }
}

