/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud.amazon;

import android.app.Activity;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.Loader;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.upload.cloud.amazon.AmazonCloudDriveApi;
import net.doo.snap.upload.cloud.amazon.model.TokenResponse;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.loading.SingleThreadLoader;
import net.doo.snap.util.log.DebugLog;
import roboguice.activity.RoboFragmentActivity;

public class AmazonAuthActivity
extends RoboFragmentActivity
implements LoaderManager.LoaderCallbacks<Boolean> {
    private static final String AMAZON_AUTH_URL = "https://www.amazon.com/ap/oa";
    private static final String SCOPES = "clouddrive:read clouddrive:write profile";
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String SCOPE_KEY = "scope";
    private static final String RESPONSE_TYPE_KEY = "response_type";
    private static final String REDIRECT_URL_KEY = "redirect_uri";
    private static final String CODE_KEY = "code";
    @Inject
    AmazonCloudDriveApi amazonCloudDriveApi;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        WebView webview = new WebView((Context)this);
        webview.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith(ManifestConstantsProvider.getConstantValue((Context)AmazonAuthActivity.this, (String)"amazon_redirect_url"))) {
                    Uri uri = Uri.parse((String)url);
                    String code = uri.getQueryParameter(AmazonAuthActivity.CODE_KEY);
                    view.setVisibility(8);
                    Bundle params = new Bundle();
                    params.putString(AmazonAuthActivity.CODE_KEY, code);
                    AmazonAuthActivity.this.getLoaderManager().restartLoader(0, params, (LoaderManager.LoaderCallbacks)AmazonAuthActivity.this);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        });
        Uri uri = new Uri.Builder().encodedPath(AMAZON_AUTH_URL).appendQueryParameter(CLIENT_ID_KEY, ManifestConstantsProvider.getConstantValue((Context)this, (String)"amazon_client_id")).appendQueryParameter(SCOPE_KEY, SCOPES).appendQueryParameter(RESPONSE_TYPE_KEY, CODE_KEY).appendQueryParameter(REDIRECT_URL_KEY, ManifestConstantsProvider.getConstantValue((Context)this, (String)"amazon_redirect_url")).build();
        webview.loadUrl(uri.toString());
        this.setContentView((View)webview);
    }

    public Loader<Boolean> onCreateLoader(int id2, final Bundle args) {
        return new SingleThreadLoader<Boolean>((Context)this){

            protected Boolean doInBackground() {
                String code = args.getString(AmazonAuthActivity.CODE_KEY, null);
                try {
                    TokenResponse tokens = AmazonAuthActivity.this.amazonCloudDriveApi.getTokensByCode(code);
                    if (tokens != null) {
                        AmazonAuthActivity.this.amazonCloudDriveApi.saveTokens(tokens);
                        return true;
                    }
                }
                catch (IOException e) {
                    DebugLog.logException((Throwable)e);
                }
                return false;
            }
        };
    }

    public void onLoadFinished(Loader<Boolean> loader, Boolean success) {
        Intent intent = new Intent();
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)(success != false ? -1 : 0), (Intent)intent);
    }

    public void onLoaderReset(Loader<Boolean> loader) {
    }
}

