/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.webdav;

import com.google.inject.Inject;
import de.aflx.sardine.Sardine;
import de.aflx.sardine.SardineFactory;
import java.io.IOException;
import java.net.ProxySelector;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import net.doo.snap.security.LocalKeystoreManager;
import net.doo.snap.upload.webdav.ImportKeystoreSardineImpl;
import net.doo.snap.util.log.DebugLog;

public class ImportKeystoreSardineFactory
extends SardineFactory {
    private LocalKeystoreManager localKeystoreManager;

    @Inject
    public ImportKeystoreSardineFactory(LocalKeystoreManager localKeystoreManager) {
        this.localKeystoreManager = localKeystoreManager;
    }

    public Sardine begin(String username, String password, ProxySelector proxy) {
        try {
            ImportKeystoreSardineImpl sardine = new ImportKeystoreSardineImpl(username, password, proxy, this.localKeystoreManager.getKeyStore());
            return sardine;
        }
        catch (KeyStoreException e) {
            DebugLog.logException((Throwable)e);
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
        }
        catch (CertificateException e) {
            DebugLog.logException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            DebugLog.logException((Throwable)e);
        }
        return super.begin(username, password, proxy);
    }
}

