/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.widget.TextView;
import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.android.AndroidAuthSession;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import com.google.inject.Inject;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.auth.ConnectionResult;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.log.DebugLog;

public class DropboxActivity
extends CustomThemeActivity {
    private static final String ACCOUNT_NAME = "ACCOUNT_NAME";
    private static final int CHOOSER_REQUEST_CODE = 1;
    @Inject
    private SharedPreferences preferences;
    private String accountName;
    private DropboxAPI<AndroidAuthSession> api;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_storage);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.DROPBOX.getNameResource())}));
        if (savedInstanceState != null) {
            this.accountName = savedInstanceState.getString(ACCOUNT_NAME);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.api == null) {
            this.initDropboxAPI();
        } else {
            this.finishAuthorization();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.DROPBOX, this.accountName));
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(ACCOUNT_NAME, this.accountName);
    }

    private void initDropboxAPI() {
        AppKeyPair appKeys = new AppKeyPair(ManifestConstantsProvider.getConstantValue((Context)this, (String)"dropbox_app_key"), ManifestConstantsProvider.getConstantValue((Context)this, (String)"dropbox_app_secret"));
        AndroidAuthSession session = new AndroidAuthSession(appKeys, Session.AccessType.DROPBOX);
        this.api = new DropboxAPI((Session)session);
        if (this.preferences.contains("DROPBOX_TOKEN_KEY") && this.preferences.contains("DROPBOX_TOKEN_SECRET")) {
            AccessTokenPair tokens = new AccessTokenPair(this.preferences.getString("DROPBOX_TOKEN_KEY", null), this.preferences.getString("DROPBOX_TOKEN_SECRET", null));
            ((AndroidAuthSession)this.api.getSession()).setAccessTokenPair(tokens);
        }
        ((AndroidAuthSession)this.api.getSession()).startAuthentication((Context)this);
    }

    private void storeKeys(AccessTokenPair tokens) {
        this.preferences.edit().putString("DROPBOX_TOKEN_KEY", tokens.key).putString("DROPBOX_TOKEN_SECRET", tokens.secret).commit();
    }

    public void finishAuthorization() {
        if (!((AndroidAuthSession)this.api.getSession()).authenticationSuccessful()) {
            this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.DROPBOX, null));
            return;
        }
        new AsyncTask<Void, Void, ConnectionResult>(){

            protected ConnectionResult doInBackground(Void ... params) {
                boolean success = false;
                try {
                    ((AndroidAuthSession)DropboxActivity.this.api.getSession()).finishAuthentication();
                    AccessTokenPair tokens = ((AndroidAuthSession)DropboxActivity.this.api.getSession()).getAccessTokenPair();
                    DropboxActivity.this.storeKeys(tokens);
                    if (DropboxActivity.this.api.accountInfo() != null) {
                        DropboxActivity.this.accountName = ((DropboxActivity)DropboxActivity.this).api.accountInfo().displayName;
                    }
                    success = true;
                }
                catch (DropboxException e) {
                    DebugLog.e((String)"DROPBOX_AUTH", (String)"Error authenticating", (Throwable)e);
                }
                return new ConnectionResult(success, CloudStorage.DROPBOX, DropboxActivity.this.accountName);
            }

            protected void onPostExecute(ConnectionResult result) {
                super.onPostExecute((Object)result);
                DropboxActivity.this.preferences.edit().remove(CloudStorage.DROPBOX.getDefaultFolderKey()).commit();
                DropboxActivity.this.startActivityForResult(new Intent((Context)DropboxActivity.this, CloudStorage.getChooserActivity(CloudStorage.DROPBOX)), 1);
            }
        }.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
    }

    private void deliverConnectionResult(ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }
}

