/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.upload.ChooserActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.amazon.AmazonCloudDriveApi;
import net.doo.snap.upload.cloud.amazon.ForbiddenException;
import net.doo.snap.upload.cloud.amazon.model.AmazonFolder;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.ExecutionUtils;

public class AmazonCloudDriveChooserActivity
extends ChooserActivity {
    @Inject
    private AmazonCloudDriveApi amazonCloudDriveApi;

    @Override
    protected void init() {
        this.chooserStorage = CloudStorage.AMAZON_CLOUD_DRIVE;
        AmazonFolder root = null;
        try {
            root = this.amazonCloudDriveApi.getRootFolder();
        }
        catch (IOException | ForbiddenException e) {
            DebugLog.logException((Throwable)e);
        }
        if (root != null) {
            Uri rootUri = new Uri.Builder().appendQueryParameter("folder_name", root.getName()).appendQueryParameter("id", String.valueOf(root.getId())).build();
            this.foldersHierarchy.add(rootUri);
        }
    }

    @Override
    protected void createFolder(String name) {
        String currentRootId = ((Uri)this.foldersHierarchy.getLast()).getQueryParameter("id");
        if (!TextUtils.isEmpty((CharSequence)currentRootId)) {
            try {
                this.amazonCloudDriveApi.createFolder(name, currentRootId);
            }
            catch (IOException | ForbiddenException e) {
                DebugLog.logException((Throwable)e);
                ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
            }
        }
    }

    @Override
    protected List<Uri> loadFolders() {
        String currentRootId = ((Uri)this.foldersHierarchy.getLast()).getQueryParameter("id");
        List<AmazonFolder> folders = null;
        try {
            folders = this.amazonCloudDriveApi.listSubfolders(currentRootId);
        }
        catch (IOException | ForbiddenException e) {
            DebugLog.logException((Throwable)e);
        }
        if (folders == null) {
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
            return Collections.emptyList();
        }
        ArrayList<Uri> folderUris = new ArrayList<Uri>();
        for (AmazonFolder folder : folders) {
            Uri uri = new Uri.Builder().appendQueryParameter("folder_name", folder.getName()).appendQueryParameter("id", String.valueOf(folder.getId())).build();
            folderUris.add(uri);
        }
        return folderUris;
    }
}

