/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcelable;
import android.widget.TextView;
import com.google.inject.Inject;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.ui.upload.AuthYandexDiskActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.auth.ConnectionResult;
import net.doo.snap.util.NavigationUtils;

public class YandexDiskActivity
extends CustomThemeActivity {
    private static final String WAITING_FOR_RESULT = "WAITING_FOR_RESULT";
    private static final String ACCOUNT_NAME = "ACCOUNT_NAME";
    private static final int CHOOSER_REQUEST_CODE = 1;
    private String accountName;
    private boolean waitingForResult;
    @Inject
    private SharedPreferences preferences;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_storage);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.YANDEX_DISK.getNameResource())}));
        if (savedInstanceState != null) {
            this.accountName = savedInstanceState.getString(ACCOUNT_NAME);
            this.waitingForResult = savedInstanceState.getBoolean(WAITING_FOR_RESULT);
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.waitingForResult) {
            if (CloudStorage.isConnected(CloudStorage.YANDEX_DISK, (Context)this)) {
                this.waitingForResult = false;
                this.preferences.edit().remove(CloudStorage.YANDEX_DISK.getDefaultFolderKey()).commit();
                this.startActivityForResult(new Intent((Context)this, CloudStorage.getChooserActivity(CloudStorage.YANDEX_DISK)), 1);
            } else {
                this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.YANDEX_DISK, null));
            }
        } else if (this.accountName == null) {
            this.startActivity(new Intent((Context)this, AuthYandexDiskActivity.class));
            this.waitingForResult = true;
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.YANDEX_DISK, this.accountName));
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(ACCOUNT_NAME, this.accountName);
        outState.putBoolean(WAITING_FOR_RESULT, this.waitingForResult);
    }

    private void deliverConnectionResult(ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }
}

