/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload;

import android.content.Context;
import com.google.inject.Inject;
import io.scanbot.sap.SapManager;
import java.io.IOException;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.DocumentLockProvider;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.upload.cloud.UploaderProvider;

public class DocumentUploader {
    @Inject
    private Context context;
    @Inject
    private UploaderProvider uploaderProvider;
    @Inject
    private DocumentStoreStrategy documentStoreStrategy;
    @Inject
    private DocumentLockProvider documentLockProvider;
    @Inject
    private OnFileUploadListener uploadListener;
    @Inject
    private SapManager sapManager;

    @Inject
    public DocumentUploader() {
    }

    public DocumentUploader(Context context, UploaderProvider uploaderProvider, DocumentStoreStrategy documentStoreStrategy, OnFileUploadListener uploadListener, DocumentLockProvider documentLockProvider) {
        this.context = context;
        this.uploaderProvider = uploaderProvider;
        this.documentStoreStrategy = documentStoreStrategy;
        this.uploadListener = uploadListener;
        this.documentLockProvider = documentLockProvider;
    }

    public boolean uploadDocument(UploadInfo info, CloudStorage target, OnFileUploadListener onFileUploadListener) throws IOException {
        if (!this.sapManager.isLicenseActive() || !this.sapManager.isFeatureEnabled(128)) {
            return false;
        }
        if (info == null) {
            return false;
        }
        CloudUploader uploader = this.uploaderProvider.getUploader(target);
        uploader.upload(info, onFileUploadListener != null ? onFileUploadListener : this.uploadListener);
        return true;
    }
}

