/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.upload.cloud.wunderlist.ForbiddenException;
import net.doo.snap.upload.cloud.wunderlist.WunderlistApi;
import net.doo.snap.upload.cloud.wunderlist.model.CreateFileRequest;
import net.doo.snap.upload.cloud.wunderlist.model.CreateListRequest;
import net.doo.snap.upload.cloud.wunderlist.model.CreateTaskRequest;
import net.doo.snap.upload.cloud.wunderlist.model.CreateUploadRequest;
import net.doo.snap.upload.cloud.wunderlist.model.File;
import net.doo.snap.upload.cloud.wunderlist.model.List;
import net.doo.snap.upload.cloud.wunderlist.model.Task;
import net.doo.snap.upload.cloud.wunderlist.model.Upload;
import net.doo.snap.upload.cloud.wunderlist.model.UploadFinishedRequest;
import net.doo.snap.upload.cloud.wunderlist.model.UploadFinishedResponse;
import net.doo.snap.util.log.DebugLog;
import retrofit.client.Response;
import retrofit.mime.TypedFile;

public class WunderlistUploader
implements CloudUploader {
    private static final String UPLOAD_FINISHED_STATE = "finished";
    private static final SimpleDateFormat ISO8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    @Inject
    private WunderlistApi wunderlistApi;
    @Inject
    private SharedPreferences preferences;
    @Inject
    private Context context;

    @Inject
    public WunderlistUploader() {
    }

    @Override
    public void upload(UploadInfo info, OnFileUploadListener onFileUploadListener) throws IOException {
        String uploadListName = null;
        Uri uploadListUri = CloudStorage.WUNDERLIST.getDefaultFolder(this.preferences);
        if (uploadListUri != null) {
            String uploadListCloudId = uploadListUri.getQueryParameter("id");
            uploadListName = uploadListUri.getQueryParameter("folder_name");
            if (!TextUtils.isEmpty((CharSequence)uploadListCloudId)) {
                try {
                    List list = this.wunderlistApi.getList(Long.valueOf(uploadListCloudId));
                    if (list != null) {
                        this.uploadToExistingList(list, info, onFileUploadListener);
                        return;
                    }
                }
                catch (ForbiddenException e) {
                    DebugLog.logException((Throwable)e);
                    onFileUploadListener.onUploadAuthorizationFailed(info.getId(), CloudStorage.WUNDERLIST);
                    return;
                }
            }
        }
        this.createListAndUploadFile(uploadListName, info, onFileUploadListener);
    }

    private void uploadToExistingList(List list, UploadInfo info, OnFileUploadListener onFileUploadListener) {
        String mime = info.getFile().getName().endsWith(".jpg") ? "image/jpeg" : "application/pdf";
        TypedFile file = new TypedFile(mime, info.getFile());
        try {
            Task task = null;
            if (!TextUtils.isEmpty((CharSequence)info.getCloudFileId())) {
                try {
                    task = this.wunderlistApi.getTask(Long.valueOf(info.getCloudFileId()));
                }
                catch (IOException e) {
                    DebugLog.logException((Throwable)e);
                }
            }
            if (!(task != null || (task = this.wunderlistApi.createTask(new CreateTaskRequest(list.getId(), info.getFile().getName()))) != null && this.uploadFile(info, onFileUploadListener, mime, file, task))) {
                onFileUploadListener.onUploadFailed(info.getId(), CloudStorage.WUNDERLIST);
                return;
            }
        }
        catch (ForbiddenException e) {
            DebugLog.logException((Throwable)e);
            onFileUploadListener.onUploadAuthorizationFailed(info.getId(), CloudStorage.WUNDERLIST);
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
            onFileUploadListener.onUploadFailed(info.getId(), CloudStorage.WUNDERLIST);
        }
    }

    private void createListAndUploadFile(String uploadFolderName, UploadInfo info, OnFileUploadListener onFileUploadListener) {
        if (TextUtils.isEmpty((CharSequence)uploadFolderName)) {
            uploadFolderName = "Scanbot";
        }
        try {
            List list = this.wunderlistApi.createList(new CreateListRequest(uploadFolderName));
            if (list != null) {
                Uri listUri = new Uri.Builder().appendQueryParameter("folder_name", list.getTitle()).appendQueryParameter("id", String.valueOf(list.getId())).build();
                SharedPreferences.Editor edit = this.preferences.edit();
                edit.putString(CloudStorage.WUNDERLIST.getDefaultFolderKey(), listUri.toString());
                edit.commit();
                this.uploadToExistingList(list, info, onFileUploadListener);
                return;
            }
            onFileUploadListener.onUploadFailed(info.getId(), CloudStorage.WUNDERLIST);
        }
        catch (ForbiddenException e) {
            DebugLog.logException((Throwable)e);
            onFileUploadListener.onUploadAuthorizationFailed(info.getId(), CloudStorage.WUNDERLIST);
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
            onFileUploadListener.onUploadFailed(info.getId(), CloudStorage.WUNDERLIST);
        }
    }

    private boolean uploadFile(UploadInfo info, OnFileUploadListener onFileUploadListener, String mime, TypedFile file, Task task) throws ForbiddenException, IOException {
        File wunderlistFile;
        UploadFinishedResponse uploadFinishedResponse;
        Response response;
        Upload upload = this.wunderlistApi.createUpload(new CreateUploadRequest(mime, info.getFile().getName(), info.getFile().length()));
        if (upload != null && upload.getPart() != null && (response = this.wunderlistApi.uploadFile(upload.getPart(), file)).getStatus() == 200 && (uploadFinishedResponse = this.wunderlistApi.markUploadFinished(upload.getId(), new UploadFinishedRequest())) != null && UPLOAD_FINISHED_STATE.equals(uploadFinishedResponse.getState()) && (wunderlistFile = this.wunderlistApi.createFile(new CreateFileRequest(upload.getId(), task.getId()))) != null) {
            onFileUploadListener.onUploadFinished(info.getId(), CloudStorage.WUNDERLIST, String.valueOf(task.getId()));
            return true;
        }
        return false;
    }
}

