/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.app.Application;
import android.content.SharedPreferences;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.EnumMap;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.AmazonCloudDriveUploader;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.DropboxUploader;
import net.doo.snap.upload.cloud.EvernoteBusinessUploader;
import net.doo.snap.upload.cloud.EvernoteUploader;
import net.doo.snap.upload.cloud.GoogleDriveUploader;
import net.doo.snap.upload.cloud.OneDriveUploader;
import net.doo.snap.upload.cloud.ShoeboxedUploader;
import net.doo.snap.upload.cloud.SlackUploader;
import net.doo.snap.upload.cloud.WebDavStorageUploader;
import net.doo.snap.upload.cloud.WunderlistUploader;
import net.doo.snap.upload.cloud.YandexDiskUploader;
import roboguice.RoboGuice;

@Singleton
public class UploaderProvider {
    private final EnumMap<CloudStorage, CloudUploader> uploaders = new EnumMap(CloudStorage.class);
    private final EvernoteBusinessUploader evernoteBusinessUploader = new EvernoteBusinessUploader();
    @Inject
    private SharedPreferences preferences;

    @Inject
    public UploaderProvider(Application context) {
        this.uploaders.put(CloudStorage.DROPBOX, new DropboxUploader());
        this.uploaders.put(CloudStorage.GOOGLE_DRIVE, new GoogleDriveUploader());
        this.uploaders.put(CloudStorage.ONE_DRIVE, new OneDriveUploader());
        this.uploaders.put(CloudStorage.BOX, new WebDavStorageUploader(CloudStorage.BOX));
        this.uploaders.put(CloudStorage.EVERNOTE, new EvernoteUploader());
        this.uploaders.put(CloudStorage.YANDEX_DISK, new YandexDiskUploader());
        this.uploaders.put(CloudStorage.WEBDAV_STORAGE, new WebDavStorageUploader(CloudStorage.WEBDAV_STORAGE));
        this.uploaders.put(CloudStorage.TELEKOM_CLOUD, new WebDavStorageUploader(CloudStorage.TELEKOM_CLOUD));
        this.uploaders.put(CloudStorage.SHOEBOXED, new ShoeboxedUploader());
        this.uploaders.put(CloudStorage.AMAZON_CLOUD_DRIVE, new AmazonCloudDriveUploader());
        this.uploaders.put(CloudStorage.SLACK, new SlackUploader());
        this.uploaders.put(CloudStorage.WUNDERLIST, new WunderlistUploader());
        Injector injector = RoboGuice.getOrCreateBaseApplicationInjector((Application)context);
        for (CloudUploader uploader : this.uploaders.values()) {
            injector.injectMembers((Object)uploader);
        }
        injector.injectMembers((Object)this.evernoteBusinessUploader);
    }

    public CloudUploader getUploader(CloudStorage target) {
        if (target.equals((Object)CloudStorage.EVERNOTE) && this.preferences.getBoolean("EVERNOTE_IS_FOLDER_BUSINESS", false)) {
            return this.evernoteBusinessUploader;
        }
        return this.uploaders.get((Object)target);
    }
}

