/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.utils.navigator;

import android.app.Activity;
import android.support.annotation.Nullable;
import fj.F;
import fj.data.List;
import io.scanbot.sdk.ui.utils.navigator.NodeNavigator;

public class Nodes {
    public static <A extends Activity> FunctionalNode.FunctionalNodeBuilder<A> node(F<Object, Boolean> handleEventWhen) {
        return FunctionalNode.builder().actionNode(false).handleEventWhen(handleEventWhen);
    }

    public static <A extends Activity> NodeNavigator.NavigationNode<A> actionNode(F<Object, Boolean> eventMatcher, Action2<A, Object> action) {
        return FunctionalNode.builder().actionNode(true).handleEventWhen(eventMatcher).whenNavigateTo(action).build();
    }

    public static F<Object, Boolean> key(Object value) {
        return value::equals;
    }

    public static F<Object, Boolean> key(Class<?> type) {
        return type::isInstance;
    }

    public static F<Object, Boolean> anyOfTypes(List<Class<?>> types) {
        return event -> types.exists(type -> type.isInstance(event));
    }

    public static F<Object, Boolean> anyOf(List<Object> values) {
        return event -> values.exists(object2 -> object2.equals(event));
    }

    public static class FunctionalNode<A extends Activity>
    implements NodeNavigator.NavigationNode<A> {
        @Nullable
        private final F<Object, Boolean> handleEventWhen;
        @Nullable
        private final Action2<A, Object> whenNavigateTo;
        @Nullable
        private final Action2<A, Object> whenNavigateFrom;
        @Nullable
        private final Func1<A, Boolean> interceptNavigateBack;
        private final boolean actionNode;

        FunctionalNode(F<Object, Boolean> handleEventWhen, Action2<A, Object> whenNavigateTo, Action2<A, Object> whenNavigateFrom, Func1<A, Boolean> interceptNavigateBack, boolean actionNode) {
            this.handleEventWhen = handleEventWhen;
            this.whenNavigateTo = whenNavigateTo;
            this.whenNavigateFrom = whenNavigateFrom;
            this.interceptNavigateBack = interceptNavigateBack;
            this.actionNode = actionNode;
        }

        public static <A extends Activity> FunctionalNodeBuilder<A> builder() {
            return new FunctionalNodeBuilder();
        }

        @Override
        public void navigateTo(A activity, Object data) {
            if (this.whenNavigateTo != null) {
                this.whenNavigateTo.call(activity, data);
            }
        }

        @Override
        public void navigateFrom(A activity, Object data) {
            if (this.whenNavigateFrom != null) {
                this.whenNavigateFrom.call(activity, data);
            }
        }

        @Override
        public boolean interceptBackNavigation(A activity) {
            return this.interceptNavigateBack != null ? this.interceptNavigateBack.call(activity) : false;
        }

        @Override
        public boolean isActionNode() {
            return this.actionNode;
        }

        @Override
        public boolean canHandleNavigationEvent(Object event) {
            return this.handleEventWhen != null ? (Boolean)this.handleEventWhen.f(event) : false;
        }

        public static class FunctionalNodeBuilder<A extends Activity> {
            private F<Object, Boolean> handleEventWhen;
            private Action2<A, Object> whenNavigateTo;
            private Action2<A, Object> whenNavigateFrom;
            private Func1<A, Boolean> interceptNavigateBack;
            private boolean actionNode;

            FunctionalNodeBuilder() {
            }

            public FunctionalNodeBuilder<A> handleEventWhen(F<Object, Boolean> handleEventWhen) {
                this.handleEventWhen = handleEventWhen;
                return this;
            }

            public FunctionalNodeBuilder<A> whenNavigateTo(Action2<A, Object> whenNavigateTo) {
                this.whenNavigateTo = whenNavigateTo;
                return this;
            }

            public FunctionalNodeBuilder<A> whenNavigateFrom(Action2<A, Object> whenNavigateFrom) {
                this.whenNavigateFrom = whenNavigateFrom;
                return this;
            }

            public FunctionalNodeBuilder<A> interceptNavigateBack(Func1<A, Boolean> interceptNavigateBack) {
                this.interceptNavigateBack = interceptNavigateBack;
                return this;
            }

            public FunctionalNodeBuilder<A> actionNode(boolean actionNode) {
                this.actionNode = actionNode;
                return this;
            }

            public FunctionalNode<A> build() {
                return new FunctionalNode<A>(this.handleEventWhen, this.whenNavigateTo, this.whenNavigateFrom, this.interceptNavigateBack, this.actionNode);
            }

            public String toString() {
                return "Nodes.FunctionalNode.FunctionalNodeBuilder(handleEventWhen=" + this.handleEventWhen + ", whenNavigateTo=" + this.whenNavigateTo + ", whenNavigateFrom=" + this.whenNavigateFrom + ", interceptNavigateBack=" + this.interceptNavigateBack + ", actionNode=" + this.actionNode + ")";
            }
        }
    }

    public static interface Func1<T, R> {
        public R call(T var1);
    }

    public static interface Action2<T1, T2> {
        public void call(T1 var1, T2 var2);
    }
}

