/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.app.Activity;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.sdk.ui.di.components.ActivityComponent;
import io.scanbot.sdk.ui.di.components.MRZCameraComponent;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.FetchMRZTrainedDataUseCase;
import io.scanbot.sdk.ui.view.mrz.MRZCameraFragment;
import io.scanbot.sdk.ui.view.mrz.MRZCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.mrz.MRZCameraPresenter;
import javax.inject.Provider;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.blob.BlobManager;

public final class DaggerMRZCameraComponent
implements MRZCameraComponent {
    private ActivityComponent activityComponent;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerMRZCameraComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Activity)Preconditions.checkNotNull((Object)this.activityComponent.activity(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private FetchMRZTrainedDataUseCase getFetchMRZTrainedDataUseCase() {
        return new FetchMRZTrainedDataUseCase((BlobManager)Preconditions.checkNotNull((Object)this.activityComponent.blobManager(), (String)"Cannot return null from a non-@Nullable component method"), (BlobFactory)Preconditions.checkNotNull((Object)this.activityComponent.blobFactory(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private MRZCameraPresenter getMRZCameraPresenter() {
        return new MRZCameraPresenter(this.getCheckCameraPermissionUseCase(), this.getFetchMRZTrainedDataUseCase(), (Navigator)this.providesNavigatorProvider.get(), (Scheduler)Preconditions.checkNotNull((Object)this.activityComponent.provideBackgroundTaskScheduler(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private void initialize(Builder builder) {
        this.activityComponent = builder.activityComponent;
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create(builder.navigatorModule));
    }

    @Override
    public void inject(MRZCameraFragment mrzCameraFragment) {
        this.injectMRZCameraFragment(mrzCameraFragment);
    }

    @CanIgnoreReturnValue
    private MRZCameraFragment injectMRZCameraFragment(MRZCameraFragment instance) {
        MRZCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase(instance, this.getCheckCameraPermissionUseCase());
        MRZCameraFragment_MembersInjector.injectMrzCameraPresenter(instance, this.getMRZCameraPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private ActivityComponent activityComponent;

        private Builder() {
        }

        public MRZCameraComponent build() {
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.activityComponent == null) {
                throw new IllegalStateException(ActivityComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerMRZCameraComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder activityComponent(ActivityComponent activityComponent2) {
            this.activityComponent = (ActivityComponent)Preconditions.checkNotNull((Object)activityComponent2);
            return this;
        }
    }
}

