/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.app.Activity;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.scanbot.sdk.ui.di.components.ActivityComponent;
import io.scanbot.sdk.ui.di.components.BarcodeCameraComponent;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraPresenter;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import javax.inject.Provider;

public final class DaggerBarcodeCameraComponent
implements BarcodeCameraComponent {
    private ActivityComponent activityComponent;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerBarcodeCameraComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Activity)Preconditions.checkNotNull((Object)this.activityComponent.activity(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private BarcodeCameraPresenter getBarcodeCameraPresenter() {
        return new BarcodeCameraPresenter(this.getCheckCameraPermissionUseCase(), (Navigator)this.providesNavigatorProvider.get());
    }

    private void initialize(Builder builder) {
        this.activityComponent = builder.activityComponent;
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create(builder.navigatorModule));
    }

    @Override
    public void inject(BarcodeCameraFragment barcodeCameraFragment) {
        this.injectBarcodeCameraFragment(barcodeCameraFragment);
    }

    @CanIgnoreReturnValue
    private BarcodeCameraFragment injectBarcodeCameraFragment(BarcodeCameraFragment instance) {
        BarcodeCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase(instance, this.getCheckCameraPermissionUseCase());
        BarcodeCameraFragment_MembersInjector.injectBarcodeCameraPresenter(instance, this.getBarcodeCameraPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private ActivityComponent activityComponent;

        private Builder() {
        }

        public BarcodeCameraComponent build() {
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.activityComponent == null) {
                throw new IllegalStateException(ActivityComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerBarcodeCameraComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder activityComponent(ActivityComponent activityComponent2) {
            this.activityComponent = (ActivityComponent)Preconditions.checkNotNull((Object)activityComponent2);
            return this;
        }
    }
}

