/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.sdk.persistence.DraftPagesRepository;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.ui.di.components.CameraComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.camera.CameraFragment;
import io.scanbot.sdk.ui.view.camera.CameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.camera.CameraPresenter;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveTakenPictureUseCase;
import javax.inject.Provider;

public final class DaggerCameraComponent
implements CameraComponent {
    private SDKUIComponent sDKUIComponent;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerCameraComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private PageStorageProcessor getPageStorageProcessor() {
        return new PageStorageProcessor((PageStorage)Preconditions.checkNotNull((Object)this.sDKUIComponent.pageStorage(), (String)"Cannot return null from a non-@Nullable component method"), (PageStorageSettings)Preconditions.checkNotNull((Object)this.sDKUIComponent.pageStorageSettings(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private DraftPagesRepository getDraftPagesRepository() {
        return new DraftPagesRepository(this.getPageStorageProcessor());
    }

    private SaveTakenPictureUseCase getSaveTakenPictureUseCase() {
        return new SaveTakenPictureUseCase(this.getDraftPagesRepository());
    }

    private CameraPresenter getCameraPresenter() {
        return new CameraPresenter(this.getCheckCameraPermissionUseCase(), this.getSaveTakenPictureUseCase(), (Navigator)this.providesNavigatorProvider.get(), (Scheduler)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideBackgroundTaskScheduler(), (String)"Cannot return null from a non-@Nullable component method"), (Scheduler)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideUiScheduler(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private void initialize(Builder builder) {
        this.sDKUIComponent = builder.sDKUIComponent;
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)builder.navigatorModule));
    }

    @Override
    public void inject(CameraFragment cameraFragment) {
        this.injectCameraFragment(cameraFragment);
    }

    private CameraFragment injectCameraFragment(CameraFragment instance) {
        CameraFragment_MembersInjector.injectCheckCameraPermissionUseCase(instance, this.getCheckCameraPermissionUseCase());
        CameraFragment_MembersInjector.injectCameraPresenter(instance, this.getCameraPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public CameraComponent build() {
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.sDKUIComponent == null) {
                throw new IllegalStateException(SDKUIComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerCameraComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }
    }
}

