/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.mrz;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.app.ActivityCompat;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sdk.R;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.ui.utils.CheckableFrameLayout;
import io.scanbot.sdk.ui.utils.events.Signal;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.mrz.IMRZCameraView;
import io.scanbot.sdk.ui.view.mrz.MRZCameraView;
import io.scanbot.sdk.ui.view.mrz.MRZCameraView$WhenMappings;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.camera.CameraOpenCallback;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.mrzscanner.MRZScanner;
import net.doo.snap.mrzscanner.MRZScannerFrameHandler;
import net.doo.snap.mrzscanner.SilentMRZScannerFrameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 &2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001&B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0014J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0016H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/ui/view/mrz/MRZCameraView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView;", "Lnet/doo/snap/mrzscanner/MRZScannerFrameHandler$ResultHandler;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cameraOpened", "Ljava/util/concurrent/atomic/AtomicBoolean;", "listener", "Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView$Listener;", "mrzScannerFrameHandler", "Lnet/doo/snap/mrzscanner/MRZScannerFrameHandler;", "state", "Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView$State;", "subscribtions", "Lio/reactivex/disposables/CompositeDisposable;", "closeCamera", "", "handleResult", "", "recognitionResult", "Lio/scanbot/mrzscanner/model/MRZRecognitionResult;", "initCameraView", "onDetachedFromWindow", "setCameraOrientationMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setListener", "subscribeViews", "updateCameraPermissionView", "cameraPermissionGranted", "updateFlashState", "flash", "updateState", "newState", "Companion", "scanbot-sdk-ui_release"})
public final class MRZCameraView
extends FrameLayout
implements IMRZCameraView,
MRZScannerFrameHandler.ResultHandler {
    private IMRZCameraView.State state;
    private IMRZCameraView.Listener listener;
    private MRZScannerFrameHandler mrzScannerFrameHandler;
    private final AtomicBoolean cameraOpened;
    private final CompositeDisposable subscribtions;
    private static final long CAMERA_OPENED_DELAY_MILLIS = 300L;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closeCamera();
    }

    @Override
    public void setListener(@NotNull IMRZCameraView.Listener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
    }

    @Override
    public void updateState(@NotNull IMRZCameraView.State newState) {
        Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
        this.state = newState;
        this.subscribeViews();
    }

    public boolean handleResult(@Nullable MRZRecognitionResult recognitionResult) {
        this.listener.mrzCodeScanned(recognitionResult);
        return false;
    }

    @Override
    public void setCameraOrientationMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)cameraOrientationMode), (String)"cameraOrientationMode");
        switch (MRZCameraView$WhenMappings.$EnumSwitchMapping$0[cameraOrientationMode.ordinal()]) {
            case 1: {
                ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).lockToPortrait(true);
                break;
            }
            case 2: {
                ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).lockToLandscape(true);
            }
        }
    }

    private final void closeCamera() {
        this.cameraOpened.set(false);
        ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).onPause();
        this.subscribtions.clear();
    }

    private final void initCameraView() {
        ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).setPreviewMode(CameraPreviewMode.FILL_IN);
        ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).setCameraOpenCallback(new CameraOpenCallback(this){
            final /* synthetic */ MRZCameraView this$0;

            public final void onCameraOpened() {
                MRZCameraView.access$getCameraOpened$p(this.this$0).set(true);
                ((ScanbotCameraView)this.this$0._$_findCachedViewById(R.id.scanbotCameraView)).postDelayed(new Runnable(this){
                    final /* synthetic */ initCameraView.1 this$0;

                    public final void run() {
                        Context context = this.this$0.this$0.getContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                        Context context2 = context.getApplicationContext();
                        if (context2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type android.app.Application");
                        }
                        ScanbotSDK scanbotSDK = new ScanbotSDK((Application)context2);
                        MRZCameraView mRZCameraView = this.this$0.this$0;
                        MRZScannerFrameHandler mRZScannerFrameHandler = SilentMRZScannerFrameHandler.attach((ScanbotCameraView)((ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView)), (MRZScanner)scanbotSDK.mrzScanner());
                        Intrinsics.checkExpressionValueIsNotNull((Object)mRZScannerFrameHandler, (String)"SilentMRZScannerFrameHan\u2026 scanbotSDK.mrzScanner())");
                        MRZCameraView.access$setMrzScannerFrameHandler$p(mRZCameraView, mRZScannerFrameHandler);
                        MRZCameraView.access$getMrzScannerFrameHandler$p(this.this$0.this$0).addResultHandler((MRZScannerFrameHandler.ResultHandler)this.this$0.this$0);
                        if (Build.VERSION.SDK_INT >= 17) {
                            ((ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView)).setShutterSound(false);
                        }
                        ((ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView)).continuousFocus();
                        ScanbotCameraView scanbotCameraView = (ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView);
                        Object object = MRZCameraView.access$getState$p(this.this$0.this$0).getFlash().getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this@MRZCameraView.state.flash.value");
                        scanbotCameraView.useFlash(((Boolean)object).booleanValue());
                        MRZCameraView.access$getListener$p(this.this$0.this$0).onCameraOpened();
                        MRZCameraView.access$getSubscribtions$p(this.this$0.this$0).add(MRZCameraView.access$getState$p(this.this$0.this$0).getFlash().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(this){
                            final /* synthetic */ initCameraView.1 this$0;

                            public final void accept(Boolean flash) {
                                MRZCameraView mRZCameraView = this.this$0.this$0.this$0;
                                Boolean bl = flash;
                                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"flash");
                                MRZCameraView.access$updateFlashState(mRZCameraView, bl);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, 300L);
            }
            {
                this.this$0 = mRZCameraView;
            }
        });
    }

    private final void subscribeViews() {
        this.subscribtions.add(this.state.getCameraPermissionGranted().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ MRZCameraView this$0;

            public final void accept(Boolean granted) {
                Boolean bl = granted;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"granted");
                if (bl.booleanValue()) {
                    ((ScanbotCameraView)this.this$0._$_findCachedViewById(R.id.scanbotCameraView)).onResume();
                }
                MRZCameraView.access$updateCameraPermissionView(this.this$0, granted);
            }
            {
                this.this$0 = mRZCameraView;
            }
        }));
        this.subscribtions.add(this.state.getCameraClosed().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Signal>(this){
            final /* synthetic */ MRZCameraView this$0;

            public final void accept(Signal it) {
                MRZCameraView.access$closeCamera(this.this$0);
            }
            {
                this.this$0 = mRZCameraView;
            }
        }));
    }

    private final void updateCameraPermissionView(boolean cameraPermissionGranted) {
        if (cameraPermissionGranted) {
            LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.cameraPermissionView);
            Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"cameraPermissionView");
            linearLayout.setVisibility(8);
        } else {
            Context context = this.getContext();
            if (context == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
            }
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)context), (String)"android.permission.CAMERA")) {
                LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.cameraPermissionView);
                Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"cameraPermissionView");
                linearLayout.setVisibility(0);
            }
        }
    }

    private final void updateFlashState(boolean flash) {
        if (this.cameraOpened.get()) {
            CheckableFrameLayout checkableFrameLayout = (CheckableFrameLayout)this._$_findCachedViewById(R.id.flashBtn);
            if (checkableFrameLayout == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.scanbot.sdk.ui.utils.CheckableFrameLayout");
            }
            checkableFrameLayout.setChecked(flash);
            ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).useFlash(flash);
        }
    }

    public MRZCameraView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.state = IMRZCameraView.State.Companion.getDEFAULT();
        this.listener = IMRZCameraView.Listener.Companion.getNULL();
        this.cameraOpened = new AtomicBoolean(false);
        this.subscribtions = new CompositeDisposable();
        LayoutInflater.from((Context)context).inflate(R.layout.mrz_camera_view, (ViewGroup)this, true);
        ((TextView)this._$_findCachedViewById(R.id.cancelBtn)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.onCancelClicked();
            }
        });
        ((CheckableFrameLayout)this._$_findCachedViewById(R.id.flashBtn)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.onFlashClicked();
            }
        });
        ((Button)this._$_findCachedViewById(R.id.enableCameraBtn)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.onActivateCameraPermission();
            }
        });
        this.initCameraView();
    }

    @NotNull
    public static final /* synthetic */ AtomicBoolean access$getCameraOpened$p(MRZCameraView $this) {
        return $this.cameraOpened;
    }

    @NotNull
    public static final /* synthetic */ MRZScannerFrameHandler access$getMrzScannerFrameHandler$p(MRZCameraView $this) {
        MRZScannerFrameHandler mRZScannerFrameHandler = $this.mrzScannerFrameHandler;
        if (mRZScannerFrameHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mrzScannerFrameHandler");
        }
        return mRZScannerFrameHandler;
    }

    public static final /* synthetic */ void access$setMrzScannerFrameHandler$p(MRZCameraView $this, @NotNull MRZScannerFrameHandler mRZScannerFrameHandler) {
        $this.mrzScannerFrameHandler = mRZScannerFrameHandler;
    }

    @NotNull
    public static final /* synthetic */ IMRZCameraView.State access$getState$p(MRZCameraView $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(MRZCameraView $this, @NotNull IMRZCameraView.State state) {
        $this.state = state;
    }

    public static final /* synthetic */ void access$setListener$p(MRZCameraView $this, @NotNull IMRZCameraView.Listener listener) {
        $this.listener = listener;
    }

    @NotNull
    public static final /* synthetic */ CompositeDisposable access$getSubscribtions$p(MRZCameraView $this) {
        return $this.subscribtions;
    }

    public static final /* synthetic */ void access$updateFlashState(MRZCameraView $this, boolean flash) {
        $this.updateFlashState(flash);
    }

    public static final /* synthetic */ void access$updateCameraPermissionView(MRZCameraView $this, boolean cameraPermissionGranted) {
        $this.updateCameraPermissionView(cameraPermissionGranted);
    }

    public static final /* synthetic */ void access$closeCamera(MRZCameraView $this) {
        $this.closeCamera();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/ui/view/mrz/MRZCameraView$Companion;", "", "()V", "CAMERA_OPENED_DELAY_MILLIS", "", "scanbot-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

