/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.workflow;

import android.graphics.Rect;
import android.graphics.RectF;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.processors.PublishProcessor;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.ui.di.BackgroundTaskScheduler;
import io.scanbot.sdk.ui.di.UiScheduler;
import io.scanbot.sdk.ui.entity.workflow.BasicWorkflowStepResult;
import io.scanbot.sdk.ui.entity.workflow.ScanBarCodeWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanDisabilityCertificateWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanDocumentPageWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanMachineReadableZoneWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanPayFormWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.Workflow;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStepError;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStepResult;
import io.scanbot.sdk.ui.utils.CrossViewStatePresenter;
import io.scanbot.sdk.ui.utils.StatelessView;
import io.scanbot.sdk.ui.utils.events.Signal;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.RemovePageUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveCameraFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveTakenPictureUseCase;
import io.scanbot.sdk.ui.view.interactor.WorkflowDetectionUseCase;
import io.scanbot.sdk.ui.view.workflow.IWorkflowCameraView;
import io.scanbot.sdk.ui.view.workflow.WorkflowCameraPresenter;
import io.scanbot.sdk.ui.view.workflow.camera.WorkflowFrameHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 ^2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0004^_`aBM\b\u0007\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0001\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0001\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0014J\n\u00105\u001a\u0004\u0018\u000106H\u0002J\b\u00107\u001a\u000208H\u0016J4\u00109\u001a\u001e\u0012\b\b\u0001\u0012\u0004\u0018\u00010; \u0018*\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010;\u0018\u00010:0:2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\b\u0010@\u001a\u000208H\u0002J\b\u0010A\u001a\u000208H\u0002J\u0010\u0010B\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u000208H\u0016J\b\u0010F\u001a\u000208H\u0016J\b\u0010G\u001a\u000208H\u0016J\b\u0010H\u001a\u000208H\u0016J\b\u0010I\u001a\u000208H\u0016J\b\u0010J\u001a\u000208H\u0016J\u0010\u0010K\u001a\u0002082\u0006\u0010L\u001a\u00020$H\u0016J\u0018\u0010M\u001a\u0002082\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010N\u001a\u000208H\u0016J\b\u0010O\u001a\u000208H\u0002J\b\u0010P\u001a\u000208H\u0002J\u0010\u0010Q\u001a\u0002082\u0006\u0010R\u001a\u00020\u0003H\u0016J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020T0:2\u0006\u0010L\u001a\u00020$H\u0002J*\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00170:2\u0006\u0010C\u001a\u00020D2\u0006\u0010L\u001a\u00020$2\n\b\u0002\u0010V\u001a\u0004\u0018\u00010TH\u0002J\u000e\u0010W\u001a\u0002082\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010X\u001a\u0002082\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010Y\u001a\u0002082\u0006\u0010Z\u001a\u00020\u001eJ\u000e\u0010[\u001a\u0002082\u0006\u0010%\u001a\u00020&J\u0018\u0010\\\u001a\u0002082\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010]\u001a\u0002082\u0006\u0010L\u001a\u00020$H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0015\u001a&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017 \u0018*\u0012\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R2\u0010#\u001a&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010$0$ \u0018*\u0012\u0012\f\u0012\n \u0018*\u0004\u0018\u00010$0$\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000200X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter;", "Lio/scanbot/sdk/ui/utils/CrossViewStatePresenter;", "Lio/scanbot/sdk/ui/view/workflow/IWorkflowCameraView$State;", "Lio/scanbot/sdk/ui/view/workflow/IWorkflowCameraView;", "Lio/scanbot/sdk/ui/view/workflow/IWorkflowCameraView$Listener;", "checkCameraPermissionUseCase", "Lio/scanbot/sdk/ui/view/interactor/CheckCameraPermissionUseCase;", "saveTakenPictureUseCase", "Lio/scanbot/sdk/ui/view/interactor/SaveTakenPictureUseCase;", "saveCameraFrameUseCase", "Lio/scanbot/sdk/ui/view/interactor/SaveCameraFrameUseCase;", "workflowDetectionUseCase", "Lio/scanbot/sdk/ui/view/interactor/WorkflowDetectionUseCase;", "removePageUseCase", "Lio/scanbot/sdk/ui/view/interactor/RemovePageUseCase;", "navigator", "Lio/scanbot/sdk/ui/utils/navigator/Navigator;", "backgroundTaskScheduler", "Lio/reactivex/Scheduler;", "uiScheduler", "(Lio/scanbot/sdk/ui/view/interactor/CheckCameraPermissionUseCase;Lio/scanbot/sdk/ui/view/interactor/SaveTakenPictureUseCase;Lio/scanbot/sdk/ui/view/interactor/SaveCameraFrameUseCase;Lio/scanbot/sdk/ui/view/interactor/WorkflowDetectionUseCase;Lio/scanbot/sdk/ui/view/interactor/RemovePageUseCase;Lio/scanbot/sdk/ui/utils/navigator/Navigator;Lio/reactivex/Scheduler;Lio/reactivex/Scheduler;)V", "beepFlow", "Lio/reactivex/processors/PublishProcessor;", "Lio/scanbot/sdk/ui/utils/events/Signal;", "kotlin.jvm.PlatformType", "getCheckCameraPermissionUseCase", "()Lio/scanbot/sdk/ui/view/interactor/CheckCameraPermissionUseCase;", "setCheckCameraPermissionUseCase", "(Lio/scanbot/sdk/ui/view/interactor/CheckCameraPermissionUseCase;)V", "cleanupOnCancel", "", "documentImageSizeLimit", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "flashConfiguration", "Ljava/lang/Boolean;", "frameDataFlow", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "imageScale", "", "logger", "Lnet/doo/snap/util/log/Logger;", "saveTakenPictureSubscription", "Lio/reactivex/disposables/Disposable;", "stepsCache", "Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$WorkflowStepsCache;", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "workflow", "Lio/scanbot/sdk/ui/entity/workflow/Workflow;", "getWorkflow$scanbot_sdk_ui_release", "()Lio/scanbot/sdk/ui/entity/workflow/Workflow;", "setWorkflow$scanbot_sdk_ui_release", "(Lio/scanbot/sdk/ui/entity/workflow/Workflow;)V", "calculateFinderRectF", "Landroid/graphics/RectF;", "checkCameraPermission", "", "detectOrSkip", "Lio/reactivex/Flowable;", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "image", "", "imageOrientation", "", "disableErrorProcessingWithDelay", "goToNextStepOrShowResult", "isBeepableStep", "detectedFrameStep", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "onActivateCameraPermission", "onCameraOpened", "onCancelClicked", "onErrorDialogClosed", "onFlashClicked", "onLicenseInvalid", "onNewDetectionResult", "detectedFrameData", "pageSnapped", "pause", "removeCachedPages", "restartCurrentStep", "resume", "view", "saveCameraFrame", "Lio/scanbot/sdk/persistence/Page;", "saveDetectionResult", "framePage", "setCleanupOnCancel", "setDocumentImageSizeLimit", "setFlashEnabled", "flashEnabled", "setImageScale", "storePageInDraftRepository", "validateStepResult", "Companion", "FinishWorkflow", "StepFrameData", "WorkflowStepsCache", "scanbot-sdk-ui_release"})
public final class WorkflowCameraPresenter
extends CrossViewStatePresenter<IWorkflowCameraView.State, IWorkflowCameraView>
implements IWorkflowCameraView.Listener {
    private final CompositeDisposable subscriptions;
    private Disposable saveTakenPictureSubscription;
    @NotNull
    private Workflow workflow;
    private final WorkflowStepsCache stepsCache;
    private final PublishProcessor<WorkflowFrameHandler.DetectedFrameData> frameDataFlow;
    private final PublishProcessor<Signal> beepFlow;
    private Boolean flashConfiguration;
    private float imageScale;
    private boolean cleanupOnCancel;
    private PageStorageProcessor.Configuration.Size documentImageSizeLimit;
    private final Logger logger;
    @Nullable
    private CheckCameraPermissionUseCase checkCameraPermissionUseCase;
    private final SaveTakenPictureUseCase saveTakenPictureUseCase;
    private final SaveCameraFrameUseCase saveCameraFrameUseCase;
    private final WorkflowDetectionUseCase workflowDetectionUseCase;
    private final RemovePageUseCase removePageUseCase;
    private final Navigator navigator;
    private final Scheduler backgroundTaskScheduler;
    private final Scheduler uiScheduler;
    @NotNull
    public static final String NAVIGATE_PLAY_BEEP = "NAVIGATE_PLAY_BEEP";
    @NotNull
    public static final String NAVIGATE_CANCEL_SNAPPING = "NAVIGATE_CANCEL_SNAPPING";
    @NotNull
    public static final String NAVIGATE_CANCEL_LICENSE_INVALID = "NAVIGATE_CANCEL_LICENSE_INVALID";
    @NotNull
    public static final String NAVIGATE_CLOSE_SNAPPING = "NAVIGATE_CLOSE_SNAPPING";
    @NotNull
    public static final String NAVIGATE_CAMERA_PERMISSION_SETTINGS = "NAVIGATE_CAMERA_PERMISSION_SETTINGS";
    @NotNull
    public static final String NAVIGATE_REQUEST_CAMERA_PERMISSION = "NAVIGATE_REQUEST_CAMERA_PERMISSION";
    public static final long ERROR_PROCESSING_DELAY_IN_SECONDS = 2L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Workflow getWorkflow$scanbot_sdk_ui_release() {
        return this.workflow;
    }

    public final void setWorkflow$scanbot_sdk_ui_release(@NotNull Workflow workflow) {
        Intrinsics.checkParameterIsNotNull((Object)workflow, (String)"<set-?>");
        this.workflow = workflow;
    }

    @Override
    public void resume(@NotNull IWorkflowCameraView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.resume((StatelessView)view);
        view.setListener(this);
        if (this.state == null) {
            this.updateState(IWorkflowCameraView.State.Companion.getDEFAULT());
            Boolean bl = this.flashConfiguration;
            if (bl != null) {
                Boolean bl2 = bl;
                boolean it = bl2;
                ((IWorkflowCameraView.State)this.state).getFlash().onNext((Object)it);
            }
        }
        this.subscriptions.add(((IWorkflowCameraView.State)this.state).getCameraOpened().flatMap(new Function<T, Publisher<? extends R>>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            @Nullable
            public final Flowable<Boolean> apply(@NotNull Signal it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CheckCameraPermissionUseCase checkCameraPermissionUseCase = this.this$0.getCheckCameraPermissionUseCase();
                return checkCameraPermissionUseCase != null ? checkCameraPermissionUseCase.checkCameraPermission() : null;
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        }).subscribe((Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            public final void accept(Boolean cameraPermissionGranted) {
                if (!cameraPermissionGranted.booleanValue()) {
                    WorkflowCameraPresenter.access$getNavigator$p(this.this$0).navigate("NAVIGATE_REQUEST_CAMERA_PERMISSION");
                }
                WorkflowCameraPresenter.access$getState$p(this.this$0).getCameraPermissionGranted().onNext((Object)cameraPermissionGranted);
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        }));
        this.subscriptions.add(((IWorkflowCameraView.State)this.state).getCameraPermissionGranted().filter((Predicate)resume.4.INSTANCE).subscribe((Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            public final void accept(Boolean it) {
                WorkflowStepsCache workflowStepsCache = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0);
                WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                if (workflowStep == null) {
                    workflowStep = (WorkflowStep)CollectionsKt.first(this.this$0.getWorkflow$scanbot_sdk_ui_release().getSteps());
                }
                workflowStepsCache.setCurrentStep(workflowStep);
                WorkflowCameraPresenter.access$getState$p(this.this$0).getCurrentStep().onNext((Object)WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep());
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        }));
        this.subscriptions.add(this.frameDataFlow.onBackpressureDrop().concatMap(new Function<T, Publisher<? extends R>>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            /*
             * Enabled aggressive block sorting
             */
            public final Flowable<Signal> apply(@NotNull WorkflowFrameHandler.DetectedFrameData data) {
                Flowable flowable;
                WorkflowStep step;
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                WorkflowStepResult workflowStepResult = data.getWorkflowStepResult();
                if (workflowStepResult == null) {
                    Intrinsics.throwNpe();
                }
                if ((step = workflowStepResult.getStep()).getWantsVideoFramePage()) {
                    WorkflowStepResult workflowStepResult2 = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults().get(step);
                    if ((workflowStepResult2 != null ? workflowStepResult2.getVideoFramePage() : null) == null && !step.getWantsCapturedPage()) {
                        flowable = WorkflowCameraPresenter.access$saveCameraFrame(this.this$0, data).flatMap((Function)new Function<T, Publisher<? extends R>>(this, step, data){
                            final /* synthetic */ resume.6 this$0;
                            final /* synthetic */ WorkflowStep $step;
                            final /* synthetic */ WorkflowFrameHandler.DetectedFrameData $data;

                            @NotNull
                            public final Flowable<Signal> apply(@NotNull Page it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                WorkflowCameraPresenter workflowCameraPresenter = this.this$0.this$0;
                                WorkflowFrameHandler.DetectedFrameData detectedFrameData = this.$data;
                                Intrinsics.checkExpressionValueIsNotNull((Object)detectedFrameData, (String)"data");
                                return WorkflowCameraPresenter.access$saveDetectionResult(workflowCameraPresenter, this.$step, detectedFrameData, it);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$step = workflowStep;
                                this.$data = detectedFrameData;
                            }
                        });
                        return flowable;
                    }
                }
                flowable = WorkflowCameraPresenter.access$saveDetectionResult(this.this$0, step, data, null);
                return flowable;
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        }).subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe((Consumer)resume.7.INSTANCE, (Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            public final void accept(Throwable error) {
                WorkflowCameraPresenter.access$restartCurrentStep(this.this$0);
                WorkflowCameraPresenter.access$getLogger$p(this.this$0).logException(error);
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        }));
        this.subscriptions.add(this.beepFlow.onBackpressureDrop().subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe((Consumer)new Consumer<Signal>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            public final void accept(Signal it) {
                WorkflowCameraPresenter.access$getNavigator$p(this.this$0).navigate("NAVIGATE_PLAY_BEEP");
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        }));
        ((IWorkflowCameraView.State)this.state).getCameraOpened().onNext((Object)Signal.signal());
    }

    @Override
    public void pause() {
        super.pause();
        ((IWorkflowCameraView.State)this.state).getCameraClosed().onNext((Object)Signal.signal());
        this.subscriptions.clear();
        this.checkCameraPermissionUseCase = null;
    }

    @Override
    public void onCameraOpened() {
        ((IWorkflowCameraView.State)this.state).getPictureProcessing().onNext((Object)false);
    }

    @Override
    public void onActivateCameraPermission() {
        this.navigator.navigate(NAVIGATE_CAMERA_PERMISSION_SETTINGS);
    }

    @Override
    public void onCancelClicked() {
        if (this.cleanupOnCancel) {
            this.removeCachedPages();
        }
        this.subscriptions.clear();
        this.navigator.navigate(NAVIGATE_CANCEL_SNAPPING);
    }

    private final void removeCachedPages() {
        Map $receiver$iv;
        List pages = new ArrayList();
        Map map = $receiver$iv = (Map)this.stepsCache.getStepResults();
        for (Map.Entry element$iv : map.entrySet()) {
            Page page;
            Page page2;
            Map.Entry it = element$iv;
            if (((WorkflowStepResult)it.getValue()).getCapturedPage() != null) {
                page = page2;
                pages.add(page);
            }
            if (((WorkflowStepResult)it.getValue()).getVideoFramePage() == null) continue;
            page = page2;
            pages.add(page);
        }
        this.removePageUseCase.removePages(pages).subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe();
    }

    @Override
    public void onLicenseInvalid() {
        this.subscriptions.clear();
        this.navigator.navigate(NAVIGATE_CANCEL_LICENSE_INVALID);
    }

    @Override
    public void onFlashClicked() {
        ((IWorkflowCameraView.State)this.state).getFlash().onNext((Object)((Boolean)((IWorkflowCameraView.State)this.state).getFlash().getValue() == false ? 1 : 0));
    }

    @Override
    public void onNewDetectionResult(@NotNull WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
        block1: {
            WorkflowStep workflowStep;
            WorkflowStep it;
            Intrinsics.checkParameterIsNotNull((Object)detectedFrameData, (String)"detectedFrameData");
            WorkflowStepResult workflowStepResult = detectedFrameData.getWorkflowStepResult();
            if (workflowStepResult == null) {
                Intrinsics.throwNpe();
            }
            WorkflowStep detectedFrameStep = workflowStepResult.getStep();
            WorkflowStep workflowStep2 = this.stepsCache.getCurrentStep();
            if (workflowStep2 == null || (workflowStep2 = Intrinsics.areEqual((Object)(it = (workflowStep = workflowStep2)), (Object)detectedFrameStep) ? workflowStep : null) == null) break block1;
            WorkflowStep $receiver = workflowStep = workflowStep2;
            this.validateStepResult(detectedFrameData);
        }
    }

    @Override
    public void onErrorDialogClosed() {
        ((IWorkflowCameraView.State)this.state).getErrorProcessing().onNext((Object)false);
    }

    private final Flowable<Signal> saveDetectionResult(WorkflowStep detectedFrameStep, WorkflowFrameHandler.DetectedFrameData detectedFrameData, Page framePage) {
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(this, detectedFrameStep, detectedFrameData, framePage){
            final /* synthetic */ WorkflowCameraPresenter this$0;
            final /* synthetic */ WorkflowStep $detectedFrameStep;
            final /* synthetic */ WorkflowFrameHandler.DetectedFrameData $detectedFrameData;
            final /* synthetic */ Page $framePage;

            public final void subscribe(@NotNull FlowableEmitter<Signal> source) {
                WorkflowStepResult workflowStepResult;
                WorkflowStepResult workflowStepResult2;
                Object object;
                Object object2;
                block10: {
                    block9: {
                        Intrinsics.checkParameterIsNotNull(source, (String)"source");
                        Map map = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepFrameData();
                        object2 = this.$detectedFrameStep;
                        object = new StepFrameData(this.$detectedFrameData);
                        map.put(object2, object);
                        WorkflowStepResult existingResult = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults().get(this.$detectedFrameStep);
                        if (existingResult == null && WorkflowCameraPresenter.access$isBeepableStep(this.this$0, this.$detectedFrameStep)) {
                            WorkflowCameraPresenter.access$getBeepFlow$p(this.this$0).onNext((Object)new Signal());
                        }
                        object2 = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults();
                        object = this.$detectedFrameStep;
                        workflowStepResult2 = existingResult;
                        if (workflowStepResult2 == null) break block9;
                        WorkflowStepResult it = workflowStepResult = workflowStepResult2;
                        WorkflowStepResult workflowStepResult3 = this.$detectedFrameData.getWorkflowStepResult();
                        if (workflowStepResult3 == null) {
                            Intrinsics.throwNpe();
                        }
                        workflowStepResult3.setCapturedPage(it.getCapturedPage());
                        this.$detectedFrameData.getWorkflowStepResult().setVideoFramePage(it.getVideoFramePage());
                        workflowStepResult2 = this.$detectedFrameData.getWorkflowStepResult();
                        if (workflowStepResult2 != null) break block10;
                    }
                    if ((workflowStepResult2 = this.$detectedFrameData.getWorkflowStepResult()) == null) {
                        Intrinsics.throwNpe();
                    }
                }
                workflowStepResult = workflowStepResult2;
                object2.put(object, workflowStepResult);
                Page page = this.$framePage;
                if (page != null) {
                    Object it = object2 = page;
                    WorkflowStepResult workflowStepResult4 = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults().get(this.$detectedFrameStep);
                    if (workflowStepResult4 == null) {
                        Intrinsics.throwNpe();
                    }
                    workflowStepResult4.setVideoFramePage((Page)it);
                }
                if (!this.$detectedFrameStep.getWantsCapturedPage()) {
                    WorkflowCameraPresenter.access$goToNextStepOrShowResult(this.this$0);
                }
                source.onNext((Object)Signal.signal());
                source.onComplete();
            }
            {
                this.this$0 = workflowCameraPresenter;
                this.$detectedFrameStep = workflowStep;
                this.$detectedFrameData = detectedFrameData;
                this.$framePage = page;
            }
        }, (BackpressureStrategy)BackpressureStrategy.DROP);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.create({ source\u2026ackpressureStrategy.DROP)");
        return flowable;
    }

    static /* synthetic */ Flowable saveDetectionResult$default(WorkflowCameraPresenter workflowCameraPresenter, WorkflowStep workflowStep, WorkflowFrameHandler.DetectedFrameData detectedFrameData, Page page, int n, Object object) {
        if ((n & 4) != 0) {
            page = null;
        }
        return workflowCameraPresenter.saveDetectionResult(workflowStep, detectedFrameData, page);
    }

    private final boolean isBeepableStep(WorkflowStep detectedFrameStep) {
        WorkflowStep workflowStep;
        return !detectedFrameStep.getWantsCapturedPage() && ((workflowStep = detectedFrameStep) instanceof ScanMachineReadableZoneWorkflowStep ? true : (workflowStep instanceof ScanPayFormWorkflowStep ? true : (workflowStep instanceof ScanDisabilityCertificateWorkflowStep ? true : workflowStep instanceof ScanBarCodeWorkflowStep)));
    }

    private final Flowable<Page> saveCameraFrame(WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
        byte[] byArray = detectedFrameData.getFrame();
        int n = detectedFrameData.getFrameOrientation();
        int n2 = detectedFrameData.getFrameWidth();
        int n3 = detectedFrameData.getFrameHeight();
        WorkflowStepResult workflowStepResult = detectedFrameData.getWorkflowStepResult();
        if (workflowStepResult == null) {
            Intrinsics.throwNpe();
        }
        List<PageAspectRatio> list = workflowStepResult.getStep().getRequiredAspectRatios();
        RectF rectF = detectedFrameData.getRectOfInterest();
        if (rectF == null) {
            rectF = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
        }
        return this.saveCameraFrameUseCase.saveCameraFrame(byArray, n, n2, n3, this.imageScale, list, rectF, this.documentImageSizeLimit);
    }

    private final void validateStepResult(WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
        WorkflowStepError validationError;
        WorkflowStepError workflowStepError;
        WorkflowStep workflowStep;
        WorkflowStepResult workflowStepResult = detectedFrameData.getWorkflowStepResult();
        if (workflowStepResult == null) {
            Intrinsics.throwNpe();
        }
        if ((workflowStep = workflowStepResult.getStep()) instanceof ScanDocumentPageWorkflowStep) {
            if (detectedFrameData.getDetectionResult() == DetectionResult.OK) {
                this.frameDataFlow.onNext((Object)detectedFrameData);
            }
        } else if (detectedFrameData.getWorkflowStepResult().getStep().getWantsCapturedPage() && detectedFrameData.getDetectionResult() == DetectionResult.OK) {
            this.frameDataFlow.onNext((Object)detectedFrameData);
        } else if (!detectedFrameData.getWorkflowStepResult().getStep().getWantsCapturedPage() && (workflowStepError = (validationError = (WorkflowStepError)detectedFrameData.getWorkflowStepResult().getStep().getWorkflowStepValidation().invoke(detectedFrameData.getWorkflowStepResult()))) == null) {
            this.frameDataFlow.onNext((Object)detectedFrameData);
            workflowStepError = Unit.INSTANCE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void pageSnapped(@NotNull byte[] image, int imageOrientation) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        WorkflowStep workflowStep = this.stepsCache.getCurrentStep();
        if (workflowStep != null) {
            if (workflowStep.getWantsCapturedPage()) {
                this.storePageInDraftRepository(image, imageOrientation);
                return;
            }
        }
        this.goToNextStepOrShowResult();
    }

    @Override
    public void checkCameraPermission() {
        block0: {
            Disposable disposable;
            Disposable disposable2 = this.checkCameraPermissionUseCase;
            if (disposable2 == null || (disposable2 = disposable2.checkCameraPermission()) == null || (disposable2 = disposable2.subscribe((Consumer)new Consumer<Boolean>(this){
                final /* synthetic */ WorkflowCameraPresenter this$0;

                public final void accept(Boolean cameraPermissionGranted) {
                    if (!cameraPermissionGranted.booleanValue()) {
                        WorkflowCameraPresenter.access$getNavigator$p(this.this$0).navigate("NAVIGATE_REQUEST_CAMERA_PERMISSION");
                    }
                    WorkflowCameraPresenter.access$getState$p(this.this$0).getCameraPermissionGranted().onNext((Object)cameraPermissionGranted);
                }
                {
                    this.this$0 = workflowCameraPresenter;
                }
            })) == null) break block0;
            Disposable it = disposable = disposable2;
            this.subscriptions.add(it);
        }
    }

    private final void storePageInDraftRepository(byte[] image, int imageOrientation) {
        ((IWorkflowCameraView.State)this.state).getPictureProcessing().onNext((Object)true);
        Disposable disposable = this.saveTakenPictureSubscription;
        if (disposable != null) {
            disposable.dispose();
        }
        this.saveTakenPictureSubscription = this.detectOrSkip(image, imageOrientation).flatMap(new Function<T, Publisher<? extends R>>(this, image, imageOrientation){
            final /* synthetic */ WorkflowCameraPresenter this$0;
            final /* synthetic */ byte[] $image;
            final /* synthetic */ int $imageOrientation;

            @NotNull
            public final Flowable<Page> apply(@Nullable WorkflowStepResult it) {
                WorkflowStepResult workflowStepResult = it;
                if (workflowStepResult != null) {
                    WorkflowStepResult workflowStepResult2;
                    WorkflowStepResult it2 = workflowStepResult2 = workflowStepResult;
                    WorkflowStepResult existingResult = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).currentStepResult();
                    if (existingResult == null) {
                        Map map = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults();
                        WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                        if (workflowStep == null) {
                            Intrinsics.throwNpe();
                        }
                        WorkflowStep workflowStep2 = workflowStep;
                        WorkflowStepResult workflowStepResult3 = it2;
                        map.put(workflowStep2, workflowStepResult3);
                    } else {
                        WorkflowStepResult mergedResult = it2;
                        mergedResult.setCapturedPage(existingResult.getCapturedPage());
                        mergedResult.setVideoFramePage(existingResult.getVideoFramePage());
                        Map map = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults();
                        WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                        if (workflowStep == null) {
                            Intrinsics.throwNpe();
                        }
                        WorkflowStep workflowStep3 = workflowStep;
                        WorkflowStepResult workflowStepResult4 = mergedResult;
                        map.put(workflowStep3, workflowStepResult4);
                    }
                }
                SaveTakenPictureUseCase saveTakenPictureUseCase = WorkflowCameraPresenter.access$getSaveTakenPictureUseCase$p(this.this$0);
                float f = WorkflowCameraPresenter.access$getImageScale$p(this.this$0);
                WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                if (workflowStep == null) {
                    Intrinsics.throwNpe();
                }
                List<PageAspectRatio> list = workflowStep.getRequiredAspectRatios();
                StepFrameData stepFrameData = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).currentStepFrameData();
                if (stepFrameData == null || (stepFrameData = stepFrameData.getRectOfInterest()) == null) {
                    stepFrameData = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
                }
                return saveTakenPictureUseCase.saveTakenPicture(this.$image, this.$imageOrientation, f, list, (RectF)stepFrameData, WorkflowCameraPresenter.access$getDocumentImageSizeLimit$p(this.this$0));
            }
            {
                this.this$0 = workflowCameraPresenter;
                this.$image = byArray;
                this.$imageOrientation = n;
            }
        }).subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe((Consumer)new Consumer<Page>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            public final void accept(Page it) {
                WorkflowStepResult existingResult = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).currentStepResult();
                if (existingResult == null) {
                    Map map = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults();
                    WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                    if (workflowStep == null) {
                        Intrinsics.throwNpe();
                    }
                    WorkflowStep workflowStep2 = workflowStep;
                    WorkflowStep workflowStep3 = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                    if (workflowStep3 == null) {
                        Intrinsics.throwNpe();
                    }
                    BasicWorkflowStepResult basicWorkflowStepResult = new BasicWorkflowStepResult(workflowStep3, it, null, 4, null);
                    map.put(workflowStep2, basicWorkflowStepResult);
                } else {
                    existingResult.setCapturedPage(it);
                    Map map = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults();
                    WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                    if (workflowStep == null) {
                        Intrinsics.throwNpe();
                    }
                    WorkflowStep workflowStep4 = workflowStep;
                    WorkflowStepResult workflowStepResult = existingResult;
                    map.put(workflowStep4, workflowStepResult);
                }
                WorkflowCameraPresenter.access$getState$p(this.this$0).getPictureProcessing().onNext((Object)false);
                WorkflowCameraPresenter.access$goToNextStepOrShowResult(this.this$0);
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        }, (Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            public final void accept(Throwable error) {
                if (error instanceof WorkflowDetectionUseCase.InvalidDetectionResult) {
                    WorkflowCameraPresenter.access$getState$p(this.this$0).getErrorProcessing().onNext((Object)true);
                    if (((WorkflowDetectionUseCase.InvalidDetectionResult)error).getWorkflowStepError().getShowMode() == WorkflowStepError.ShowMode.TOAST) {
                        WorkflowCameraPresenter.access$disableErrorProcessingWithDelay(this.this$0);
                    }
                    WorkflowCameraPresenter.access$getState$p(this.this$0).getWorkflowStepError().onNext((Object)((WorkflowDetectionUseCase.InvalidDetectionResult)error).getWorkflowStepError());
                }
                WorkflowCameraPresenter.access$restartCurrentStep(this.this$0);
                WorkflowCameraPresenter.access$getLogger$p(this.this$0).logException(error);
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        });
    }

    private final void disableErrorProcessingWithDelay() {
        this.subscriptions.add(Flowable.timer((long)2L, (TimeUnit)TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Long>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            public final void accept(Long it) {
                WorkflowCameraPresenter.access$getState$p(this.this$0).getErrorProcessing().onNext((Object)false);
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        }));
    }

    private final Flowable<? extends WorkflowStepResult> detectOrSkip(byte[] image, int imageOrientation) {
        Flowable<WorkflowStepResult> flowable;
        WorkflowStep workflowStep = this.stepsCache.getCurrentStep();
        if (workflowStep == null) {
            Intrinsics.throwNpe();
        }
        if (workflowStep.getWantsCapturedPage()) {
            WorkflowStep workflowStep2 = this.stepsCache.getCurrentStep();
            if (workflowStep2 == null) {
                Intrinsics.throwNpe();
            }
            flowable = this.workflowDetectionUseCase.detect(workflowStep2, image, imageOrientation, this.calculateFinderRectF());
        } else {
            flowable = Flowable.just((Object)this.stepsCache.currentStepResult());
        }
        return flowable;
    }

    private final void restartCurrentStep() {
        ((IWorkflowCameraView.State)this.state).getPictureProcessing().onNext((Object)false);
        WorkflowStepResult workflowStepResult = this.stepsCache.currentStepResult();
        if (workflowStepResult != null) {
            Page it;
            Page page;
            WorkflowStepResult workflowStepResult2;
            WorkflowStepResult result = workflowStepResult2 = workflowStepResult;
            Page page2 = result.getVideoFramePage();
            if (page2 != null) {
                it = page = page2;
                this.removePageUseCase.removePage(it).subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe();
            }
            Page page3 = result.getCapturedPage();
            if (page3 != null) {
                it = page = page3;
                this.removePageUseCase.removePage(it).subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe();
            }
        }
        HashMap<WorkflowStep, WorkflowStepResult> hashMap = this.stepsCache.getStepResults();
        WorkflowStep workflowStep = this.stepsCache.getCurrentStep();
        if (workflowStep == null) {
            Intrinsics.throwNpe();
        }
        hashMap.remove(workflowStep);
        HashMap<WorkflowStep, StepFrameData> hashMap2 = this.stepsCache.getStepFrameData();
        WorkflowStep workflowStep2 = this.stepsCache.getCurrentStep();
        if (workflowStep2 == null) {
            Intrinsics.throwNpe();
        }
        hashMap2.remove(workflowStep2);
        ((IWorkflowCameraView.State)this.state).getCurrentStep().onNext((Object)this.stepsCache.getCurrentStep());
    }

    private final RectF calculateFinderRectF() {
        RectF rectF;
        StepFrameData frameData = this.stepsCache.currentStepFrameData();
        StepFrameData stepFrameData = frameData;
        if (stepFrameData != null && (stepFrameData = stepFrameData.getFinderRect()) != null) {
            StepFrameData stepFrameData2;
            StepFrameData it = stepFrameData2 = stepFrameData;
            int frameWidth = frameData.getFrameWidth();
            int frameHeight = frameData.getFrameHeight();
            int frameOrientation = frameData.getFrameOrientation();
            int rotatedFrameWidth = frameWidth;
            int rotatedFrameHeight = frameHeight;
            if (frameOrientation % 180 != 0) {
                rotatedFrameWidth = frameHeight;
                rotatedFrameHeight = frameWidth;
            }
            rectF = new RectF((float)((Rect)it).left / (float)rotatedFrameWidth, (float)((Rect)it).top / (float)rotatedFrameHeight, (float)((Rect)it).right / (float)rotatedFrameWidth, (float)((Rect)it).bottom / (float)rotatedFrameHeight);
        } else {
            rectF = null;
        }
        return rectF;
    }

    private final void goToNextStepOrShowResult() {
        WorkflowStep workflowStep;
        WorkflowStep it = workflowStep = this.stepsCache.getCurrentStep();
        int currentStateIndex = CollectionsKt.indexOf(this.workflow.getSteps(), (Object)it);
        if (currentStateIndex != CollectionsKt.getLastIndex(this.workflow.getSteps())) {
            this.stepsCache.setCurrentStep(this.workflow.getSteps().get(currentStateIndex + 1));
            ((IWorkflowCameraView.State)this.state).getCurrentStep().onNext((Object)this.stepsCache.getCurrentStep());
        } else {
            WorkflowStep it2;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = this.workflow.getSteps();
            Workflow workflow = this.workflow;
            Navigator navigator = this.navigator;
            void var9_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it2 = (WorkflowStep)element$iv$iv;
                if (!(this.stepsCache.getStepResults().get(it2) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<WorkflowStepResult> collection = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv = (Iterable)collection;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                WorkflowStepResult workflowStepResult;
                it2 = (WorkflowStep)item$iv$iv;
                collection = destination$iv$iv;
                if (this.stepsCache.getStepResults().get(it2) == null) {
                    Intrinsics.throwNpe();
                }
                collection.add(workflowStepResult);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            Workflow workflow2 = workflow;
            navigator.navigate(new FinishWorkflow(workflow2, list));
        }
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        this.flashConfiguration = flashEnabled;
    }

    public final void setImageScale(float imageScale) {
        this.imageScale = imageScale;
    }

    public final void setDocumentImageSizeLimit(@NotNull PageStorageProcessor.Configuration.Size documentImageSizeLimit) {
        Intrinsics.checkParameterIsNotNull((Object)documentImageSizeLimit, (String)"documentImageSizeLimit");
        this.documentImageSizeLimit = documentImageSizeLimit;
    }

    public final void setCleanupOnCancel(boolean cleanupOnCancel) {
        this.cleanupOnCancel = cleanupOnCancel;
    }

    @Nullable
    public final CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return this.checkCameraPermissionUseCase;
    }

    public final void setCheckCameraPermissionUseCase(@Nullable CheckCameraPermissionUseCase checkCameraPermissionUseCase) {
        this.checkCameraPermissionUseCase = checkCameraPermissionUseCase;
    }

    @Inject
    public WorkflowCameraPresenter(@Nullable CheckCameraPermissionUseCase checkCameraPermissionUseCase, @NotNull SaveTakenPictureUseCase saveTakenPictureUseCase, @NotNull SaveCameraFrameUseCase saveCameraFrameUseCase, @NotNull WorkflowDetectionUseCase workflowDetectionUseCase, @NotNull RemovePageUseCase removePageUseCase, @NotNull Navigator navigator, @BackgroundTaskScheduler @NotNull Scheduler backgroundTaskScheduler, @UiScheduler @NotNull Scheduler uiScheduler) {
        Intrinsics.checkParameterIsNotNull((Object)saveTakenPictureUseCase, (String)"saveTakenPictureUseCase");
        Intrinsics.checkParameterIsNotNull((Object)saveCameraFrameUseCase, (String)"saveCameraFrameUseCase");
        Intrinsics.checkParameterIsNotNull((Object)workflowDetectionUseCase, (String)"workflowDetectionUseCase");
        Intrinsics.checkParameterIsNotNull((Object)removePageUseCase, (String)"removePageUseCase");
        Intrinsics.checkParameterIsNotNull((Object)navigator, (String)"navigator");
        Intrinsics.checkParameterIsNotNull((Object)backgroundTaskScheduler, (String)"backgroundTaskScheduler");
        Intrinsics.checkParameterIsNotNull((Object)uiScheduler, (String)"uiScheduler");
        this.checkCameraPermissionUseCase = checkCameraPermissionUseCase;
        this.saveTakenPictureUseCase = saveTakenPictureUseCase;
        this.saveCameraFrameUseCase = saveCameraFrameUseCase;
        this.workflowDetectionUseCase = workflowDetectionUseCase;
        this.removePageUseCase = removePageUseCase;
        this.navigator = navigator;
        this.backgroundTaskScheduler = backgroundTaskScheduler;
        this.uiScheduler = uiScheduler;
        this.subscriptions = new CompositeDisposable();
        this.workflow = new Workflow(null, null, 3, null);
        this.stepsCache = new WorkflowStepsCache(null, null, null, 7, null);
        this.frameDataFlow = PublishProcessor.create();
        this.beepFlow = PublishProcessor.create();
        this.imageScale = 1.0f;
        this.cleanupOnCancel = true;
        this.documentImageSizeLimit = PageStorageProcessor.Configuration.Companion.DEFAULT().getDocumentImageSizeLimit();
        Logger logger = LoggerProvider.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerProvider.getLogger()");
        this.logger = logger;
    }

    @NotNull
    public static final /* synthetic */ Navigator access$getNavigator$p(WorkflowCameraPresenter $this) {
        return $this.navigator;
    }

    public static final /* synthetic */ IWorkflowCameraView.State access$getState$p(WorkflowCameraPresenter $this) {
        return (IWorkflowCameraView.State)$this.state;
    }

    public static final /* synthetic */ void access$setState$p(WorkflowCameraPresenter $this, IWorkflowCameraView.State state) {
        $this.state = state;
    }

    @NotNull
    public static final /* synthetic */ WorkflowStepsCache access$getStepsCache$p(WorkflowCameraPresenter $this) {
        return $this.stepsCache;
    }

    @NotNull
    public static final /* synthetic */ Flowable access$saveCameraFrame(WorkflowCameraPresenter $this, @NotNull WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
        return $this.saveCameraFrame(detectedFrameData);
    }

    @NotNull
    public static final /* synthetic */ Flowable access$saveDetectionResult(WorkflowCameraPresenter $this, @NotNull WorkflowStep detectedFrameStep, @NotNull WorkflowFrameHandler.DetectedFrameData detectedFrameData, @Nullable Page framePage) {
        return $this.saveDetectionResult(detectedFrameStep, detectedFrameData, framePage);
    }

    public static final /* synthetic */ void access$restartCurrentStep(WorkflowCameraPresenter $this) {
        $this.restartCurrentStep();
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(WorkflowCameraPresenter $this) {
        return $this.logger;
    }

    public static final /* synthetic */ boolean access$isBeepableStep(WorkflowCameraPresenter $this, @NotNull WorkflowStep detectedFrameStep) {
        return $this.isBeepableStep(detectedFrameStep);
    }

    public static final /* synthetic */ PublishProcessor access$getBeepFlow$p(WorkflowCameraPresenter $this) {
        return $this.beepFlow;
    }

    public static final /* synthetic */ void access$goToNextStepOrShowResult(WorkflowCameraPresenter $this) {
        $this.goToNextStepOrShowResult();
    }

    @NotNull
    public static final /* synthetic */ SaveTakenPictureUseCase access$getSaveTakenPictureUseCase$p(WorkflowCameraPresenter $this) {
        return $this.saveTakenPictureUseCase;
    }

    public static final /* synthetic */ float access$getImageScale$p(WorkflowCameraPresenter $this) {
        return $this.imageScale;
    }

    public static final /* synthetic */ void access$setImageScale$p(WorkflowCameraPresenter $this, float f) {
        $this.imageScale = f;
    }

    @NotNull
    public static final /* synthetic */ PageStorageProcessor.Configuration.Size access$getDocumentImageSizeLimit$p(WorkflowCameraPresenter $this) {
        return $this.documentImageSizeLimit;
    }

    public static final /* synthetic */ void access$setDocumentImageSizeLimit$p(WorkflowCameraPresenter $this, @NotNull PageStorageProcessor.Configuration.Size size) {
        $this.documentImageSizeLimit = size;
    }

    public static final /* synthetic */ void access$disableErrorProcessingWithDelay(WorkflowCameraPresenter $this) {
        $this.disableErrorProcessingWithDelay();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$FinishWorkflow;", "", "workflow", "Lio/scanbot/sdk/ui/entity/workflow/Workflow;", "workflowResults", "", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "(Lio/scanbot/sdk/ui/entity/workflow/Workflow;Ljava/util/List;)V", "getWorkflow", "()Lio/scanbot/sdk/ui/entity/workflow/Workflow;", "getWorkflowResults", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "scanbot-sdk-ui_release"})
    public static final class FinishWorkflow {
        @NotNull
        private final Workflow workflow;
        @NotNull
        private final List<WorkflowStepResult> workflowResults;

        @NotNull
        public final Workflow getWorkflow() {
            return this.workflow;
        }

        @NotNull
        public final List<WorkflowStepResult> getWorkflowResults() {
            return this.workflowResults;
        }

        public FinishWorkflow(@NotNull Workflow workflow, @NotNull List<? extends WorkflowStepResult> workflowResults) {
            Intrinsics.checkParameterIsNotNull((Object)workflow, (String)"workflow");
            Intrinsics.checkParameterIsNotNull(workflowResults, (String)"workflowResults");
            this.workflow = workflow;
            this.workflowResults = workflowResults;
        }

        @NotNull
        public final Workflow component1() {
            return this.workflow;
        }

        @NotNull
        public final List<WorkflowStepResult> component2() {
            return this.workflowResults;
        }

        @NotNull
        public final FinishWorkflow copy(@NotNull Workflow workflow, @NotNull List<? extends WorkflowStepResult> workflowResults) {
            Intrinsics.checkParameterIsNotNull((Object)workflow, (String)"workflow");
            Intrinsics.checkParameterIsNotNull(workflowResults, (String)"workflowResults");
            return new FinishWorkflow(workflow, workflowResults);
        }

        @NotNull
        public static /* synthetic */ FinishWorkflow copy$default(FinishWorkflow finishWorkflow2, Workflow workflow, List list, int n, Object object) {
            if ((n & 1) != 0) {
                workflow = finishWorkflow2.workflow;
            }
            if ((n & 2) != 0) {
                list = finishWorkflow2.workflowResults;
            }
            return finishWorkflow2.copy(workflow, list);
        }

        @NotNull
        public String toString() {
            return "FinishWorkflow(workflow=" + this.workflow + ", workflowResults=" + this.workflowResults + ")";
        }

        public int hashCode() {
            Workflow workflow = this.workflow;
            List<WorkflowStepResult> list = this.workflowResults;
            return (workflow != null ? ((Object)workflow).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FinishWorkflow)) break block3;
                    FinishWorkflow finishWorkflow2 = (FinishWorkflow)object;
                    if (!Intrinsics.areEqual((Object)this.workflow, (Object)finishWorkflow2.workflow) || !Intrinsics.areEqual(this.workflowResults, finishWorkflow2.workflowResults)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B]\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012$\b\u0002\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006`\u0007\u0012$\b\u0002\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t`\u0007\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J%\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006`\u0007H\u00c6\u0003J%\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t`\u0007H\u00c6\u0003Ja\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032$\b\u0002\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006`\u00072$\b\u0002\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t`\u0007H\u00c6\u0001J\b\u0010\u0016\u001a\u0004\u0018\u00010\tJ\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$WorkflowStepsCache;", "", "currentStep", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "stepResults", "Ljava/util/HashMap;", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "Lkotlin/collections/HashMap;", "stepFrameData", "Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$StepFrameData;", "(Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;Ljava/util/HashMap;Ljava/util/HashMap;)V", "getCurrentStep", "()Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "setCurrentStep", "(Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;)V", "getStepFrameData", "()Ljava/util/HashMap;", "getStepResults", "component1", "component2", "component3", "copy", "currentStepFrameData", "currentStepResult", "equals", "", "other", "hashCode", "", "toString", "", "scanbot-sdk-ui_release"})
    private static final class WorkflowStepsCache {
        @Nullable
        private WorkflowStep currentStep;
        @NotNull
        private final HashMap<WorkflowStep, WorkflowStepResult> stepResults;
        @NotNull
        private final HashMap<WorkflowStep, StepFrameData> stepFrameData;

        @Nullable
        public final WorkflowStepResult currentStepResult() {
            Map map = this.stepResults;
            WorkflowStep workflowStep = this.currentStep;
            return (WorkflowStepResult)map.get(workflowStep);
        }

        @Nullable
        public final StepFrameData currentStepFrameData() {
            Map map = this.stepFrameData;
            WorkflowStep workflowStep = this.currentStep;
            return (StepFrameData)map.get(workflowStep);
        }

        @Nullable
        public final WorkflowStep getCurrentStep() {
            return this.currentStep;
        }

        public final void setCurrentStep(@Nullable WorkflowStep workflowStep) {
            this.currentStep = workflowStep;
        }

        @NotNull
        public final HashMap<WorkflowStep, WorkflowStepResult> getStepResults() {
            return this.stepResults;
        }

        @NotNull
        public final HashMap<WorkflowStep, StepFrameData> getStepFrameData() {
            return this.stepFrameData;
        }

        public WorkflowStepsCache(@Nullable WorkflowStep currentStep, @NotNull HashMap<WorkflowStep, WorkflowStepResult> stepResults, @NotNull HashMap<WorkflowStep, StepFrameData> stepFrameData) {
            Intrinsics.checkParameterIsNotNull(stepResults, (String)"stepResults");
            Intrinsics.checkParameterIsNotNull(stepFrameData, (String)"stepFrameData");
            this.currentStep = currentStep;
            this.stepResults = stepResults;
            this.stepFrameData = stepFrameData;
        }

        public /* synthetic */ WorkflowStepsCache(WorkflowStep workflowStep, HashMap hashMap, HashMap hashMap2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                workflowStep = null;
            }
            if ((n & 2) != 0) {
                hashMap = new HashMap<WorkflowStep, WorkflowStepResult>();
            }
            if ((n & 4) != 0) {
                hashMap2 = new HashMap<WorkflowStep, StepFrameData>();
            }
            this(workflowStep, hashMap, hashMap2);
        }

        public WorkflowStepsCache() {
            this(null, null, null, 7, null);
        }

        @Nullable
        public final WorkflowStep component1() {
            return this.currentStep;
        }

        @NotNull
        public final HashMap<WorkflowStep, WorkflowStepResult> component2() {
            return this.stepResults;
        }

        @NotNull
        public final HashMap<WorkflowStep, StepFrameData> component3() {
            return this.stepFrameData;
        }

        @NotNull
        public final WorkflowStepsCache copy(@Nullable WorkflowStep currentStep, @NotNull HashMap<WorkflowStep, WorkflowStepResult> stepResults, @NotNull HashMap<WorkflowStep, StepFrameData> stepFrameData) {
            Intrinsics.checkParameterIsNotNull(stepResults, (String)"stepResults");
            Intrinsics.checkParameterIsNotNull(stepFrameData, (String)"stepFrameData");
            return new WorkflowStepsCache(currentStep, stepResults, stepFrameData);
        }

        @NotNull
        public static /* synthetic */ WorkflowStepsCache copy$default(WorkflowStepsCache workflowStepsCache, WorkflowStep workflowStep, HashMap hashMap, HashMap hashMap2, int n, Object object) {
            if ((n & 1) != 0) {
                workflowStep = workflowStepsCache.currentStep;
            }
            if ((n & 2) != 0) {
                hashMap = workflowStepsCache.stepResults;
            }
            if ((n & 4) != 0) {
                hashMap2 = workflowStepsCache.stepFrameData;
            }
            return workflowStepsCache.copy(workflowStep, hashMap, hashMap2);
        }

        @NotNull
        public String toString() {
            return "WorkflowStepsCache(currentStep=" + this.currentStep + ", stepResults=" + this.stepResults + ", stepFrameData=" + this.stepFrameData + ")";
        }

        public int hashCode() {
            WorkflowStep workflowStep = this.currentStep;
            HashMap<WorkflowStep, WorkflowStepResult> hashMap = this.stepResults;
            HashMap<WorkflowStep, StepFrameData> hashMap2 = this.stepFrameData;
            return ((workflowStep != null ? workflowStep.hashCode() : 0) * 31 + (hashMap != null ? ((Object)hashMap).hashCode() : 0)) * 31 + (hashMap2 != null ? ((Object)hashMap2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof WorkflowStepsCache)) break block3;
                    WorkflowStepsCache workflowStepsCache = (WorkflowStepsCache)object;
                    if (!Intrinsics.areEqual((Object)this.currentStep, (Object)workflowStepsCache.currentStep) || !Intrinsics.areEqual(this.stepResults, workflowStepsCache.stepResults) || !Intrinsics.areEqual(this.stepFrameData, workflowStepsCache.stepFrameData)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B;\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u00c6\u0003J?\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$StepFrameData;", "", "detectedFrameData", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "(Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;)V", "frameOrientation", "", "frameWidth", "frameHeight", "finderRect", "Landroid/graphics/Rect;", "rectOfInterest", "Landroid/graphics/RectF;", "(IIILandroid/graphics/Rect;Landroid/graphics/RectF;)V", "getFinderRect", "()Landroid/graphics/Rect;", "getFrameHeight", "()I", "getFrameOrientation", "getFrameWidth", "getRectOfInterest", "()Landroid/graphics/RectF;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "scanbot-sdk-ui_release"})
    private static final class StepFrameData {
        private final int frameOrientation;
        private final int frameWidth;
        private final int frameHeight;
        @Nullable
        private final Rect finderRect;
        @Nullable
        private final RectF rectOfInterest;

        public final int getFrameOrientation() {
            return this.frameOrientation;
        }

        public final int getFrameWidth() {
            return this.frameWidth;
        }

        public final int getFrameHeight() {
            return this.frameHeight;
        }

        @Nullable
        public final Rect getFinderRect() {
            return this.finderRect;
        }

        @Nullable
        public final RectF getRectOfInterest() {
            return this.rectOfInterest;
        }

        public StepFrameData(int frameOrientation, int frameWidth, int frameHeight, @Nullable Rect finderRect, @Nullable RectF rectOfInterest) {
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.finderRect = finderRect;
            this.rectOfInterest = rectOfInterest;
        }

        public /* synthetic */ StepFrameData(int n, int n2, int n3, Rect rect, RectF rectF, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            if ((n4 & 8) != 0) {
                rect = null;
            }
            if ((n4 & 0x10) != 0) {
                rectF = null;
            }
            this(n, n2, n3, rect, rectF);
        }

        public StepFrameData() {
            this(0, 0, 0, null, null, 31, null);
        }

        public StepFrameData(@NotNull WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
            Intrinsics.checkParameterIsNotNull((Object)detectedFrameData, (String)"detectedFrameData");
            this(detectedFrameData.getFrameOrientation(), detectedFrameData.getFrameWidth(), detectedFrameData.getFrameHeight(), detectedFrameData.getFinderRect(), detectedFrameData.getRectOfInterest());
        }

        public final int component1() {
            return this.frameOrientation;
        }

        public final int component2() {
            return this.frameWidth;
        }

        public final int component3() {
            return this.frameHeight;
        }

        @Nullable
        public final Rect component4() {
            return this.finderRect;
        }

        @Nullable
        public final RectF component5() {
            return this.rectOfInterest;
        }

        @NotNull
        public final StepFrameData copy(int frameOrientation, int frameWidth, int frameHeight, @Nullable Rect finderRect, @Nullable RectF rectOfInterest) {
            return new StepFrameData(frameOrientation, frameWidth, frameHeight, finderRect, rectOfInterest);
        }

        @NotNull
        public static /* synthetic */ StepFrameData copy$default(StepFrameData stepFrameData, int n, int n2, int n3, Rect rect, RectF rectF, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = stepFrameData.frameOrientation;
            }
            if ((n4 & 2) != 0) {
                n2 = stepFrameData.frameWidth;
            }
            if ((n4 & 4) != 0) {
                n3 = stepFrameData.frameHeight;
            }
            if ((n4 & 8) != 0) {
                rect = stepFrameData.finderRect;
            }
            if ((n4 & 0x10) != 0) {
                rectF = stepFrameData.rectOfInterest;
            }
            return stepFrameData.copy(n, n2, n3, rect, rectF);
        }

        @NotNull
        public String toString() {
            return "StepFrameData(frameOrientation=" + this.frameOrientation + ", frameWidth=" + this.frameWidth + ", frameHeight=" + this.frameHeight + ", finderRect=" + this.finderRect + ", rectOfInterest=" + this.rectOfInterest + ")";
        }

        public int hashCode() {
            Rect rect = this.finderRect;
            RectF rectF = this.rectOfInterest;
            return (((this.frameOrientation * 31 + this.frameWidth) * 31 + this.frameHeight) * 31 + (rect != null ? rect.hashCode() : 0)) * 31 + (rectF != null ? rectF.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StepFrameData)) break block3;
                    StepFrameData stepFrameData = (StepFrameData)object;
                    if (!(this.frameOrientation == stepFrameData.frameOrientation) || !(this.frameWidth == stepFrameData.frameWidth) || !(this.frameHeight == stepFrameData.frameHeight) || !Intrinsics.areEqual((Object)this.finderRect, (Object)stepFrameData.finderRect) || !Intrinsics.areEqual((Object)this.rectOfInterest, (Object)stepFrameData.rectOfInterest)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$Companion;", "", "()V", "ERROR_PROCESSING_DELAY_IN_SECONDS", "", "NAVIGATE_CAMERA_PERMISSION_SETTINGS", "", "NAVIGATE_CANCEL_LICENSE_INVALID", "NAVIGATE_CANCEL_SNAPPING", "NAVIGATE_CLOSE_SNAPPING", "NAVIGATE_PLAY_BEEP", "NAVIGATE_REQUEST_CAMERA_PERMISSION", "scanbot-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

