/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.workflow.camera;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import io.scanbot.dcscanner.model.DisabilityCertificateRecognizerResultInfo;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.persistence.PolygonHelper;
import io.scanbot.sdk.ui.entity.workflow.BarcodeWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.DisabilityCertificateWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.MRZWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanDocumentPageWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStepResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.dcscanner.DCScanner;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import net.doo.snap.mrzscanner.MRZScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\b\u0016\u0018\u0000 K2\u00020\u0001:\u0003KLMB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\rJ\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010.\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020/2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u00100\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u0002012\u0006\u0010*\u001a\u00020+H\u0002J2\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u000208H\u0002J\u001c\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00107\u001a\u0002082\b\u0010=\u001a\u0004\u0018\u00010<H\u0002J(\u0010>\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\u0006\u00107\u001a\u0002082\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0002J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020BH\u0004J\u000e\u0010C\u001a\u00020&2\u0006\u0010'\u001a\u00020\rJ\u000e\u0010D\u001a\u00020&2\u0006\u0010E\u001a\u00020FJ\u000e\u0010G\u001a\u00020&2\u0006\u0010H\u001a\u00020FJ\u0014\u0010I\u001a\u00020&2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006N"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler;", "Lnet/doo/snap/camera/PreviewBuffer$FrameHandler;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "barcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "contourDetector", "Lnet/doo/snap/lib/detector/ContourDetector;", "dcScanner", "Lnet/doo/snap/dcscanner/DCScanner;", "handlers", "Ljava/util/LinkedHashSet;", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$ResultHandler;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "mrzScanner", "Lnet/doo/snap/mrzscanner/MRZScanner;", "requiredPageAspectRatios", "", "Lnet/doo/snap/lib/detector/PageAspectRatio;", "scanbotSDK", "Lio/scanbot/sdk/ScanbotSDK;", "getScanbotSDK", "()Lio/scanbot/sdk/ScanbotSDK;", "workflowStep", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "getWorkflowStep", "()Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "setWorkflowStep", "(Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;)V", "addResultHandler", "", "handler", "detectBarcode", "Lio/scanbot/sdk/ui/entity/workflow/BarcodeWorkflowStep;", "previewFrame", "Lnet/doo/snap/camera/PreviewBuffer$FrameHandler$Frame;", "detectContour", "Lio/scanbot/sdk/ui/entity/workflow/ScanDocumentPageWorkflowStep;", "detectDC", "Lio/scanbot/sdk/ui/entity/workflow/DisabilityCertificateWorkflowStep;", "detectMRZ", "Lio/scanbot/sdk/ui/entity/workflow/MRZWorkflowStep;", "detectOffCenter", "Lnet/doo/snap/lib/detector/DetectionResult;", "finderRect", "Landroid/graphics/Rect;", "detectionResult", "frameOrientation", "", "width", "height", "fixRectOfInterest", "Landroid/graphics/RectF;", "visibleRect", "fixRequiredAspectRatios", "handleFrame", "notifyHandlers", "detectedFrameData", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "removeResultHandler", "setAcceptedAngleScore", "acceptedAngleScore", "", "setAcceptedSizeScore", "acceptedSizeScore", "setRequiredAspectRatios", "requiredAspectRatios", "Companion", "DetectedFrameData", "ResultHandler", "scanbot-sdk-ui_release"})
public class WorkflowFrameHandler
implements PreviewBuffer.FrameHandler {
    @NotNull
    private final ScanbotSDK scanbotSDK;
    private final ContourDetector contourDetector;
    private final MRZScanner mrzScanner;
    private final ScanbotBarcodeDetector barcodeDetector;
    private final DCScanner dcScanner;
    private final LinkedHashSet<ResultHandler> handlers;
    private final Logger logger;
    private boolean isEnabled;
    @NotNull
    public WorkflowStep workflowStep;
    private List<? extends PageAspectRatio> requiredPageAspectRatios;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final ScanbotSDK getScanbotSDK() {
        return this.scanbotSDK;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @NotNull
    public final WorkflowStep getWorkflowStep() {
        WorkflowStep workflowStep = this.workflowStep;
        if (workflowStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"workflowStep");
        }
        return workflowStep;
    }

    public final void setWorkflowStep(@NotNull WorkflowStep workflowStep) {
        Intrinsics.checkParameterIsNotNull((Object)workflowStep, (String)"<set-?>");
        this.workflowStep = workflowStep;
    }

    public synchronized boolean handleFrame(@NotNull PreviewBuffer.FrameHandler.Frame previewFrame) {
        Intrinsics.checkParameterIsNotNull((Object)previewFrame, (String)"previewFrame");
        this.logger.logMethod();
        if (!this.isEnabled) {
            return false;
        }
        if (!this.scanbotSDK.isLicenseValid()) {
            throw (Throwable)new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        WorkflowStep workflowStep = this.workflowStep;
        if (workflowStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"workflowStep");
        }
        if (workflowStep != null) {
            boolean bl;
            WorkflowStep workflowStep2 = workflowStep;
            WorkflowStep it = workflowStep2;
            WorkflowStep workflowStep3 = it;
            if (workflowStep3 instanceof ScanDocumentPageWorkflowStep) {
                bl = this.detectContour((ScanDocumentPageWorkflowStep)it, previewFrame);
            } else if (workflowStep3 instanceof MRZWorkflowStep) {
                bl = this.detectMRZ((MRZWorkflowStep)it, previewFrame);
            } else if (workflowStep3 instanceof BarcodeWorkflowStep) {
                bl = this.detectBarcode((BarcodeWorkflowStep)it, previewFrame);
            } else if (workflowStep3 instanceof DisabilityCertificateWorkflowStep) {
                bl = this.detectDC((DisabilityCertificateWorkflowStep)it, previewFrame);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }
        return false;
    }

    private final boolean detectBarcode(BarcodeWorkflowStep workflowStep, PreviewBuffer.FrameHandler.Frame previewFrame) {
        BarcodeScanningResult barcodeScanningResult;
        DetectionResult detectionResult;
        block8: {
            Rect rect;
            block10: {
                block9: {
                    Rect it;
                    detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
                    if (workflowStep.getWantsCapturedPage()) {
                        Rect rect2;
                        Rect rect3 = this.fixRequiredAspectRatios(previewFrame.frameOrientation, this.requiredPageAspectRatios);
                        if (rect3 != null) {
                            it = rect2 = rect3;
                            this.contourDetector.setRequiredAspectRatios(it);
                        }
                        RectF rectF = this.fixRectOfInterest(previewFrame.frameOrientation, previewFrame.visibleRect);
                        if (rectF != null) {
                            it = rect2 = rectF;
                            this.contourDetector.setRectOfInterest((RectF)it);
                        }
                        DetectionResult detectionResult2 = this.contourDetector.detect(previewFrame.frame, previewFrame.width, previewFrame.height);
                        Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult2, (String)"contourDetector.detect(p\u2026dth, previewFrame.height)");
                        detectionResult = detectionResult2;
                        detectionResult = this.detectOffCenter(previewFrame.finderRect, detectionResult, previewFrame.frameOrientation, previewFrame.width, previewFrame.height);
                    }
                    barcodeScanningResult = null;
                    if (workflowStep.getWantsCapturedPage() && detectionResult != DetectionResult.OK && detectionResult != DetectionResult.OK_BUT_BAD_ASPECT_RATIO) break block8;
                    if (!workflowStep.getAcceptedCodeTypes().isEmpty()) {
                        this.barcodeDetector.setBarcodeFormatsFilter(workflowStep.getAcceptedCodeTypes());
                    }
                    if ((rect = previewFrame.finderRect) == null) break block9;
                    Rect it2 = it = rect;
                    Intrinsics.checkExpressionValueIsNotNull((Object)previewFrame.frame, (String)"previewFrame.frame");
                    BarcodeScanningResult barcodeScanningResult2 = this.barcodeDetector.decodeWithState(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation, it2);
                    rect = barcodeScanningResult2;
                    if (barcodeScanningResult2 != null) break block10;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)previewFrame.frame, (String)"previewFrame.frame");
                rect = this.barcodeDetector.decodeWithState(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation);
            }
            barcodeScanningResult = rect;
        }
        List list = this.contourDetector.getPolygonF();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"contourDetector.polygonF");
        int n = previewFrame.frameOrientation;
        int n2 = previewFrame.width;
        int n3 = previewFrame.height;
        double d = this.contourDetector.getDetectionScore();
        Rect rect = previewFrame.finderRect;
        RectF rectF = previewFrame.visibleRect;
        List list2 = this.requiredPageAspectRatios;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        DetectedFrameData detectedFrame = new DetectedFrameData(detectionResult, list, n, n2, n3, d, rect, rectF, list2, null, barcodeScanningResult, null, workflowStep);
        return this.notifyHandlers(detectedFrame);
    }

    private final boolean detectMRZ(MRZWorkflowStep workflowStep, PreviewBuffer.FrameHandler.Frame previewFrame) {
        DetectionResult detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
        if (workflowStep.getWantsCapturedPage()) {
            RectF it;
            RectF rectF;
            RectF rectF2 = this.fixRequiredAspectRatios(previewFrame.frameOrientation, this.requiredPageAspectRatios);
            if (rectF2 != null) {
                it = rectF = rectF2;
                this.contourDetector.setRequiredAspectRatios(it);
            }
            RectF rectF3 = this.fixRectOfInterest(previewFrame.frameOrientation, previewFrame.visibleRect);
            if (rectF3 != null) {
                it = rectF = rectF3;
                this.contourDetector.setRectOfInterest(it);
            }
            DetectionResult detectionResult2 = this.contourDetector.detect(previewFrame.frame, previewFrame.width, previewFrame.height);
            Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult2, (String)"contourDetector.detect(p\u2026dth, previewFrame.height)");
            detectionResult = detectionResult2;
            detectionResult = this.detectOffCenter(previewFrame.finderRect, detectionResult, previewFrame.frameOrientation, previewFrame.width, previewFrame.height);
        }
        MRZRecognitionResult mrzRecognitionResult = null;
        if (!workflowStep.getWantsCapturedPage() || detectionResult == DetectionResult.OK || detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO) {
            int mrzTop = previewFrame.finderRect.bottom - previewFrame.finderRect.height() / 3;
            Rect mrzRect = new Rect(previewFrame.finderRect.left, mrzTop, previewFrame.finderRect.right, previewFrame.finderRect.bottom);
            mrzRecognitionResult = this.mrzScanner.recognizeMRZWithFinderOverlay(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation, mrzRect, false);
        }
        List list = this.contourDetector.getPolygonF();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"contourDetector.polygonF");
        int n = previewFrame.frameOrientation;
        int n2 = previewFrame.width;
        int n3 = previewFrame.height;
        double d = this.contourDetector.getDetectionScore();
        Rect rect = previewFrame.finderRect;
        RectF rectF = previewFrame.visibleRect;
        List list2 = this.requiredPageAspectRatios;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        DetectedFrameData detectedFrame = new DetectedFrameData(detectionResult, list, n, n2, n3, d, rect, rectF, list2, mrzRecognitionResult, null, null, workflowStep);
        return this.notifyHandlers(detectedFrame);
    }

    private final boolean detectContour(ScanDocumentPageWorkflowStep workflowStep, PreviewBuffer.FrameHandler.Frame previewFrame) {
        RectF it;
        RectF rectF;
        RectF rectF2 = this.fixRequiredAspectRatios(previewFrame.frameOrientation, this.requiredPageAspectRatios);
        if (rectF2 != null) {
            it = rectF = rectF2;
            this.contourDetector.setRequiredAspectRatios(it);
        }
        RectF rectF3 = this.fixRectOfInterest(previewFrame.frameOrientation, previewFrame.visibleRect);
        if (rectF3 != null) {
            it = rectF = rectF3;
            this.contourDetector.setRectOfInterest(it);
        }
        DetectionResult detectionResult = this.contourDetector.detect(previewFrame.frame, previewFrame.width, previewFrame.height);
        Rect rect = previewFrame.finderRect;
        DetectionResult detectionResult2 = detectionResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult2, (String)"detectionResult");
        detectionResult = this.detectOffCenter(rect, detectionResult2, previewFrame.frameOrientation, previewFrame.width, previewFrame.height);
        List list = this.contourDetector.getPolygonF();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"contourDetector.polygonF");
        int n = previewFrame.frameOrientation;
        int n2 = previewFrame.width;
        int n3 = previewFrame.height;
        double d = this.contourDetector.getDetectionScore();
        Rect rect2 = previewFrame.finderRect;
        RectF rectF4 = previewFrame.visibleRect;
        List list2 = this.requiredPageAspectRatios;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        DetectedFrameData detectedFrame = new DetectedFrameData(detectionResult, list, n, n2, n3, d, rect2, rectF4, list2, workflowStep);
        return this.notifyHandlers(detectedFrame);
    }

    private final boolean detectDC(DisabilityCertificateWorkflowStep workflowStep, PreviewBuffer.FrameHandler.Frame previewFrame) {
        DetectionResult detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
        if (workflowStep.getWantsCapturedPage()) {
            RectF it;
            RectF rectF;
            RectF rectF2 = this.fixRequiredAspectRatios(previewFrame.frameOrientation, this.requiredPageAspectRatios);
            if (rectF2 != null) {
                it = rectF = rectF2;
                this.contourDetector.setRequiredAspectRatios(it);
            }
            RectF rectF3 = this.fixRectOfInterest(previewFrame.frameOrientation, previewFrame.visibleRect);
            if (rectF3 != null) {
                it = rectF = rectF3;
                this.contourDetector.setRectOfInterest(it);
            }
            DetectionResult detectionResult2 = this.contourDetector.detect(previewFrame.frame, previewFrame.width, previewFrame.height);
            Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult2, (String)"contourDetector.detect(p\u2026dth, previewFrame.height)");
            detectionResult = detectionResult2;
            detectionResult = this.detectOffCenter(previewFrame.finderRect, detectionResult, previewFrame.frameOrientation, previewFrame.width, previewFrame.height);
        }
        DisabilityCertificateRecognizerResultInfo dcRecognitionResult = null;
        if (!workflowStep.getWantsCapturedPage() || detectionResult == DetectionResult.OK || detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO) {
            dcRecognitionResult = this.dcScanner.recognizeDC(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation);
        }
        List list = this.contourDetector.getPolygonF();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"contourDetector.polygonF");
        int n = previewFrame.frameOrientation;
        int n2 = previewFrame.width;
        int n3 = previewFrame.height;
        double d = this.contourDetector.getDetectionScore();
        Rect rect = previewFrame.finderRect;
        RectF rectF = previewFrame.visibleRect;
        List list2 = this.requiredPageAspectRatios;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        DetectedFrameData detectedFrame = new DetectedFrameData(detectionResult, list, n, n2, n3, d, rect, rectF, list2, null, null, dcRecognitionResult, workflowStep);
        return this.notifyHandlers(detectedFrame);
    }

    private final DetectionResult detectOffCenter(Rect finderRect, DetectionResult detectionResult, int frameOrientation, int width, int height) {
        DetectionResult newDetectionResult = detectionResult;
        List polygon = this.contourDetector.getPolygonF();
        if (finderRect != null && !finderRect.isEmpty() && (newDetectionResult == DetectionResult.OK || newDetectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO || !polygon.isEmpty() && newDetectionResult == DetectionResult.ERROR_NOTHING_DETECTED)) {
            List list = polygon;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"polygon");
            List rotatedPolygon = PolygonHelper.Companion.rotatePolygon(list, (float)frameOrientation);
            int frameWidth = frameOrientation % 180 == 0 ? width : height;
            int frameHeight = frameOrientation % 180 == 0 ? height : width;
            Rect polygonRect = new Rect((int)(((PointF)rotatedPolygon.get((int)0)).x * (float)frameWidth), (int)(((PointF)rotatedPolygon.get((int)0)).y * (float)frameHeight), (int)(((PointF)rotatedPolygon.get((int)2)).x * (float)frameWidth), (int)(((PointF)rotatedPolygon.get((int)2)).y * (float)frameHeight));
            if (!finderRect.contains(polygonRect)) {
                newDetectionResult = DetectionResult.OK_OFF_CENTER;
            }
        }
        return newDetectionResult;
    }

    private final RectF fixRectOfInterest(int frameOrientation, RectF visibleRect) {
        RectF rectF = visibleRect;
        if (rectF != null) {
            RectF rectF2;
            RectF it = rectF2 = rectF;
            RectF visibleRectCopy = new RectF(it.left, it.top, it.right, it.bottom);
            Matrix matrix = new Matrix();
            matrix.setRotate((float)frameOrientation, 0.5f, 0.5f);
            matrix.mapRect(visibleRectCopy);
            return visibleRectCopy;
        }
        return null;
    }

    private final List<PageAspectRatio> fixRequiredAspectRatios(int frameOrientation, List<? extends PageAspectRatio> requiredPageAspectRatios) {
        List<? extends PageAspectRatio> list;
        List<? extends PageAspectRatio> it;
        List<? extends PageAspectRatio> list2 = requiredPageAspectRatios;
        if (list2 != null && !(it = (list = list2)).isEmpty()) {
            ArrayList<PageAspectRatio> fixedAspectRatios = new ArrayList<PageAspectRatio>();
            for (PageAspectRatio pageAspectRatio : it) {
                boolean frameNotRotated = frameOrientation % 180 == 0;
                PageAspectRatio fixedAspectRatio = frameNotRotated ? new PageAspectRatio(pageAspectRatio.width, pageAspectRatio.height) : new PageAspectRatio(pageAspectRatio.height, pageAspectRatio.width);
                fixedAspectRatios.add(fixedAspectRatio);
            }
            return fixedAspectRatios;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            boolean bl = this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            boolean bl = this.handlers.remove(handler);
        }
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        if (acceptedAngleScore < 0.0 || acceptedAngleScore > (double)100) {
            throw (Throwable)new IllegalArgumentException("Invalid acceptedAngleScore value.");
        }
        this.contourDetector.setAcceptedAngleScore(acceptedAngleScore);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        if (acceptedSizeScore < 0.0 || acceptedSizeScore > (double)100) {
            throw (Throwable)new IllegalArgumentException("Invalid acceptedSizeScore value.");
        }
        this.contourDetector.setAcceptedSizeScore(acceptedSizeScore);
    }

    public final void setRequiredAspectRatios(@NotNull List<? extends PageAspectRatio> requiredAspectRatios) {
        Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
        this.requiredPageAspectRatios = requiredAspectRatios;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean notifyHandlers(@NotNull DetectedFrameData detectedFrameData) {
        Intrinsics.checkParameterIsNotNull((Object)detectedFrameData, (String)"detectedFrameData");
        boolean handled = false;
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            for (ResultHandler handler : this.handlers) {
                handled |= handler.handleResult(detectedFrameData);
            }
            Unit unit = Unit.INSTANCE;
        }
        return handled;
    }

    public WorkflowFrameHandler(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.scanbotSDK = new ScanbotSDK(context);
        this.contourDetector = new ContourDetector();
        this.handlers = new LinkedHashSet();
        this.logger = LoggerProvider.getLogger();
        this.isEnabled = true;
        this.mrzScanner = this.scanbotSDK.mrzScanner();
        this.barcodeDetector = this.scanbotSDK.barcodeDetector();
        this.dcScanner = this.scanbotSDK.dcScanner();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$ResultHandler;", "", "handleResult", "", "detectedFrameData", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "scanbot-sdk-ui_release"})
    public static interface ResultHandler {
        public boolean handleResult(@NotNull DetectedFrameData var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 32\u00020\u0001:\u00013Bg\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015B\u0085\u0001\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u001cB\u0017\b\u0016\u0012\u0006\u0010\u001d\u001a\u00020\b\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u001d\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010$R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010$R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010+R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u00064"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "", "detectionResult", "Lnet/doo/snap/lib/detector/DetectionResult;", "polygon", "", "Landroid/graphics/PointF;", "frameOrientation", "", "frameWidth", "frameHeight", "detectionScore", "", "finderRect", "Landroid/graphics/Rect;", "rectOfInterest", "Landroid/graphics/RectF;", "requiredAspectRatios", "Lnet/doo/snap/lib/detector/PageAspectRatio;", "workflowStep", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "(Lnet/doo/snap/lib/detector/DetectionResult;Ljava/util/List;IIIDLandroid/graphics/Rect;Landroid/graphics/RectF;Ljava/util/List;Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;)V", "mrzRecognitionResult", "Lio/scanbot/mrzscanner/model/MRZRecognitionResult;", "detectedBarcode", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "dcRecognitionResult", "Lio/scanbot/dcscanner/model/DisabilityCertificateRecognizerResultInfo;", "(Lnet/doo/snap/lib/detector/DetectionResult;Ljava/util/List;IIIDLandroid/graphics/Rect;Landroid/graphics/RectF;Ljava/util/List;Lio/scanbot/mrzscanner/model/MRZRecognitionResult;Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;Lio/scanbot/dcscanner/model/DisabilityCertificateRecognizerResultInfo;Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;)V", "errorCode", "(ILio/scanbot/sdk/ui/entity/workflow/WorkflowStep;)V", "getDetectionResult", "()Lnet/doo/snap/lib/detector/DetectionResult;", "getDetectionScore", "()D", "getErrorCode", "()I", "getFinderRect", "()Landroid/graphics/Rect;", "getFrameHeight", "getFrameOrientation", "getFrameWidth", "getPolygon", "()Ljava/util/List;", "getRectOfInterest", "()Landroid/graphics/RectF;", "getRequiredAspectRatios", "workflowStepResult", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "getWorkflowStepResult", "()Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "Companion", "scanbot-sdk-ui_release"})
    public static final class DetectedFrameData {
        @NotNull
        private final DetectionResult detectionResult;
        @NotNull
        private final List<PointF> polygon;
        private final int frameOrientation;
        private final int frameWidth;
        private final int frameHeight;
        private final double detectionScore;
        private final int errorCode;
        @Nullable
        private final Rect finderRect;
        @Nullable
        private final RectF rectOfInterest;
        @NotNull
        private final List<PageAspectRatio> requiredAspectRatios;
        @NotNull
        private final WorkflowStepResult workflowStepResult;
        private static final int NO_ERROR = -1;
        private static final int ERROR_LICENSE_INVALID = 1;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final DetectionResult getDetectionResult() {
            return this.detectionResult;
        }

        @NotNull
        public final List<PointF> getPolygon() {
            return this.polygon;
        }

        public final int getFrameOrientation() {
            return this.frameOrientation;
        }

        public final int getFrameWidth() {
            return this.frameWidth;
        }

        public final int getFrameHeight() {
            return this.frameHeight;
        }

        public final double getDetectionScore() {
            return this.detectionScore;
        }

        public final int getErrorCode() {
            return this.errorCode;
        }

        @Nullable
        public final Rect getFinderRect() {
            return this.finderRect;
        }

        @Nullable
        public final RectF getRectOfInterest() {
            return this.rectOfInterest;
        }

        @NotNull
        public final List<PageAspectRatio> getRequiredAspectRatios() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final WorkflowStepResult getWorkflowStepResult() {
            return this.workflowStepResult;
        }

        public DetectedFrameData(@NotNull DetectionResult detectionResult, @NotNull List<? extends PointF> polygon, int frameOrientation, int frameWidth, int frameHeight, double detectionScore, @Nullable Rect finderRect, @Nullable RectF rectOfInterest, @NotNull List<? extends PageAspectRatio> requiredAspectRatios, @NotNull WorkflowStep workflowStep) {
            Intrinsics.checkParameterIsNotNull((Object)detectionResult, (String)"detectionResult");
            Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
            Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
            Intrinsics.checkParameterIsNotNull((Object)workflowStep, (String)"workflowStep");
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            List<? extends PointF> list = Collections.unmodifiableList(polygon);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(polygon)");
            this.polygon = list;
            this.detectionScore = detectionScore;
            this.errorCode = NO_ERROR;
            this.finderRect = finderRect;
            this.rectOfInterest = rectOfInterest;
            this.requiredAspectRatios = requiredAspectRatios;
            this.workflowStepResult = new WorkflowStepResult(workflowStep, null, null, null, null);
        }

        public DetectedFrameData(@NotNull DetectionResult detectionResult, @NotNull List<? extends PointF> polygon, int frameOrientation, int frameWidth, int frameHeight, double detectionScore, @Nullable Rect finderRect, @Nullable RectF rectOfInterest, @NotNull List<? extends PageAspectRatio> requiredAspectRatios, @Nullable MRZRecognitionResult mrzRecognitionResult, @Nullable BarcodeScanningResult detectedBarcode, @Nullable DisabilityCertificateRecognizerResultInfo dcRecognitionResult, @NotNull WorkflowStep workflowStep) {
            Intrinsics.checkParameterIsNotNull((Object)detectionResult, (String)"detectionResult");
            Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
            Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
            Intrinsics.checkParameterIsNotNull((Object)workflowStep, (String)"workflowStep");
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            List<? extends PointF> list = Collections.unmodifiableList(polygon);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(polygon)");
            this.polygon = list;
            this.detectionScore = detectionScore;
            this.errorCode = NO_ERROR;
            this.finderRect = finderRect;
            this.rectOfInterest = rectOfInterest;
            this.requiredAspectRatios = requiredAspectRatios;
            this.workflowStepResult = new WorkflowStepResult(workflowStep, null, mrzRecognitionResult, detectedBarcode, dcRecognitionResult);
        }

        public DetectedFrameData(int errorCode, @NotNull WorkflowStep workflowStep) {
            Intrinsics.checkParameterIsNotNull((Object)workflowStep, (String)"workflowStep");
            this.detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
            this.frameOrientation = 0;
            this.frameWidth = 0;
            this.frameHeight = 0;
            this.polygon = CollectionsKt.emptyList();
            this.detectionScore = 0.0;
            this.errorCode = errorCode;
            this.finderRect = null;
            this.rectOfInterest = null;
            this.requiredAspectRatios = CollectionsKt.emptyList();
            this.workflowStepResult = new WorkflowStepResult(workflowStep, null, null, null, null);
        }

        static {
            NO_ERROR = -1;
            ERROR_LICENSE_INVALID = 1;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData$Companion;", "", "()V", "ERROR_LICENSE_INVALID", "", "getERROR_LICENSE_INVALID", "()I", "NO_ERROR", "getNO_ERROR", "scanbot-sdk-ui_release"})
        public static final class Companion {
            public final int getNO_ERROR() {
                return NO_ERROR;
            }

            public final int getERROR_LICENSE_INVALID() {
                return ERROR_LICENSE_INVALID;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$Companion;", "", "()V", "attach", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler;", "cameraView", "Lnet/doo/snap/camera/ScanbotCameraView;", "scanbot-sdk-ui_release"})
    public static final class Companion {
        @NotNull
        public final WorkflowFrameHandler attach(@NotNull ScanbotCameraView cameraView) {
            Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
            Context context = cameraView.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"cameraView.context");
            WorkflowFrameHandler frameHandler = new WorkflowFrameHandler(context);
            cameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)frameHandler);
            return frameHandler;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

