/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.utils.navigator;

import android.app.Activity;
import fj.F;
import fj.data.List;
import io.scanbot.sdk.ui.utils.navigator.ActivityBindingNavigator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;

public class NodeNavigator<A extends Activity>
extends ActivityBindingNavigator {
    private final List<NavigationNode<A>> nodes;
    private final Queue<Object> history = Collections.asLifoQueue(new LinkedList());

    public NodeNavigator(List<NavigationNode<A>> nodes) {
        this.nodes = nodes;
    }

    public boolean navigateBack() {
        if (!this.history.isEmpty()) {
            Object topEvent = this.history.poll();
            NavigationNode<A> topNode = this.nodeForEvent(topEvent);
            if (topNode.interceptBackNavigation(this.getActivity())) {
                this.history.add(topEvent);
                return true;
            }
            topNode.navigateFrom(this.getActivity(), topEvent);
            if (!this.history.isEmpty()) {
                Object nextTopEvent = this.history.peek();
                this.nodeForEvent(nextTopEvent).navigateTo(this.getActivity(), nextTopEvent);
            } else {
                this.getActivity().finish();
            }
            return true;
        }
        return false;
    }

    @Override
    public void navigate(Activity activity, Object event) {
        if (event.equals(this.history.peek())) {
            return;
        }
        if (activity == null) {
            this.history.add(event);
            return;
        }
        NavigationNode<A> newNode = this.nodeForEvent(event);
        if (newNode.isActionNode()) {
            newNode.navigateTo(this.getActivity(), event);
        } else if (this.history.contains(event)) {
            this.navigateToNodeInHistory(event);
        } else {
            this.navigateToNewNode(event, newNode);
        }
    }

    private void navigateToNewNode(Object event, NavigationNode<A> newNode) {
        this.navigateFromTopNode();
        newNode.navigateTo(this.getActivity(), event);
        this.history.add(event);
    }

    private void navigateToNodeInHistory(Object event) {
        while (!event.equals(this.history.peek())) {
            Object topEvent = this.history.poll();
            this.nodeForEvent(topEvent).navigateFrom(this.getActivity(), topEvent);
        }
        this.nodeForEvent(event).navigateTo(this.getActivity(), event);
    }

    @Override
    public void bind(Activity activity) {
        super.bind(activity);
        this.navigateToTopNode();
    }

    @Override
    public void unbind() {
        if (this.getActivity() == null) {
            return;
        }
        this.navigateFromTopNode();
        super.unbind();
    }

    protected A getActivity() {
        return (A)super.getActivity();
    }

    private void navigateToTopNode() {
        if (!this.history.isEmpty()) {
            Object topEvent = this.history.peek();
            this.nodeForEvent(topEvent).navigateTo(this.getActivity(), topEvent);
        }
    }

    private void navigateFromTopNode() {
        if (!this.history.isEmpty()) {
            Object topEvent = this.history.peek();
            this.nodeForEvent(topEvent).navigateFrom(this.getActivity(), topEvent);
        }
    }

    private NavigationNode<A> nodeForEvent(final Object event) {
        return (NavigationNode)this.nodes.find(new F<NavigationNode<A>, Boolean>(){

            public Boolean f(NavigationNode<A> node) {
                return node.canHandleNavigationEvent(event);
            }
        }).valueE("No node for event: " + event);
    }

    public static interface NavigationNode<A extends Activity> {
        public void navigateTo(A var1, Object var2);

        public void navigateFrom(A var1, Object var2);

        public boolean interceptBackNavigation(A var1);

        public boolean isActionNode();

        public boolean canHandleNavigationEvent(Object var1);
    }
}

