/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.workflow.camera;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.core.contourdetector.PageAspectRatio;
import io.scanbot.sdk.injection.SdkComponent;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.entity.workflow.ContourDetectorWorkflowStepResult;
import io.scanbot.sdk.ui.entity.workflow.PayFormWorkflowStepResult;
import io.scanbot.sdk.ui.entity.workflow.ScanBarCodeWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanDisabilityCertificateWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanMachineReadableZoneWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanPayFormWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.WorkflowScannersFactory;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStepResult;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0003,-.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0016H\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010%\u001a\u00020\t2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H\u0004J\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006/"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "handlers", "Ljava/util/LinkedHashSet;", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$ResultHandler;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "scanbotSDK", "Lio/scanbot/sdk/ScanbotSDK;", "getScanbotSDK", "()Lio/scanbot/sdk/ScanbotSDK;", "workflowScannersFactory", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowScannersFactory;", "workflowStep", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "getWorkflowStep", "()Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "setWorkflowStep", "(Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;)V", "addResultHandler", "", "handler", "detect", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "getFeatureByWorkflowStep", "Lio/scanbot/sap/SdkFeature;", "step", "handleFrame", "notifyHandlers", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "Lio/scanbot/sdk/SdkLicenseError;", "removeResultHandler", "setWorkflowScannersFactory", "Companion", "DetectedFrameData", "ResultHandler", "rtu-ui-bundle_release"})
public class WorkflowFrameHandler
implements FrameHandler {
    @NotNull
    private final ScanbotSDK scanbotSDK;
    private final LinkedHashSet<ResultHandler> handlers;
    private final Logger logger;
    private boolean isEnabled;
    @NotNull
    public WorkflowStep workflowStep;
    private WorkflowScannersFactory workflowScannersFactory;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final ScanbotSDK getScanbotSDK() {
        return this.scanbotSDK;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @NotNull
    public final WorkflowStep getWorkflowStep() {
        WorkflowStep workflowStep = this.workflowStep;
        if (workflowStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"workflowStep");
        }
        return workflowStep;
    }

    public final void setWorkflowStep(@NotNull WorkflowStep workflowStep) {
        Intrinsics.checkParameterIsNotNull((Object)workflowStep, (String)"<set-?>");
        this.workflowStep = workflowStep;
    }

    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        Intrinsics.checkParameterIsNotNull((Object)previewFrame, (String)"previewFrame");
        this.logger.logMethod();
        if (!this.isEnabled) {
            return false;
        }
        SdkComponent sdkComponent = this.scanbotSDK.getSdkComponent();
        if (sdkComponent == null) {
            Intrinsics.throwNpe();
        }
        SapManager sapManager = sdkComponent.sapManager();
        WorkflowStep workflowStep = this.workflowStep;
        if (workflowStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"workflowStep");
        }
        if (!sapManager.checkLicenseStatus(this.getFeatureByWorkflowStep(workflowStep)).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<DetectedFrameData, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Failure((Object)new SdkLicenseError())));
            return false;
        }
        WorkflowStep workflowStep2 = this.workflowStep;
        if (workflowStep2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"workflowStep");
        }
        if (workflowStep2 != null) {
            WorkflowStep workflowStep3 = workflowStep2;
            boolean bl = false;
            boolean bl2 = false;
            WorkflowStep it = workflowStep3;
            boolean bl3 = false;
            return this.detect(it, previewFrame);
        }
        return false;
    }

    private final SdkFeature getFeatureByWorkflowStep(WorkflowStep step) {
        WorkflowStep workflowStep = step;
        return workflowStep instanceof ScanMachineReadableZoneWorkflowStep ? SdkFeature.MRZRecognition : (workflowStep instanceof ScanBarCodeWorkflowStep ? SdkFeature.Barcode : (workflowStep instanceof ScanDisabilityCertificateWorkflowStep ? SdkFeature.DisabilityCertRecognition : (workflowStep instanceof ScanPayFormWorkflowStep ? SdkFeature.PayformDetection : SdkFeature.NoSdkFeature)));
    }

    private final boolean detect(WorkflowStep workflowStep, FrameHandler.Frame previewFrame) {
        DetectionResult detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
        List polygon = CollectionsKt.emptyList();
        double detectionScore = 0.0;
        try {
            WorkflowStepResult workflowStepResult;
            WorkflowScannersFactory workflowScannersFactory = this.workflowScannersFactory;
            if (workflowScannersFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowScannersFactory");
            }
            WorkflowStepResult workflowStepResult2 = workflowStepResult = workflowScannersFactory.scannerForStep(workflowStep).scanOnCameraFrame(previewFrame);
            if (workflowStepResult2 != null) {
                WorkflowStepResult workflowStepResult3 = workflowStepResult2;
                boolean bl = false;
                boolean bl2 = false;
                WorkflowStepResult it = workflowStepResult3;
                boolean bl3 = false;
                if (it instanceof PayFormWorkflowStepResult) {
                    List list = ((PayFormWorkflowStepResult)it).getPolygon();
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    polygon = list;
                } else if (it instanceof ContourDetectorWorkflowStepResult) {
                    detectionResult = ((ContourDetectorWorkflowStepResult)it).getDetectionResult();
                    List list = ((ContourDetectorWorkflowStepResult)it).getPolygon();
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    polygon = list;
                    detectionScore = ((ContourDetectorWorkflowStepResult)it).getDetectionScore();
                }
            }
            byte[] byArray = workflowStep.getWantsVideoFramePage() ? previewFrame.frame : new byte[]{};
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"if (workflowStep.wantsVi\u2026e.frame else ByteArray(0)");
            DetectedFrameData detectedFrame = new DetectedFrameData(detectionResult, polygon, byArray, previewFrame.frameOrientation, previewFrame.width, previewFrame.height, detectionScore, previewFrame.finderRect, previewFrame.visibleRect, workflowStep.getRequiredAspectRatios(), workflowStepResult);
            return this.notifyHandlers((FrameHandlerResult<DetectedFrameData, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Success((Object)detectedFrame)));
        }
        catch (IOException e) {
            LoggerProvider.getLogger().logException((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashSet) {
            boolean bl3 = false;
            bl2 = this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashSet) {
            boolean bl3 = false;
            bl2 = this.handlers.remove(handler);
        }
    }

    public final void setWorkflowScannersFactory(@NotNull WorkflowScannersFactory workflowScannersFactory) {
        Intrinsics.checkParameterIsNotNull((Object)workflowScannersFactory, (String)"workflowScannersFactory");
        this.workflowScannersFactory = workflowScannersFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean notifyHandlers(@NotNull FrameHandlerResult<DetectedFrameData, SdkLicenseError> result) {
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        boolean handled = false;
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashSet) {
            boolean bl3 = false;
            for (ResultHandler handler : this.handlers) {
                handled |= handler.handle(result);
            }
            Unit unit = Unit.INSTANCE;
        }
        return handled;
    }

    public WorkflowFrameHandler(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.scanbotSDK = new ScanbotSDK(context);
        this.handlers = new LinkedHashSet();
        this.logger = LoggerProvider.getLogger();
        this.isEnabled = true;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "Lio/scanbot/sdk/SdkLicenseError;", "rtu-ui-bundle_release"})
    public static interface ResultHandler
    extends BaseResultHandler<DetectedFrameData, SdkLicenseError> {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "", "detectionResult", "Lio/scanbot/sdk/core/contourdetector/DetectionResult;", "polygon", "", "Landroid/graphics/PointF;", "frame", "", "frameOrientation", "", "frameWidth", "frameHeight", "detectionScore", "", "finderRect", "Landroid/graphics/Rect;", "rectOfInterest", "Landroid/graphics/RectF;", "requiredAspectRatios", "Lio/scanbot/sdk/core/contourdetector/PageAspectRatio;", "workflowStepResult", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "(Lio/scanbot/sdk/core/contourdetector/DetectionResult;Ljava/util/List;[BIIIDLandroid/graphics/Rect;Landroid/graphics/RectF;Ljava/util/List;Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;)V", "getDetectionResult", "()Lio/scanbot/sdk/core/contourdetector/DetectionResult;", "getDetectionScore", "()D", "getFinderRect", "()Landroid/graphics/Rect;", "getFrame", "()[B", "getFrameHeight", "()I", "getFrameOrientation", "getFrameWidth", "getPolygon", "()Ljava/util/List;", "getRectOfInterest", "()Landroid/graphics/RectF;", "getRequiredAspectRatios", "getWorkflowStepResult", "()Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "rtu-ui-bundle_release"})
    public static final class DetectedFrameData {
        @NotNull
        private final DetectionResult detectionResult;
        @NotNull
        private final List<PointF> polygon;
        @NotNull
        private final byte[] frame;
        private final int frameOrientation;
        private final int frameWidth;
        private final int frameHeight;
        private final double detectionScore;
        @Nullable
        private final Rect finderRect;
        @Nullable
        private final RectF rectOfInterest;
        @NotNull
        private final List<PageAspectRatio> requiredAspectRatios;
        @Nullable
        private final WorkflowStepResult workflowStepResult;

        @NotNull
        public final DetectionResult getDetectionResult() {
            return this.detectionResult;
        }

        @NotNull
        public final List<PointF> getPolygon() {
            return this.polygon;
        }

        @NotNull
        public final byte[] getFrame() {
            return this.frame;
        }

        public final int getFrameOrientation() {
            return this.frameOrientation;
        }

        public final int getFrameWidth() {
            return this.frameWidth;
        }

        public final int getFrameHeight() {
            return this.frameHeight;
        }

        public final double getDetectionScore() {
            return this.detectionScore;
        }

        @Nullable
        public final Rect getFinderRect() {
            return this.finderRect;
        }

        @Nullable
        public final RectF getRectOfInterest() {
            return this.rectOfInterest;
        }

        @NotNull
        public final List<PageAspectRatio> getRequiredAspectRatios() {
            return this.requiredAspectRatios;
        }

        @Nullable
        public final WorkflowStepResult getWorkflowStepResult() {
            return this.workflowStepResult;
        }

        public DetectedFrameData(@NotNull DetectionResult detectionResult, @NotNull List<? extends PointF> polygon, @NotNull byte[] frame, int frameOrientation, int frameWidth, int frameHeight, double detectionScore, @Nullable Rect finderRect, @Nullable RectF rectOfInterest, @NotNull List<PageAspectRatio> requiredAspectRatios, @Nullable WorkflowStepResult workflowStepResult) {
            Intrinsics.checkParameterIsNotNull((Object)detectionResult, (String)"detectionResult");
            Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
            this.detectionResult = detectionResult;
            this.polygon = polygon;
            this.frame = frame;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.detectionScore = detectionScore;
            this.finderRect = finderRect;
            this.rectOfInterest = rectOfInterest;
            this.requiredAspectRatios = requiredAspectRatios;
            this.workflowStepResult = workflowStepResult;
        }

        public /* synthetic */ DetectedFrameData(DetectionResult detectionResult, List list, byte[] byArray, int n, int n2, int n3, double d, Rect rect, RectF rectF, List list2, WorkflowStepResult workflowStepResult, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
            }
            if ((n4 & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n4 & 4) != 0) {
                byArray = new byte[]{};
            }
            if ((n4 & 8) != 0) {
                n = 0;
            }
            if ((n4 & 0x10) != 0) {
                n2 = 0;
            }
            if ((n4 & 0x20) != 0) {
                n3 = 0;
            }
            if ((n4 & 0x40) != 0) {
                d = 0.0;
            }
            if ((n4 & 0x80) != 0) {
                rect = null;
            }
            if ((n4 & 0x100) != 0) {
                rectF = null;
            }
            if ((n4 & 0x200) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(detectionResult, list, byArray, n, n2, n3, d, rect, rectF, list2, workflowStepResult);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$Companion;", "", "()V", "attach", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "rtu-ui-bundle_release"})
    public static final class Companion {
        @NotNull
        public final WorkflowFrameHandler attach(@NotNull IScanbotCameraView cameraView) {
            Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
            Context context = ((View)cameraView).getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"(cameraView as View).context");
            WorkflowFrameHandler frameHandler = new WorkflowFrameHandler(context);
            cameraView.addFrameHandler((FrameHandler)frameHandler);
            return frameHandler;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

