/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.sdk.barcode.entity.FormattedBarcodeDataMapper;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.ui.di.components.BatchBarcodeCameraComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.BatchBarcodeModule;
import io.scanbot.sdk.ui.di.modules.BatchBarcodeModule_ProvideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.BatchBarcodeModule_ProvideLastScannedBarcodeHolder$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraPresenter;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.barcode.LastScannedBarcodeHolder;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeListPresenter;
import io.scanbot.sdk.ui.view.barcode.batch.InternalBatchBarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.batch.InternalBatchBarcodeCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodePreviewFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodeTakenPictureUseCase;
import javax.inject.Provider;

public final class DaggerBatchBarcodeCameraComponent
implements BatchBarcodeCameraComponent {
    private SDKUIComponent sDKUIComponent;
    private Provider<LastScannedBarcodeHolder> provideLastScannedBarcodeHolder$rtu_ui_bundle_releaseProvider;
    private Provider<Navigator> providesNavigatorProvider;
    private Provider<FormattedBarcodeDataMapper> provideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseProvider;

    private DaggerBatchBarcodeCameraComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private SaveBarcodeTakenPictureUseCase getSaveBarcodeTakenPictureUseCase() {
        return new SaveBarcodeTakenPictureUseCase((BarcodeFileStorage)Preconditions.checkNotNull((Object)this.sDKUIComponent.barcodeFileStorage(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private SaveBarcodePreviewFrameUseCase getSaveBarcodePreviewFrameUseCase() {
        return new SaveBarcodePreviewFrameUseCase((BarcodeFileStorage)Preconditions.checkNotNull((Object)this.sDKUIComponent.barcodeFileStorage(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private BarcodeCameraPresenter getBarcodeCameraPresenter() {
        return new BarcodeCameraPresenter(this.getCheckCameraPermissionUseCase(), this.getSaveBarcodeTakenPictureUseCase(), this.getSaveBarcodePreviewFrameUseCase(), (LastScannedBarcodeHolder)this.provideLastScannedBarcodeHolder$rtu_ui_bundle_releaseProvider.get(), (Navigator)this.providesNavigatorProvider.get());
    }

    private BatchBarcodeListPresenter getBatchBarcodeListPresenter() {
        return new BatchBarcodeListPresenter((Navigator)this.providesNavigatorProvider.get(), (FormattedBarcodeDataMapper)this.provideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseProvider.get(), (LastScannedBarcodeHolder)this.provideLastScannedBarcodeHolder$rtu_ui_bundle_releaseProvider.get(), (Scheduler)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideBackgroundTaskScheduler(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private void initialize(Builder builder) {
        this.sDKUIComponent = builder.sDKUIComponent;
        this.provideLastScannedBarcodeHolder$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)BatchBarcodeModule_ProvideLastScannedBarcodeHolder$rtu_ui_bundle_releaseFactory.create(builder.batchBarcodeModule));
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)builder.navigatorModule));
        this.provideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)BatchBarcodeModule_ProvideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseFactory.create(builder.batchBarcodeModule));
    }

    @Override
    public void inject(BatchBarcodeCameraFragment batchBarcodeCameraFragment) {
        this.injectBatchBarcodeCameraFragment(batchBarcodeCameraFragment);
    }

    private BatchBarcodeCameraFragment injectBatchBarcodeCameraFragment(BatchBarcodeCameraFragment instance) {
        BaseBarcodeCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseBarcodeCameraFragment)instance, (CheckCameraPermissionUseCase)this.getCheckCameraPermissionUseCase());
        BaseBarcodeCameraFragment_MembersInjector.injectBarcodeCameraPresenter((BaseBarcodeCameraFragment)instance, (BarcodeCameraPresenter)this.getBarcodeCameraPresenter());
        InternalBatchBarcodeCameraFragment_MembersInjector.injectBatchBarcodeListPresenter((InternalBatchBarcodeCameraFragment)instance, (BatchBarcodeListPresenter)this.getBatchBarcodeListPresenter());
        return instance;
    }

    public static final class Builder {
        private BatchBarcodeModule batchBarcodeModule;
        private NavigatorModule navigatorModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public BatchBarcodeCameraComponent build() {
            if (this.batchBarcodeModule == null) {
                throw new IllegalStateException(BatchBarcodeModule.class.getCanonicalName() + " must be set");
            }
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.sDKUIComponent == null) {
                throw new IllegalStateException(SDKUIComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerBatchBarcodeCameraComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder batchBarcodeModule(BatchBarcodeModule batchBarcodeModule) {
            this.batchBarcodeModule = (BatchBarcodeModule)Preconditions.checkNotNull((Object)batchBarcodeModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }
    }
}

