/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.multipleobjectsscanner.MultipleObjectsDetector;
import io.scanbot.sdk.docprocessing.PageProcessor;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.ui.di.components.MultipleObjectsDetectorComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.DetectSaveMultipleObjectsUseCase;
import io.scanbot.sdk.ui.view.multiple_objects.BaseMultipleObjectsDetectorFragment;
import io.scanbot.sdk.ui.view.multiple_objects.BaseMultipleObjectsDetectorFragment_MembersInjector;
import io.scanbot.sdk.ui.view.multiple_objects.MultipleObjectsDetectorFragment;
import io.scanbot.sdk.ui.view.multiple_objects.MultipleObjectsDetectorPresenter;
import javax.inject.Provider;

public final class DaggerMultipleObjectsDetectorComponent
implements MultipleObjectsDetectorComponent {
    private SDKUIComponent sDKUIComponent;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerMultipleObjectsDetectorComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private DetectSaveMultipleObjectsUseCase getDetectSaveMultipleObjectsUseCase() {
        return new DetectSaveMultipleObjectsUseCase((PageProcessor)Preconditions.checkNotNull((Object)this.sDKUIComponent.pageProcessor(), (String)"Cannot return null from a non-@Nullable component method"), (PageFileStorage)Preconditions.checkNotNull((Object)this.sDKUIComponent.pageFileStorage(), (String)"Cannot return null from a non-@Nullable component method"), (ImageProcessor)Preconditions.checkNotNull((Object)this.sDKUIComponent.imageProcessor(), (String)"Cannot return null from a non-@Nullable component method"), (MultipleObjectsDetector)Preconditions.checkNotNull((Object)this.sDKUIComponent.multipleObjectsDetector(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private MultipleObjectsDetectorPresenter getMultipleObjectsDetectorPresenter() {
        return new MultipleObjectsDetectorPresenter(this.getCheckCameraPermissionUseCase(), this.getDetectSaveMultipleObjectsUseCase(), (Navigator)this.providesNavigatorProvider.get(), (Scheduler)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideBackgroundTaskScheduler(), (String)"Cannot return null from a non-@Nullable component method"), (Scheduler)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideUiScheduler(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private void initialize(Builder builder) {
        this.sDKUIComponent = builder.sDKUIComponent;
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)builder.navigatorModule));
    }

    @Override
    public void inject(MultipleObjectsDetectorFragment fragment) {
        this.injectMultipleObjectsDetectorFragment(fragment);
    }

    private MultipleObjectsDetectorFragment injectMultipleObjectsDetectorFragment(MultipleObjectsDetectorFragment instance) {
        BaseMultipleObjectsDetectorFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseMultipleObjectsDetectorFragment)instance, (CheckCameraPermissionUseCase)this.getCheckCameraPermissionUseCase());
        BaseMultipleObjectsDetectorFragment_MembersInjector.injectPresenter((BaseMultipleObjectsDetectorFragment)instance, (MultipleObjectsDetectorPresenter)this.getMultipleObjectsDetectorPresenter());
        BaseMultipleObjectsDetectorFragment_MembersInjector.injectMultipleObjectsDetector((BaseMultipleObjectsDetectorFragment)instance, (MultipleObjectsDetector)((MultipleObjectsDetector)Preconditions.checkNotNull((Object)this.sDKUIComponent.multipleObjectsDetector(), (String)"Cannot return null from a non-@Nullable component method")));
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public MultipleObjectsDetectorComponent build() {
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.sDKUIComponent == null) {
                throw new IllegalStateException(SDKUIComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerMultipleObjectsDetectorComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }
    }
}

