/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.scanbot.sdk.generictext.GenericTextRecognizer;
import io.scanbot.sdk.ui.di.components.GenericDataCameraComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.generictext.BaseGenericDataCameraFragment;
import io.scanbot.sdk.ui.view.generictext.BaseGenericDataCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.generictext.GenericDataPresenter;
import io.scanbot.sdk.ui.view.generictext.GenericDataScannerCameraFragment;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import javax.inject.Provider;

public final class DaggerGenericDataCameraComponent
implements GenericDataCameraComponent {
    private SDKUIComponent sDKUIComponent;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerGenericDataCameraComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private GenericDataPresenter getGenericDataPresenter() {
        return new GenericDataPresenter(this.getCheckCameraPermissionUseCase(), (Navigator)this.providesNavigatorProvider.get());
    }

    private void initialize(Builder builder) {
        this.sDKUIComponent = builder.sDKUIComponent;
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)builder.navigatorModule));
    }

    @Override
    public void inject(GenericDataScannerCameraFragment fragment) {
        this.injectGenericDataScannerCameraFragment(fragment);
    }

    private GenericDataScannerCameraFragment injectGenericDataScannerCameraFragment(GenericDataScannerCameraFragment instance) {
        BaseGenericDataCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseGenericDataCameraFragment)instance, (CheckCameraPermissionUseCase)this.getCheckCameraPermissionUseCase());
        BaseGenericDataCameraFragment_MembersInjector.injectGenericTextRecognizer((BaseGenericDataCameraFragment)instance, (GenericTextRecognizer)((GenericTextRecognizer)Preconditions.checkNotNull((Object)this.sDKUIComponent.genericTextRecognizer(), (String)"Cannot return null from a non-@Nullable component method")));
        BaseGenericDataCameraFragment_MembersInjector.injectGenericDataPresenter((BaseGenericDataCameraFragment)instance, (GenericDataPresenter)this.getGenericDataPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public GenericDataCameraComponent build() {
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.sDKUIComponent == null) {
                throw new IllegalStateException(SDKUIComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerGenericDataCameraComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }
    }
}

