/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.sdk.mrzscanner.MRZScanner;
import io.scanbot.sdk.nfcscanner.passport.PassportNfcScanner;
import io.scanbot.sdk.nfcscanner.passport.PassportPhotoSaveCallback;
import io.scanbot.sdk.persistance.NfcPassportFileStorage;
import io.scanbot.sdk.ui.di.components.NfcPassportComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.MrzModule;
import io.scanbot.sdk.ui.di.modules.MrzModule_ProvideMrzScanningSession$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.di.modules.NfcPassportModule;
import io.scanbot.sdk.ui.di.modules.NfcPassportModule_ProvidePassportPhotoSaveCallback$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.mrz.MRZCameraPresenter;
import io.scanbot.sdk.ui.view.mrz.MrzScanningSession;
import io.scanbot.sdk.ui.view.nfc.BaseNfcPassportFragment;
import io.scanbot.sdk.ui.view.nfc.BaseNfcPassportFragment_MembersInjector;
import io.scanbot.sdk.ui.view.nfc.NfcPassportPresenter;
import io.scanbot.sdk.ui.view.nfc.NfcPassportScannerFragment;
import io.scanbot.sdk.ui.view.nfc.interactor.CheckNfcStateUseCase;
import io.scanbot.sdk.ui.view.nfc.interactor.ProcessNfcTagUseCase;
import io.scanbot.sdk.ui.view.nfc.interactor.SaveNfcPassportImageUseCase;
import javax.inject.Provider;

public final class DaggerNfcPassportComponent
implements NfcPassportComponent {
    private SDKUIComponent sDKUIComponent;
    private Provider<Navigator> providesNavigatorProvider;
    private Provider<MrzScanningSession> provideMrzScanningSession$rtu_ui_bundle_releaseProvider;
    private Provider<PassportPhotoSaveCallback> providePassportPhotoSaveCallback$rtu_ui_bundle_releaseProvider;

    private DaggerNfcPassportComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private MRZCameraPresenter getMRZCameraPresenter() {
        return new MRZCameraPresenter(this.getCheckCameraPermissionUseCase(), (Navigator)this.providesNavigatorProvider.get(), (MrzScanningSession)this.provideMrzScanningSession$rtu_ui_bundle_releaseProvider.get());
    }

    private CheckNfcStateUseCase getCheckNfcStateUseCase() {
        return new CheckNfcStateUseCase((Context)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private ProcessNfcTagUseCase getProcessNfcTagUseCase() {
        return new ProcessNfcTagUseCase((PassportNfcScanner)Preconditions.checkNotNull((Object)this.sDKUIComponent.passportNfcScanner(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private SaveNfcPassportImageUseCase getSaveNfcPassportImageUseCase() {
        return new SaveNfcPassportImageUseCase((NfcPassportFileStorage)Preconditions.checkNotNull((Object)this.sDKUIComponent.nfcPassportFileStorage(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private NfcPassportPresenter getNfcPassportPresenter() {
        return new NfcPassportPresenter((Navigator)this.providesNavigatorProvider.get(), (Scheduler)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideBackgroundTaskScheduler(), (String)"Cannot return null from a non-@Nullable component method"), this.getCheckNfcStateUseCase(), this.getProcessNfcTagUseCase(), this.getSaveNfcPassportImageUseCase(), (PassportPhotoSaveCallback)this.providePassportPhotoSaveCallback$rtu_ui_bundle_releaseProvider.get(), (MrzScanningSession)this.provideMrzScanningSession$rtu_ui_bundle_releaseProvider.get());
    }

    private void initialize(Builder builder) {
        this.sDKUIComponent = builder.sDKUIComponent;
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)builder.navigatorModule));
        this.provideMrzScanningSession$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)MrzModule_ProvideMrzScanningSession$rtu_ui_bundle_releaseFactory.create(builder.mrzModule));
        this.providePassportPhotoSaveCallback$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)NfcPassportModule_ProvidePassportPhotoSaveCallback$rtu_ui_bundle_releaseFactory.create(builder.nfcPassportModule));
    }

    @Override
    public void inject(NfcPassportScannerFragment nfcPassportFragment) {
        this.injectNfcPassportScannerFragment(nfcPassportFragment);
    }

    private NfcPassportScannerFragment injectNfcPassportScannerFragment(NfcPassportScannerFragment instance) {
        BaseNfcPassportFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseNfcPassportFragment)instance, (CheckCameraPermissionUseCase)this.getCheckCameraPermissionUseCase());
        BaseNfcPassportFragment_MembersInjector.injectMrzCameraPresenter((BaseNfcPassportFragment)instance, (MRZCameraPresenter)this.getMRZCameraPresenter());
        BaseNfcPassportFragment_MembersInjector.injectNfcPassportPresenter((BaseNfcPassportFragment)instance, (NfcPassportPresenter)this.getNfcPassportPresenter());
        BaseNfcPassportFragment_MembersInjector.injectMrzScanner((BaseNfcPassportFragment)instance, (MRZScanner)((MRZScanner)Preconditions.checkNotNull((Object)this.sDKUIComponent.mrzScanner(), (String)"Cannot return null from a non-@Nullable component method")));
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private MrzModule mrzModule;
        private NfcPassportModule nfcPassportModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public NfcPassportComponent build() {
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.mrzModule == null) {
                throw new IllegalStateException(MrzModule.class.getCanonicalName() + " must be set");
            }
            if (this.nfcPassportModule == null) {
                throw new IllegalStateException(NfcPassportModule.class.getCanonicalName() + " must be set");
            }
            if (this.sDKUIComponent == null) {
                throw new IllegalStateException(SDKUIComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerNfcPassportComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder mrzModule(MrzModule mrzModule) {
            this.mrzModule = (MrzModule)Preconditions.checkNotNull((Object)mrzModule);
            return this;
        }

        public Builder nfcPassportModule(NfcPassportModule nfcPassportModule) {
            this.nfcPassportModule = (NfcPassportModule)Preconditions.checkNotNull((Object)nfcPassportModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }
    }
}

