/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.app.Application;
import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.sdk.persistence.DraftPagesRepository;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.components.WorkflowCameraComponent;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.di.modules.WorkflowModule;
import io.scanbot.sdk.ui.di.modules.WorkflowModule_ProvideWorkflowScannersFactory$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.entity.workflow.WorkflowScannersFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.FinalizePagesUseCase;
import io.scanbot.sdk.ui.view.interactor.RemoveDraftPageUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveCameraFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveTakenPictureUseCase;
import io.scanbot.sdk.ui.view.interactor.WorkflowDetectionUseCase;
import io.scanbot.sdk.ui.view.workflow.WorkflowCameraFragment;
import io.scanbot.sdk.ui.view.workflow.WorkflowCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.workflow.WorkflowCameraPresenter;
import javax.inject.Provider;

public final class DaggerWorkflowCameraComponent
implements WorkflowCameraComponent {
    private SDKUIComponent sDKUIComponent;
    private io_scanbot_sdk_ui_di_components_SDKUIComponent_provideApplication provideApplicationProvider;
    private Provider<WorkflowScannersFactory> provideWorkflowScannersFactory$rtu_ui_bundle_releaseProvider;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerWorkflowCameraComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private SaveTakenPictureUseCase getSaveTakenPictureUseCase() {
        return new SaveTakenPictureUseCase((DraftPagesRepository)Preconditions.checkNotNull((Object)this.sDKUIComponent.draftPagesRepository(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private SaveCameraFrameUseCase getSaveCameraFrameUseCase() {
        return new SaveCameraFrameUseCase((DraftPagesRepository)Preconditions.checkNotNull((Object)this.sDKUIComponent.draftPagesRepository(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private WorkflowDetectionUseCase getWorkflowDetectionUseCase() {
        return new WorkflowDetectionUseCase((WorkflowScannersFactory)this.provideWorkflowScannersFactory$rtu_ui_bundle_releaseProvider.get());
    }

    private RemoveDraftPageUseCase getRemoveDraftPageUseCase() {
        return new RemoveDraftPageUseCase((Cleaner)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideCleaner(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private FinalizePagesUseCase getFinalizePagesUseCase() {
        return new FinalizePagesUseCase((PageStorageProcessor)Preconditions.checkNotNull((Object)this.sDKUIComponent.pageStorageProcessor(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private WorkflowCameraPresenter getWorkflowCameraPresenter() {
        return new WorkflowCameraPresenter(this.getCheckCameraPermissionUseCase(), this.getSaveTakenPictureUseCase(), this.getSaveCameraFrameUseCase(), this.getWorkflowDetectionUseCase(), this.getRemoveDraftPageUseCase(), this.getFinalizePagesUseCase(), (Navigator)this.providesNavigatorProvider.get(), (Scheduler)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideBackgroundTaskScheduler(), (String)"Cannot return null from a non-@Nullable component method"), (Scheduler)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideUiScheduler(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private void initialize(Builder builder) {
        this.provideApplicationProvider = new io_scanbot_sdk_ui_di_components_SDKUIComponent_provideApplication(builder.sDKUIComponent);
        this.provideWorkflowScannersFactory$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)WorkflowModule_ProvideWorkflowScannersFactory$rtu_ui_bundle_releaseFactory.create(builder.workflowModule, this.provideApplicationProvider));
        this.sDKUIComponent = builder.sDKUIComponent;
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)builder.navigatorModule));
    }

    @Override
    public WorkflowScannersFactory provideWorkflowScannersFactory() {
        return (WorkflowScannersFactory)this.provideWorkflowScannersFactory$rtu_ui_bundle_releaseProvider.get();
    }

    @Override
    public void inject(WorkflowCameraFragment workflowCameraFragment) {
        this.injectWorkflowCameraFragment(workflowCameraFragment);
    }

    private WorkflowCameraFragment injectWorkflowCameraFragment(WorkflowCameraFragment instance) {
        WorkflowCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase(instance, this.getCheckCameraPermissionUseCase());
        WorkflowCameraFragment_MembersInjector.injectWorkflowCameraPresenter(instance, this.getWorkflowCameraPresenter());
        WorkflowCameraFragment_MembersInjector.injectWorkflowScannersFactory(instance, (WorkflowScannersFactory)this.provideWorkflowScannersFactory$rtu_ui_bundle_releaseProvider.get());
        return instance;
    }

    private static class io_scanbot_sdk_ui_di_components_SDKUIComponent_provideApplication
    implements Provider<Application> {
        private final SDKUIComponent sDKUIComponent;

        io_scanbot_sdk_ui_di_components_SDKUIComponent_provideApplication(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = sDKUIComponent;
        }

        public Application get() {
            return (Application)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideApplication(), (String)"Cannot return null from a non-@Nullable component method");
        }
    }

    public static final class Builder {
        private WorkflowModule workflowModule;
        private NavigatorModule navigatorModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public WorkflowCameraComponent build() {
            if (this.workflowModule == null) {
                throw new IllegalStateException(WorkflowModule.class.getCanonicalName() + " must be set");
            }
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.sDKUIComponent == null) {
                throw new IllegalStateException(SDKUIComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerWorkflowCameraComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder workflowModule(WorkflowModule workflowModule) {
            this.workflowModule = (WorkflowModule)Preconditions.checkNotNull((Object)workflowModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }
    }
}

