/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.camera.configuration;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.camera.configuration.DocumentScannerConfigurationParams;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b:\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0014J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\r2\b\b\u0001\u0010\u001d\u001a\u00020\u000bJ\u0010\u0010\u001e\u001a\u00020\r2\b\b\u0001\u0010\u001f\u001a\u00020\u000bJ\u0010\u0010 \u001a\u00020\r2\b\b\u0001\u0010!\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0005J\u000e\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000bJ\u000e\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u0014J\u000e\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020\u0005J\u000e\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\u0005J\u000e\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\u0014J\u000e\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\u0005J\u000e\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\u0014J\u000e\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\u0014J\u000e\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\u001bJ\u000e\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u000bJ\u000e\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020\u0014J\u000e\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\u0005J\u000e\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020\u0014J\u000e\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020JJ\u000e\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020\u0005J\u0010\u0010M\u001a\u00020\r2\b\b\u0001\u0010N\u001a\u00020\u000bJ\u000e\u0010O\u001a\u00020\r2\u0006\u0010P\u001a\u00020\u0014J\u0010\u0010Q\u001a\u00020\r2\b\b\u0001\u0010R\u001a\u00020\u000bJ\u0010\u0010S\u001a\u00020\r2\b\b\u0001\u0010T\u001a\u00020\u000bJ\u0010\u0010U\u001a\u00020\r2\b\b\u0001\u0010V\u001a\u00020\u000bJ\u0010\u0010W\u001a\u00020\r2\b\b\u0001\u0010X\u001a\u00020\u000bJ\u0010\u0010Y\u001a\u00020\r2\b\b\u0001\u0010Z\u001a\u00020\u000bJ\u0010\u0010[\u001a\u00020\r2\b\b\u0001\u0010\\\u001a\u00020\u000bJ\u0010\u0010]\u001a\u00020\r2\b\b\u0001\u0010^\u001a\u00020\u000bJ\u0010\u0010_\u001a\u00020\r2\b\b\u0001\u0010`\u001a\u00020\u000bJ\u0010\u0010a\u001a\u00020\r2\b\b\u0001\u0010b\u001a\u00020\u000bJ\u000e\u0010c\u001a\u00020\r2\u0006\u0010d\u001a\u00020\u0014J\u0010\u0010e\u001a\u00020\r2\b\b\u0001\u0010f\u001a\u00020\u000bJ\u0010\u0010g\u001a\u00020\r2\b\b\u0001\u0010h\u001a\u00020\u000bJ\u0010\u0010i\u001a\u00020\r2\u0006\u0010j\u001a\u00020\u0014H\u0007J\u000e\u0010k\u001a\u00020\r2\u0006\u0010l\u001a\u00020\u0005J\u000e\u0010m\u001a\u00020\r2\u0006\u0010n\u001a\u00020\u0005J\u000e\u0010o\u001a\u00020\r2\u0006\u0010p\u001a\u00020\u0005J\u000e\u0010q\u001a\u00020\r2\u0006\u0010r\u001a\u00020\u0005J\u000e\u0010s\u001a\u00020\r2\u0006\u0010t\u001a\u00020\u0005J\u000e\u0010u\u001a\u00020\r2\u0006\u0010v\u001a\u00020\u0005J\u000e\u0010w\u001a\u00020\r2\u0006\u0010x\u001a\u00020\u0005J\u0010\u0010y\u001a\u00020\r2\b\b\u0001\u0010z\u001a\u00020\u000bJ\u0010\u0010{\u001a\u00020\r2\b\b\u0001\u0010|\u001a\u00020\u000bJ\u0010\u0010}\u001a\u00020\r2\b\b\u0001\u0010~\u001a\u00020\u000bJ\u0011\u0010\u007f\u001a\u00020\r2\t\b\u0001\u0010\u0080\u0001\u001a\u00020\u000bJ\u0012\u0010\u0081\u0001\u001a\u00020\r2\t\b\u0001\u0010\u0082\u0001\u001a\u00020\u000bJ\u001d\u0010\u0083\u0001\u001a\u00020\r2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020\u000bH\u00d6\u0001R\"\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0087\u0001"}, d2={"Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerConfiguration;", "Landroid/os/Parcelable;", "()V", "cameraConfiguration", "", "", "Ljava/io/Serializable;", "Lkotlinx/android/parcel/RawValue;", "getCameraConfiguration", "()Ljava/util/Map;", "describeContents", "", "setAcceptedAngleScore", "", "acceptedAngleScore", "", "setAcceptedSizeScore", "acceptedSizeScore", "setAutoSnappingButtonHidden", "autoSnappingButtonHidden", "", "setAutoSnappingButtonTitle", "autoSnappingButtonTitle", "setAutoSnappingEnabled", "autoSnappingEnabled", "setAutoSnappingSensitivity", "autoSnappingSensitivity", "", "setBottomBarBackgroundColor", "bottomBarBackgroundColor", "setBottomBarButtonsColor", "bottomBarButtonsColor", "setCameraBackgroundColor", "cameraBackgroundColor", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCancelButtonTitle", "cancelButtonTitle", "setDelayAfterFocusCompleteMs", "delay", "", "setDocumentImageSizeLimit", "documentImageHeightLimit", "documentImageWidthLimit", "setDrawPolygonShadows", "drawPolygonShadows", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setFlashButtonHidden", "flashButtonHidden", "setFlashButtonTitle", "flashButtonTitle", "setFlashEnabled", "flashEnabled", "setIgnoreBadAspectRatio", "ignoreBadAspectRatio", "setImageFilterType", "imageFilterType", "Lio/scanbot/sdk/process/ImageFilterType;", "setImageScale", "imageScale", "setMaxNumberOfPages", "maxNumberOfPages", "setMultiPageButtonHidden", "multiPageButtonHidden", "setMultiPageButtonTitle", "multiPageButtonTitle", "setMultiPageEnabled", "multiPageEnabled", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setPageCounterButtonTitle", "pageCounterButtonTitle", "setPolygonAutoSnapProgressColor", "polygonAutoSnapProgressColor", "setPolygonAutoSnapProgressEnabled", "enabled", "setPolygonAutoSnapProgressLineWidth", "polygonProgressLineWidth", "setPolygonBackgroundColor", "polygonBackgroundColor", "setPolygonBackgroundColorOK", "polygonBackgroundColorOK", "setPolygonColor", "polygonColor", "setPolygonColorOK", "polygonColorOK", "setPolygonCornerRadius", "polygonCornerRadius", "setPolygonLineWidth", "polygonLineWidth", "setShutterButtonAutoInnerColor", "shutterButtonAutoInnerColor", "setShutterButtonAutoOuterColor", "shutterButtonAutoOuterColor", "setShutterButtonHidden", "shutterButtonHidden", "setShutterButtonManualInnerColor", "shutterButtonManualInnerColor", "setShutterButtonManualOuterColor", "shutterButtonManualOuterColor", "setShutterSoundEnabled", "shutterSoundEnabled", "setTextHintBadAngles", "textBadAngles", "setTextHintBadAspectRatio", "textHintBadAspectRatio", "setTextHintNothingDetected", "textHintNothingDetected", "setTextHintOK", "textHintDontMove", "setTextHintTooDark", "textHintTooDark", "setTextHintTooNoisy", "textHintTooNoisy", "setTextHintTooSmall", "textHintTooSmall", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsActiveColor", "topBarButtonsActiveColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setUserGuidanceBackgroundColor", "userGuidanceBackgroundColor", "setUserGuidanceTextColor", "userGuidanceTextColor", "writeToParcel", "parcel", "Landroid/os/Parcel;", "flags", "rtu-ui-bundle_release"})
@Parcelize
public final class DocumentScannerConfiguration
implements Parcelable {
    @NotNull
    private final Map<String, Serializable> cameraConfiguration = new HashMap();
    public static final Parcelable.Creator CREATOR = new Creator();

    @NotNull
    public final Map<String, Serializable> getCameraConfiguration() {
        return this.cameraConfiguration;
    }

    public final void setImageFilterType(@NotNull ImageFilterType imageFilterType) {
        Intrinsics.checkNotNullParameter((Object)imageFilterType, (String)"imageFilterType");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IMAGE_FILTER_TYPE.getKey(), (Serializable)imageFilterType);
    }

    public final void setDelayAfterFocusCompleteMs(long delay) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.DELAY_AFTER_FOCUS_COMPLETE_MS.getKey(), Long.valueOf(delay));
    }

    public final void setAutoSnappingEnabled(boolean autoSnappingEnabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_ENABLED.getKey(), Boolean.valueOf(autoSnappingEnabled));
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_ENABLED.getKey(), Boolean.valueOf(flashEnabled));
    }

    public final void setMultiPageEnabled(boolean multiPageEnabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_ENABLED.getKey(), Boolean.valueOf(multiPageEnabled));
    }

    public final void setMaxNumberOfPages(int maxNumberOfPages) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MAX_NUMBER_OF_PAGES.getKey(), Integer.valueOf(maxNumberOfPages));
    }

    public final void setAutoSnappingSensitivity(float autoSnappingSensitivity) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_SENSITIVITY.getKey(), Float.valueOf(autoSnappingSensitivity));
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_PREVIEW_MODE.getKey(), (Serializable)cameraPreviewMode);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ORIENTATION_LOCK_MODE.getKey(), (Serializable)cameraOrientationMode);
    }

    public final void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IGNORE_BAD_ASPECT_RATIO.getKey(), Boolean.valueOf(ignoreBadAspectRatio));
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCEPTED_ANGLE_SCORE.getKey(), Double.valueOf(acceptedAngleScore));
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCEPTED_SIZE_SCORE.getKey(), Double.valueOf(acceptedSizeScore));
    }

    public final void setImageScale(float imageScale) {
        float f = 0.0f;
        boolean bl = false;
        f = Math.max(f, imageScale);
        float f2 = 1.0f;
        boolean bl2 = false;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IMAGE_SCALE.getKey(), Float.valueOf(Math.min(f, f2)));
    }

    public final void setDocumentImageSizeLimit(int documentImageHeightLimit, int documentImageWidthLimit) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.DOCUMENT_IMAGE_SIZE_LIMIT.getKey(), (Serializable)new PageStorageProcessor.Configuration.Size(documentImageWidthLimit, documentImageHeightLimit));
    }

    public final void setPolygonColor(@ColorInt int polygonColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_COLOR.getKey(), Integer.valueOf(polygonColor));
    }

    public final void setPolygonColorOK(@ColorInt int polygonColorOK) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_COLOR_OK.getKey(), Integer.valueOf(polygonColorOK));
    }

    public final void setPolygonLineWidth(@Px int polygonLineWidth) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_LINE_WIDTH.getKey(), Integer.valueOf(polygonLineWidth));
    }

    public final void setPolygonAutoSnapProgressColor(@ColorInt int polygonAutoSnapProgressColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_COLOR.getKey(), Integer.valueOf(polygonAutoSnapProgressColor));
    }

    public final void setPolygonAutoSnapProgressLineWidth(@Px int polygonProgressLineWidth) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_LINE_WIDTH.getKey(), Integer.valueOf(polygonProgressLineWidth));
    }

    public final void setPolygonAutoSnapProgressEnabled(boolean enabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_ENABLED.getKey(), Boolean.valueOf(enabled));
    }

    public final void setPolygonCornerRadius(@Px int polygonCornerRadius) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_CORNER_RADIUS.getKey(), Integer.valueOf(polygonCornerRadius));
    }

    public final void setPolygonBackgroundColor(@ColorInt int polygonBackgroundColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_BACKGROUND_COLOR.getKey(), Integer.valueOf(polygonBackgroundColor));
    }

    public final void setPolygonBackgroundColorOK(@ColorInt int polygonBackgroundColorOK) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_BACKGROUND_COLOR_OK.getKey(), Integer.valueOf(polygonBackgroundColorOK));
    }

    public final void setDrawPolygonShadows(boolean drawPolygonShadows) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_DRAW_SHADOWS.getKey(), Boolean.valueOf(drawPolygonShadows));
    }

    public final void setShutterButtonAutoOuterColor(@ColorInt int shutterButtonAutoOuterColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_AUTO_OUTER_COLOR.getKey(), Integer.valueOf(shutterButtonAutoOuterColor));
    }

    public final void setShutterButtonAutoInnerColor(@ColorInt int shutterButtonAutoInnerColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_AUTO_INNER_COLOR.getKey(), Integer.valueOf(shutterButtonAutoInnerColor));
    }

    public final void setShutterButtonManualOuterColor(@ColorInt int shutterButtonManualOuterColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_OUTER_COLOR.getKey(), Integer.valueOf(shutterButtonManualOuterColor));
    }

    public final void setShutterButtonManualInnerColor(@ColorInt int shutterButtonManualInnerColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_INNER_COLOR.getKey(), Integer.valueOf(shutterButtonManualInnerColor));
    }

    @RequiresApi(api=17)
    public final void setShutterSoundEnabled(boolean shutterSoundEnabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_SOUND_ENABLED.getKey(), Boolean.valueOf(shutterSoundEnabled));
    }

    public final void setUserGuidanceBackgroundColor(@ColorInt int userGuidanceBackgroundColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USER_GUIDANCE_BACKGROUND_COLOR.getKey(), Integer.valueOf(userGuidanceBackgroundColor));
    }

    public final void setUserGuidanceTextColor(@ColorInt int userGuidanceTextColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USER_GUIDANCE_TEXT_COLOR.getKey(), Integer.valueOf(userGuidanceTextColor));
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BACKGROUND_COLOR.getKey(), Integer.valueOf(topBarBackgroundColor));
    }

    public final void setTopBarButtonsActiveColor(@ColorInt int topBarButtonsActiveColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BUTTONS_ACTIVE_COLOR.getKey(), Integer.valueOf(topBarButtonsActiveColor));
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BUTTONS_INACTIVE_COLOR.getKey(), Integer.valueOf(topBarButtonsInactiveColor));
    }

    public final void setBottomBarBackgroundColor(@ColorInt int bottomBarBackgroundColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.BOTTOM_BAR_BACKGROUND_COLOR.getKey(), Integer.valueOf(bottomBarBackgroundColor));
    }

    public final void setBottomBarButtonsColor(@ColorInt int bottomBarButtonsColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.BOTTOM_BAR_BUTTONS_COLOR.getKey(), Integer.valueOf(bottomBarButtonsColor));
    }

    public final void setCameraBackgroundColor(@ColorInt int cameraBackgroundColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_BACKGROUND_COLOR.getKey(), Integer.valueOf(cameraBackgroundColor));
    }

    public final void setMultiPageButtonHidden(boolean multiPageButtonHidden) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_BUTTON_HIDDEN.getKey(), Boolean.valueOf(multiPageButtonHidden));
    }

    public final void setFlashButtonHidden(boolean flashButtonHidden) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_BUTTON_HIDDEN.getKey(), Boolean.valueOf(flashButtonHidden));
    }

    public final void setAutoSnappingButtonHidden(boolean autoSnappingButtonHidden) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_BUTTON_HIDDEN.getKey(), Boolean.valueOf(autoSnappingButtonHidden));
    }

    public final void setShutterButtonHidden(boolean shutterButtonHidden) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_HIDDEN.getKey(), Boolean.valueOf(shutterButtonHidden));
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CANCEL_BUTTON_TITLE.getKey(), (Serializable)((Object)cancelButtonTitle));
    }

    public final void setPageCounterButtonTitle(@NotNull String pageCounterButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)pageCounterButtonTitle, (String)"pageCounterButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.PAGE_COUNTER_BUTTON_TITLE.getKey(), (Serializable)((Object)pageCounterButtonTitle));
    }

    public final void setTextHintOK(@NotNull String textHintDontMove) {
        Intrinsics.checkNotNullParameter((Object)textHintDontMove, (String)"textHintDontMove");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_OK.getKey(), (Serializable)((Object)textHintDontMove));
    }

    public final void setTextHintTooSmall(@NotNull String textHintTooSmall) {
        Intrinsics.checkNotNullParameter((Object)textHintTooSmall, (String)"textHintTooSmall");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_SMALL.getKey(), (Serializable)((Object)textHintTooSmall));
    }

    public final void setTextHintBadAngles(@NotNull String textBadAngles) {
        Intrinsics.checkNotNullParameter((Object)textBadAngles, (String)"textBadAngles");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_BAD_ANGLES.getKey(), (Serializable)((Object)textBadAngles));
    }

    public final void setTextHintBadAspectRatio(@NotNull String textHintBadAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)textHintBadAspectRatio, (String)"textHintBadAspectRatio");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_BAD_ASPECT_RATIO.getKey(), (Serializable)((Object)textHintBadAspectRatio));
    }

    public final void setTextHintNothingDetected(@NotNull String textHintNothingDetected) {
        Intrinsics.checkNotNullParameter((Object)textHintNothingDetected, (String)"textHintNothingDetected");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_NOTHING_DETECTED.getKey(), (Serializable)((Object)textHintNothingDetected));
    }

    public final void setTextHintTooNoisy(@NotNull String textHintTooNoisy) {
        Intrinsics.checkNotNullParameter((Object)textHintTooNoisy, (String)"textHintTooNoisy");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_NOISY.getKey(), (Serializable)((Object)textHintTooNoisy));
    }

    public final void setTextHintTooDark(@NotNull String textHintTooDark) {
        Intrinsics.checkNotNullParameter((Object)textHintTooDark, (String)"textHintTooDark");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_DARK.getKey(), (Serializable)((Object)textHintTooDark));
    }

    public final void setMultiPageButtonTitle(@NotNull String multiPageButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)multiPageButtonTitle, (String)"multiPageButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_BUTTON_TITLE.getKey(), (Serializable)((Object)multiPageButtonTitle));
    }

    public final void setFlashButtonTitle(@NotNull String flashButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)flashButtonTitle, (String)"flashButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_BUTTON_TITLE.getKey(), (Serializable)((Object)flashButtonTitle));
    }

    public final void setAutoSnappingButtonTitle(@NotNull String autoSnappingButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)autoSnappingButtonTitle, (String)"autoSnappingButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_BUTTON_TITLE.getKey(), (Serializable)((Object)autoSnappingButtonTitle));
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ENABLE_CAMERA_EXPLANATION_TEXT.getKey(), (Serializable)((Object)enableCameraExplanationText));
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ENABLE_CAMERA_BUTTON_TITLE.getKey(), (Serializable)((Object)enableCameraButtonTitle));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        if (this != null) {
            parcel.writeInt(1);
        } else {
            parcel.writeInt(0);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class Creator
    implements Parcelable.Creator {
        @NotNull
        public final Object[] newArray(int size) {
            return new DocumentScannerConfiguration[size];
        }

        @NotNull
        public final Object createFromParcel(@NotNull Parcel in) {
            DocumentScannerConfiguration documentScannerConfiguration;
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            DocumentScannerConfiguration documentScannerConfiguration2 = documentScannerConfiguration;
            DocumentScannerConfiguration documentScannerConfiguration3 = documentScannerConfiguration;
            return in.readInt() != 0 ? new DocumentScannerConfiguration() : null;
        }
    }
}

