/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.sdk.barcode.entity.FormattedBarcodeDataMapper;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.ui.di.components.BatchBarcodeCameraComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.BatchBarcodeModule;
import io.scanbot.sdk.ui.di.modules.BatchBarcodeModule_ProvideBarcodeScanningSession$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.BatchBarcodeModule_ProvideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraPresenter;
import io.scanbot.sdk.ui.view.barcode.BarcodeScanningSession;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeListPresenter;
import io.scanbot.sdk.ui.view.barcode.batch.InternalBatchBarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.batch.InternalBatchBarcodeCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodePreviewFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodeTakenPictureUseCase;
import javax.inject.Provider;

public final class DaggerBatchBarcodeCameraComponent
implements BatchBarcodeCameraComponent {
    private final SDKUIComponent sDKUIComponent;
    private Provider<BarcodeScanningSession> provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider;
    private Provider<Navigator> providesNavigatorProvider;
    private Provider<FormattedBarcodeDataMapper> provideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseProvider;

    private DaggerBatchBarcodeCameraComponent(NavigatorModule navigatorModuleParam, BatchBarcodeModule batchBarcodeModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.sDKUIComponent = sDKUIComponentParam;
        this.initialize(navigatorModuleParam, batchBarcodeModuleParam, sDKUIComponentParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private SaveBarcodeTakenPictureUseCase getSaveBarcodeTakenPictureUseCase() {
        return new SaveBarcodeTakenPictureUseCase((BarcodeFileStorage)Preconditions.checkNotNull((Object)this.sDKUIComponent.barcodeFileStorage(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private SaveBarcodePreviewFrameUseCase getSaveBarcodePreviewFrameUseCase() {
        return new SaveBarcodePreviewFrameUseCase((BarcodeFileStorage)Preconditions.checkNotNull((Object)this.sDKUIComponent.barcodeFileStorage(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private BarcodeCameraPresenter getBarcodeCameraPresenter() {
        return new BarcodeCameraPresenter(this.getCheckCameraPermissionUseCase(), this.getSaveBarcodeTakenPictureUseCase(), this.getSaveBarcodePreviewFrameUseCase(), (BarcodeScanningSession)this.provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider.get(), (Navigator)this.providesNavigatorProvider.get());
    }

    private BatchBarcodeListPresenter getBatchBarcodeListPresenter() {
        return new BatchBarcodeListPresenter((Navigator)this.providesNavigatorProvider.get(), (FormattedBarcodeDataMapper)this.provideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseProvider.get(), (BarcodeScanningSession)this.provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider.get(), (Scheduler)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideBackgroundTaskScheduler(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private void initialize(NavigatorModule navigatorModuleParam, BatchBarcodeModule batchBarcodeModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)BatchBarcodeModule_ProvideBarcodeScanningSession$rtu_ui_bundle_releaseFactory.create(batchBarcodeModuleParam));
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)navigatorModuleParam));
        this.provideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)BatchBarcodeModule_ProvideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseFactory.create(batchBarcodeModuleParam));
    }

    @Override
    public void inject(BatchBarcodeCameraFragment batchBarcodeCameraFragment) {
        this.injectBatchBarcodeCameraFragment(batchBarcodeCameraFragment);
    }

    private BatchBarcodeCameraFragment injectBatchBarcodeCameraFragment(BatchBarcodeCameraFragment instance) {
        BaseBarcodeCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseBarcodeCameraFragment)instance, (CheckCameraPermissionUseCase)this.getCheckCameraPermissionUseCase());
        BaseBarcodeCameraFragment_MembersInjector.injectBarcodeCameraPresenter((BaseBarcodeCameraFragment)instance, (BarcodeCameraPresenter)this.getBarcodeCameraPresenter());
        InternalBatchBarcodeCameraFragment_MembersInjector.injectBatchBarcodeListPresenter((InternalBatchBarcodeCameraFragment)instance, (BatchBarcodeListPresenter)this.getBatchBarcodeListPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private BatchBarcodeModule batchBarcodeModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder batchBarcodeModule(BatchBarcodeModule batchBarcodeModule) {
            this.batchBarcodeModule = (BatchBarcodeModule)Preconditions.checkNotNull((Object)batchBarcodeModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public BatchBarcodeCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.navigatorModule, NavigatorModule.class);
            Preconditions.checkBuilderRequirement((Object)this.batchBarcodeModule, BatchBarcodeModule.class);
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DaggerBatchBarcodeCameraComponent(this.navigatorModule, this.batchBarcodeModule, this.sDKUIComponent);
        }
    }
}

