/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.scanbot.sdk.generictext.GenericTextRecognizer;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.components.TextDataScannerComponent;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.generictext.BaseTextDataScannerFragment;
import io.scanbot.sdk.ui.view.generictext.BaseTextDataScannerFragment_MembersInjector;
import io.scanbot.sdk.ui.view.generictext.TextDataScannerFragment;
import io.scanbot.sdk.ui.view.generictext.TextDataScannerPresenter;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import javax.inject.Provider;

public final class DaggerTextDataScannerComponent
implements TextDataScannerComponent {
    private final SDKUIComponent sDKUIComponent;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerTextDataScannerComponent(NavigatorModule navigatorModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.sDKUIComponent = sDKUIComponentParam;
        this.initialize(navigatorModuleParam, sDKUIComponentParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private TextDataScannerPresenter getTextDataScannerPresenter() {
        return new TextDataScannerPresenter(this.getCheckCameraPermissionUseCase(), (Navigator)this.providesNavigatorProvider.get());
    }

    private void initialize(NavigatorModule navigatorModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)navigatorModuleParam));
    }

    @Override
    public void inject(TextDataScannerFragment fragment) {
        this.injectTextDataScannerFragment(fragment);
    }

    private TextDataScannerFragment injectTextDataScannerFragment(TextDataScannerFragment instance) {
        BaseTextDataScannerFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseTextDataScannerFragment)instance, (CheckCameraPermissionUseCase)this.getCheckCameraPermissionUseCase());
        BaseTextDataScannerFragment_MembersInjector.injectGenericTextRecognizer((BaseTextDataScannerFragment)instance, (GenericTextRecognizer)((GenericTextRecognizer)Preconditions.checkNotNull((Object)this.sDKUIComponent.genericTextRecognizer(), (String)"Cannot return null from a non-@Nullable component method")));
        BaseTextDataScannerFragment_MembersInjector.injectTextDataScannerPresenter((BaseTextDataScannerFragment)instance, (TextDataScannerPresenter)this.getTextDataScannerPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public TextDataScannerComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.navigatorModule, NavigatorModule.class);
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DaggerTextDataScannerComponent(this.navigatorModule, this.sDKUIComponent);
        }
    }
}

