/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.ui.di.components.BarcodeCameraComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.BarcodeModule;
import io.scanbot.sdk.ui.di.modules.BarcodeModule_ProvideBarcodeScanningSession$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraPresenter;
import io.scanbot.sdk.ui.view.barcode.BarcodeScanningSession;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodePreviewFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodeTakenPictureUseCase;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerBarcodeCameraComponent
implements BarcodeCameraComponent {
    private final SDKUIComponent sDKUIComponent;
    private Provider<BarcodeScanningSession> provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerBarcodeCameraComponent(NavigatorModule navigatorModuleParam, BarcodeModule barcodeModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.sDKUIComponent = sDKUIComponentParam;
        this.initialize(navigatorModuleParam, barcodeModuleParam, sDKUIComponentParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase checkCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext()));
    }

    private SaveBarcodeTakenPictureUseCase saveBarcodeTakenPictureUseCase() {
        return new SaveBarcodeTakenPictureUseCase((BarcodeFileStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.barcodeFileStorage()), (ImageFileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.imageFileIOProcessor()));
    }

    private SaveBarcodePreviewFrameUseCase saveBarcodePreviewFrameUseCase() {
        return new SaveBarcodePreviewFrameUseCase((BarcodeFileStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.barcodeFileStorage()), (ImageFileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.imageFileIOProcessor()));
    }

    private BarcodeCameraPresenter barcodeCameraPresenter() {
        return new BarcodeCameraPresenter(this.checkCameraPermissionUseCase(), this.saveBarcodeTakenPictureUseCase(), this.saveBarcodePreviewFrameUseCase(), (BarcodeScanningSession)this.provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider.get(), (Navigator)this.providesNavigatorProvider.get());
    }

    private void initialize(NavigatorModule navigatorModuleParam, BarcodeModule barcodeModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)BarcodeModule_ProvideBarcodeScanningSession$rtu_ui_bundle_releaseFactory.create(barcodeModuleParam));
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)navigatorModuleParam));
    }

    @Override
    public void inject(BarcodeCameraFragment barcodeCameraFragment) {
        this.injectBarcodeCameraFragment(barcodeCameraFragment);
    }

    private BarcodeCameraFragment injectBarcodeCameraFragment(BarcodeCameraFragment instance) {
        BaseBarcodeCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseBarcodeCameraFragment)instance, (CheckCameraPermissionUseCase)this.checkCameraPermissionUseCase());
        BaseBarcodeCameraFragment_MembersInjector.injectBarcodeCameraPresenter((BaseBarcodeCameraFragment)instance, (BarcodeCameraPresenter)this.barcodeCameraPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private BarcodeModule barcodeModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder barcodeModule(BarcodeModule barcodeModule) {
            this.barcodeModule = (BarcodeModule)Preconditions.checkNotNull((Object)barcodeModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public BarcodeCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.navigatorModule, NavigatorModule.class);
            Preconditions.checkBuilderRequirement((Object)this.barcodeModule, BarcodeModule.class);
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DaggerBarcodeCameraComponent(this.navigatorModule, this.barcodeModule, this.sDKUIComponent);
        }
    }
}

