/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.scanbot.sdk.idcardscanner.IdCardScanner;
import io.scanbot.sdk.persistance.IdCardFileStorage;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.ui.di.components.IdCardCameraComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.IdCardModule;
import io.scanbot.sdk.ui.di.modules.IdCardModule_ProvideIdCardScanningSession$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.idcard.BaseIdCardCameraFragment;
import io.scanbot.sdk.ui.view.idcard.BaseIdCardCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.idcard.IdCardCameraFragment;
import io.scanbot.sdk.ui.view.idcard.IdCardCameraPresenter;
import io.scanbot.sdk.ui.view.idcard.IdCardScanningSession;
import io.scanbot.sdk.ui.view.idcard.interactor.SaveIdCardImagesUseCase;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListPresenter;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerIdCardCameraComponent
implements IdCardCameraComponent {
    private final SDKUIComponent sDKUIComponent;
    private Provider<Navigator> providesNavigatorProvider;
    private Provider<IdCardScanningSession> provideIdCardScanningSession$rtu_ui_bundle_releaseProvider;

    private DaggerIdCardCameraComponent(NavigatorModule navigatorModuleParam, IdCardModule idCardModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.sDKUIComponent = sDKUIComponentParam;
        this.initialize(navigatorModuleParam, idCardModuleParam, sDKUIComponentParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase checkCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext()));
    }

    private IdCardCameraPresenter idCardCameraPresenter() {
        return new IdCardCameraPresenter(this.checkCameraPermissionUseCase(), (Navigator)this.providesNavigatorProvider.get(), (IdCardScanningSession)this.provideIdCardScanningSession$rtu_ui_bundle_releaseProvider.get());
    }

    private SaveIdCardImagesUseCase saveIdCardImagesUseCase() {
        return new SaveIdCardImagesUseCase((IdCardFileStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.idCardFileStorage()), (ImageFileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.imageFileIOProcessor()));
    }

    private IdCardFieldListPresenter idCardFieldListPresenter() {
        return new IdCardFieldListPresenter((Navigator)this.providesNavigatorProvider.get(), (IdCardScanningSession)this.provideIdCardScanningSession$rtu_ui_bundle_releaseProvider.get(), this.saveIdCardImagesUseCase());
    }

    private void initialize(NavigatorModule navigatorModuleParam, IdCardModule idCardModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)navigatorModuleParam));
        this.provideIdCardScanningSession$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)IdCardModule_ProvideIdCardScanningSession$rtu_ui_bundle_releaseFactory.create(idCardModuleParam));
    }

    @Override
    public void inject(IdCardCameraFragment idCardCameraFragment) {
        this.injectIdCardCameraFragment(idCardCameraFragment);
    }

    private IdCardCameraFragment injectIdCardCameraFragment(IdCardCameraFragment instance) {
        BaseIdCardCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseIdCardCameraFragment)instance, (CheckCameraPermissionUseCase)this.checkCameraPermissionUseCase());
        BaseIdCardCameraFragment_MembersInjector.injectIdCardScanner((BaseIdCardCameraFragment)instance, (IdCardScanner)((IdCardScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.idCardScanner())));
        BaseIdCardCameraFragment_MembersInjector.injectIdCardCameraPresenter((BaseIdCardCameraFragment)instance, (IdCardCameraPresenter)this.idCardCameraPresenter());
        BaseIdCardCameraFragment_MembersInjector.injectIdCardFieldListPresenter((BaseIdCardCameraFragment)instance, (IdCardFieldListPresenter)this.idCardFieldListPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private IdCardModule idCardModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder idCardModule(IdCardModule idCardModule) {
            this.idCardModule = (IdCardModule)Preconditions.checkNotNull((Object)idCardModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public IdCardCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.navigatorModule, NavigatorModule.class);
            Preconditions.checkBuilderRequirement((Object)this.idCardModule, IdCardModule.class);
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DaggerIdCardCameraComponent(this.navigatorModule, this.idCardModule, this.sDKUIComponent);
        }
    }
}

