/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.app.Application;
import android.content.Context;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.sdk.persistence.DraftPagesRepository;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.components.WorkflowCameraComponent;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.di.modules.WorkflowModule;
import io.scanbot.sdk.ui.di.modules.WorkflowModule_ProvideWorkflowScannersFactory$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.entity.workflow.WorkflowScannersFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.FinalizePagesUseCase;
import io.scanbot.sdk.ui.view.interactor.RemoveDraftPageUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveCameraFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveTakenPictureUseCase;
import io.scanbot.sdk.ui.view.interactor.WorkflowDetectionUseCase;
import io.scanbot.sdk.ui.view.workflow.WorkflowCameraFragment;
import io.scanbot.sdk.ui.view.workflow.WorkflowCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.workflow.WorkflowCameraPresenter;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerWorkflowCameraComponent
implements WorkflowCameraComponent {
    private final SDKUIComponent sDKUIComponent;
    private Provider<Application> provideApplicationProvider;
    private Provider<WorkflowScannersFactory> provideWorkflowScannersFactory$rtu_ui_bundle_releaseProvider;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerWorkflowCameraComponent(NavigatorModule navigatorModuleParam, WorkflowModule workflowModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.sDKUIComponent = sDKUIComponentParam;
        this.initialize(navigatorModuleParam, workflowModuleParam, sDKUIComponentParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase checkCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext()));
    }

    private SaveTakenPictureUseCase saveTakenPictureUseCase() {
        return new SaveTakenPictureUseCase((DraftPagesRepository)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.draftPagesRepository()));
    }

    private SaveCameraFrameUseCase saveCameraFrameUseCase() {
        return new SaveCameraFrameUseCase((DraftPagesRepository)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.draftPagesRepository()));
    }

    private WorkflowDetectionUseCase workflowDetectionUseCase() {
        return new WorkflowDetectionUseCase((WorkflowScannersFactory)this.provideWorkflowScannersFactory$rtu_ui_bundle_releaseProvider.get());
    }

    private RemoveDraftPageUseCase removeDraftPageUseCase() {
        return new RemoveDraftPageUseCase((Cleaner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideCleaner()));
    }

    private FinalizePagesUseCase finalizePagesUseCase() {
        return new FinalizePagesUseCase((PageStorageProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.pageStorageProcessor()));
    }

    private WorkflowCameraPresenter workflowCameraPresenter() {
        return new WorkflowCameraPresenter(this.checkCameraPermissionUseCase(), this.saveTakenPictureUseCase(), this.saveCameraFrameUseCase(), this.workflowDetectionUseCase(), this.removeDraftPageUseCase(), this.finalizePagesUseCase(), (Navigator)this.providesNavigatorProvider.get(), (Scheduler)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideBackgroundTaskScheduler()), (Scheduler)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideUiScheduler()));
    }

    private void initialize(NavigatorModule navigatorModuleParam, WorkflowModule workflowModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.provideApplicationProvider = new io_scanbot_sdk_ui_di_components_SDKUIComponent_provideApplication(sDKUIComponentParam);
        this.provideWorkflowScannersFactory$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)WorkflowModule_ProvideWorkflowScannersFactory$rtu_ui_bundle_releaseFactory.create(workflowModuleParam, this.provideApplicationProvider));
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)navigatorModuleParam));
    }

    @Override
    public WorkflowScannersFactory provideWorkflowScannersFactory() {
        return (WorkflowScannersFactory)this.provideWorkflowScannersFactory$rtu_ui_bundle_releaseProvider.get();
    }

    @Override
    public void inject(WorkflowCameraFragment workflowCameraFragment) {
        this.injectWorkflowCameraFragment(workflowCameraFragment);
    }

    private WorkflowCameraFragment injectWorkflowCameraFragment(WorkflowCameraFragment instance) {
        WorkflowCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase(instance, this.checkCameraPermissionUseCase());
        WorkflowCameraFragment_MembersInjector.injectWorkflowCameraPresenter(instance, this.workflowCameraPresenter());
        WorkflowCameraFragment_MembersInjector.injectWorkflowScannersFactory(instance, (WorkflowScannersFactory)this.provideWorkflowScannersFactory$rtu_ui_bundle_releaseProvider.get());
        return instance;
    }

    private static class io_scanbot_sdk_ui_di_components_SDKUIComponent_provideApplication
    implements Provider<Application> {
        private final SDKUIComponent sDKUIComponent;

        io_scanbot_sdk_ui_di_components_SDKUIComponent_provideApplication(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = sDKUIComponent;
        }

        public Application get() {
            return (Application)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideApplication());
        }
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private WorkflowModule workflowModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder workflowModule(WorkflowModule workflowModule) {
            this.workflowModule = (WorkflowModule)Preconditions.checkNotNull((Object)workflowModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public WorkflowCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.navigatorModule, NavigatorModule.class);
            Preconditions.checkBuilderRequirement((Object)this.workflowModule, WorkflowModule.class);
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DaggerWorkflowCameraComponent(this.navigatorModule, this.workflowModule, this.sDKUIComponent);
        }
    }
}

