/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.workflow;

import android.graphics.Rect;
import android.graphics.RectF;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.processors.BehaviorProcessor;
import io.reactivex.processors.PublishProcessor;
import io.scanbot.sdk.camera.CaptureInfo;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.core.contourdetector.PageAspectRatio;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.ui.di.BackgroundTaskScheduler;
import io.scanbot.sdk.ui.di.UiScheduler;
import io.scanbot.sdk.ui.entity.workflow.BasicWorkflowStepResult;
import io.scanbot.sdk.ui.entity.workflow.ScanBarCodeWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanDisabilityCertificateWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanDocumentPageWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanMachineReadableZoneWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanPayFormWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.Workflow;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStepError;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStepResult;
import io.scanbot.sdk.ui.utils.CrossViewStatePresenter;
import io.scanbot.sdk.ui.utils.StatelessView;
import io.scanbot.sdk.ui.utils.events.Signal;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.FinalizePagesUseCase;
import io.scanbot.sdk.ui.view.interactor.RemoveDraftPageUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveCameraFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveTakenPictureUseCase;
import io.scanbot.sdk.ui.view.interactor.WorkflowDetectionUseCase;
import io.scanbot.sdk.ui.view.workflow.IWorkflowCameraView;
import io.scanbot.sdk.ui.view.workflow.WorkflowCameraPresenter;
import io.scanbot.sdk.ui.view.workflow.WorkflowCameraPresenter$resume$;
import io.scanbot.sdk.ui.view.workflow.camera.WorkflowFrameHandler;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0004fghiBU\b\u0007\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0001\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0016J\n\u00108\u001a\u0004\u0018\u000109H\u0002J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020;H\u0016J4\u0010=\u001a\u001e\u0012\b\b\u0001\u0012\u0004\u0018\u00010? \u001a*\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010?\u0018\u00010>0>2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\b\u0010D\u001a\u00020;H\u0002J\b\u0010E\u001a\u00020;H\u0002J\b\u0010F\u001a\u00020;H\u0002J\u0010\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020IH\u0002J\b\u0010J\u001a\u00020;H\u0016J\b\u0010K\u001a\u00020;H\u0016J\b\u0010L\u001a\u00020;H\u0016J\b\u0010M\u001a\u00020;H\u0016J\b\u0010N\u001a\u00020;H\u0016J\b\u0010O\u001a\u00020;H\u0016J\u0010\u0010P\u001a\u00020;2\u0006\u0010Q\u001a\u00020&H\u0016J\u0018\u0010R\u001a\u00020;2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010S\u001a\u00020;H\u0016J\b\u0010T\u001a\u00020;H\u0002J\b\u0010U\u001a\u00020;H\u0002J\u0010\u0010V\u001a\u00020;2\u0006\u0010W\u001a\u00020\u0003H\u0016J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0Y2\u0006\u0010Q\u001a\u00020&H\u0002J*\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00190Y2\u0006\u0010H\u001a\u00020I2\u0006\u0010Q\u001a\u00020&2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010ZH\u0002J\u000e\u0010]\u001a\u00020;2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010^\u001a\u00020;2\u0006\u0010!\u001a\u00020\"J\u000e\u0010_\u001a\u00020;2\u0006\u0010`\u001a\u00020 J\u000e\u0010a\u001a\u00020;2\u0006\u0010'\u001a\u00020(J\u000e\u0010b\u001a\u00020;2\u0006\u0010c\u001a\u00020 J\u0018\u0010d\u001a\u00020;2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010e\u001a\u00020;2\u0006\u0010Q\u001a\u00020&H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0017\u001a&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019 \u001a*\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010$R2\u0010%\u001a&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010&0& \u001a*\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010&0&\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010$R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter;", "Lio/scanbot/sdk/ui/utils/CrossViewStatePresenter;", "Lio/scanbot/sdk/ui/view/workflow/IWorkflowCameraView$State;", "Lio/scanbot/sdk/ui/view/workflow/IWorkflowCameraView;", "Lio/scanbot/sdk/ui/view/workflow/IWorkflowCameraView$Listener;", "checkCameraPermissionUseCase", "Lio/scanbot/sdk/ui/view/interactor/CheckCameraPermissionUseCase;", "saveTakenPictureUseCase", "Lio/scanbot/sdk/ui/view/interactor/SaveTakenPictureUseCase;", "saveCameraFrameUseCase", "Lio/scanbot/sdk/ui/view/interactor/SaveCameraFrameUseCase;", "workflowDetectionUseCase", "Lio/scanbot/sdk/ui/view/interactor/WorkflowDetectionUseCase;", "removeDraftPageUseCase", "Lio/scanbot/sdk/ui/view/interactor/RemoveDraftPageUseCase;", "finalizePagesUseCase", "Lio/scanbot/sdk/ui/view/interactor/FinalizePagesUseCase;", "navigator", "Lio/scanbot/sdk/ui/utils/navigator/Navigator;", "backgroundTaskScheduler", "Lio/reactivex/Scheduler;", "uiScheduler", "(Lio/scanbot/sdk/ui/view/interactor/CheckCameraPermissionUseCase;Lio/scanbot/sdk/ui/view/interactor/SaveTakenPictureUseCase;Lio/scanbot/sdk/ui/view/interactor/SaveCameraFrameUseCase;Lio/scanbot/sdk/ui/view/interactor/WorkflowDetectionUseCase;Lio/scanbot/sdk/ui/view/interactor/RemoveDraftPageUseCase;Lio/scanbot/sdk/ui/view/interactor/FinalizePagesUseCase;Lio/scanbot/sdk/ui/utils/navigator/Navigator;Lio/reactivex/Scheduler;Lio/reactivex/Scheduler;)V", "beepFlow", "Lio/reactivex/processors/PublishProcessor;", "Lio/scanbot/sdk/ui/utils/events/Signal;", "kotlin.jvm.PlatformType", "getCheckCameraPermissionUseCase", "()Lio/scanbot/sdk/ui/view/interactor/CheckCameraPermissionUseCase;", "setCheckCameraPermissionUseCase", "(Lio/scanbot/sdk/ui/view/interactor/CheckCameraPermissionUseCase;)V", "cleanupOnCancel", "", "documentImageSizeLimit", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "flashConfiguration", "Ljava/lang/Boolean;", "frameDataFlow", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "imageScale", "", "logger", "Lio/scanbot/sdk/util/log/Logger;", "saveTakenPictureSubscription", "Lio/reactivex/disposables/Disposable;", "shutterSoundEnabledConfiguration", "stepsCache", "Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$WorkflowStepsCache;", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "workflow", "Lio/scanbot/sdk/ui/entity/workflow/Workflow;", "getWorkflow$rtu_ui_bundle_release", "()Lio/scanbot/sdk/ui/entity/workflow/Workflow;", "setWorkflow$rtu_ui_bundle_release", "(Lio/scanbot/sdk/ui/entity/workflow/Workflow;)V", "calculateFinderRectF", "Landroid/graphics/RectF;", "cameraPermissionDenied", "", "cameraPermissionGranted", "detectOrSkip", "Lio/reactivex/Single;", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "image", "", "captureInfo", "Lio/scanbot/sdk/camera/CaptureInfo;", "disableErrorProcessingWithDelay", "finalizePagesAndShowResult", "goToNextStepOrShowResult", "isBeepableStep", "detectedFrameStep", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "onActivateCameraPermission", "onCameraOpened", "onCancelClicked", "onErrorDialogClosed", "onFlashClicked", "onLicenseInvalid", "onNewDetectionResult", "detectedFrameData", "pageSnapped", "pause", "removeCachedPages", "restartCurrentStep", "resume", "view", "saveCameraFrame", "Lio/reactivex/Flowable;", "Lio/scanbot/sdk/persistence/Page;", "saveDetectionResult", "framePage", "setCleanupOnCancel", "setDocumentImageSizeLimit", "setFlashEnabled", "flashEnabled", "setImageScale", "setShutterSoundEnabled", "shutterSoundEnabled", "storePageInDraftRepository", "validateStepResult", "Companion", "FinishWorkflow", "StepFrameData", "WorkflowStepsCache", "rtu-ui-bundle_release"})
public final class WorkflowCameraPresenter
extends CrossViewStatePresenter<IWorkflowCameraView.State, IWorkflowCameraView>
implements IWorkflowCameraView.Listener {
    private final CompositeDisposable subscriptions;
    private Disposable saveTakenPictureSubscription;
    @NotNull
    private Workflow workflow;
    private final WorkflowStepsCache stepsCache;
    private final PublishProcessor<WorkflowFrameHandler.DetectedFrameData> frameDataFlow;
    private final PublishProcessor<Signal> beepFlow;
    private Boolean flashConfiguration;
    private Boolean shutterSoundEnabledConfiguration;
    private float imageScale;
    private boolean cleanupOnCancel;
    private PageStorageProcessor.Configuration.Size documentImageSizeLimit;
    private final Logger logger;
    @Nullable
    private CheckCameraPermissionUseCase checkCameraPermissionUseCase;
    private final SaveTakenPictureUseCase saveTakenPictureUseCase;
    private final SaveCameraFrameUseCase saveCameraFrameUseCase;
    private final WorkflowDetectionUseCase workflowDetectionUseCase;
    private final RemoveDraftPageUseCase removeDraftPageUseCase;
    private final FinalizePagesUseCase finalizePagesUseCase;
    private final Navigator navigator;
    private final Scheduler backgroundTaskScheduler;
    private final Scheduler uiScheduler;
    @NotNull
    public static final String NAVIGATE_PLAY_BEEP = "NAVIGATE_PLAY_BEEP";
    @NotNull
    public static final String NAVIGATE_CANCEL_SNAPPING = "NAVIGATE_CANCEL_SNAPPING";
    @NotNull
    public static final String NAVIGATE_CANCEL_LICENSE_INVALID = "NAVIGATE_CANCEL_LICENSE_INVALID";
    @NotNull
    public static final String NAVIGATE_CLOSE_SNAPPING = "NAVIGATE_CLOSE_SNAPPING";
    @NotNull
    public static final String NAVIGATE_CAMERA_PERMISSION_SETTINGS = "NAVIGATE_CAMERA_PERMISSION_SETTINGS";
    @NotNull
    public static final String NAVIGATE_REQUEST_CAMERA_PERMISSION = "NAVIGATE_REQUEST_CAMERA_PERMISSION";
    public static final long ERROR_PROCESSING_DELAY_IN_SECONDS = 2L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Workflow getWorkflow$rtu_ui_bundle_release() {
        return this.workflow;
    }

    public final void setWorkflow$rtu_ui_bundle_release(@NotNull Workflow workflow) {
        Intrinsics.checkNotNullParameter((Object)workflow, (String)"<set-?>");
        this.workflow = workflow;
    }

    public void resume(@NotNull IWorkflowCameraView view) {
        block3: {
            boolean bl;
            boolean bl2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super.resume((StatelessView)view);
            view.setListener(this);
            if (this.getState() == null) {
                boolean it;
                this.updateState(IWorkflowCameraView.State.Companion.getDEFAULT());
                Boolean bl3 = this.flashConfiguration;
                if (bl3 != null) {
                    object = bl3;
                    bl2 = false;
                    bl = false;
                    it = (Boolean)object;
                    boolean bl4 = false;
                    Object object2 = this.getState();
                    Intrinsics.checkNotNull((Object)object2);
                    ((IWorkflowCameraView.State)object2).getFlash().onNext((Object)it);
                }
                Boolean bl5 = this.shutterSoundEnabledConfiguration;
                if (bl5 != null) {
                    object = bl5;
                    bl2 = false;
                    bl = false;
                    it = (Boolean)object;
                    boolean bl6 = false;
                    Object object3 = this.getState();
                    Intrinsics.checkNotNull((Object)object3);
                    ((IWorkflowCameraView.State)object3).getShutterSoundEnabled().onNext((Object)it);
                }
            }
            IWorkflowCameraView.State state = (IWorkflowCameraView.State)this.getState();
            if (state == null) break block3;
            object = state;
            bl2 = false;
            bl = false;
            Object state2 = object;
            boolean bl7 = false;
            this.subscriptions.add(((IWorkflowCameraView.State)state2).getCameraOpened().flatMap((Function)new Function<Signal, Publisher<? extends Boolean>>(this){
                final /* synthetic */ WorkflowCameraPresenter this$0;
                {
                    this.this$0 = workflowCameraPresenter;
                }

                public final Publisher<? extends Boolean> apply(@NotNull Signal it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    CheckCameraPermissionUseCase checkCameraPermissionUseCase = this.this$0.getCheckCameraPermissionUseCase();
                    return (Publisher)(checkCameraPermissionUseCase != null ? checkCameraPermissionUseCase.checkCameraPermission() : null);
                }
            }).subscribe((Consumer)new Consumer<Boolean>((IWorkflowCameraView.State)state2, this){
                final /* synthetic */ IWorkflowCameraView.State $state;
                final /* synthetic */ WorkflowCameraPresenter this$0;
                {
                    this.$state = state;
                    this.this$0 = workflowCameraPresenter;
                }

                public final void accept(Boolean cameraPermissionGranted) {
                    if (!cameraPermissionGranted.booleanValue()) {
                        WorkflowCameraPresenter.access$getNavigator$p(this.this$0).navigate((Object)"NAVIGATE_REQUEST_CAMERA_PERMISSION");
                    }
                    this.$state.getCameraPermissionGranted().onNext((Object)cameraPermissionGranted);
                }
            }));
            this.subscriptions.add(((IWorkflowCameraView.State)state2).getCameraPermissionGranted().filter((Predicate)resume.3.3.INSTANCE).subscribe((Consumer)new Consumer<Boolean>((IWorkflowCameraView.State)state2, this){
                final /* synthetic */ IWorkflowCameraView.State $state;
                final /* synthetic */ WorkflowCameraPresenter this$0;
                {
                    this.$state = state;
                    this.this$0 = workflowCameraPresenter;
                }

                public final void accept(Boolean it) {
                    WorkflowStepsCache workflowStepsCache = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0);
                    WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                    if (workflowStep == null) {
                        workflowStep = (WorkflowStep)CollectionsKt.first(this.this$0.getWorkflow$rtu_ui_bundle_release().getSteps());
                    }
                    workflowStepsCache.setCurrentStep(workflowStep);
                    this.$state.getCurrentStep().onNext((Object)WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep());
                }
            }));
            this.subscriptions.add(this.frameDataFlow.onBackpressureDrop().concatMap((Function)new Function<WorkflowFrameHandler.DetectedFrameData, Publisher<? extends Signal>>(this){
                final /* synthetic */ WorkflowCameraPresenter this$0;
                {
                    this.this$0 = workflowCameraPresenter;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Publisher<? extends Signal> apply(@NotNull WorkflowFrameHandler.DetectedFrameData data) {
                    Flowable flowable;
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    WorkflowStepResult workflowStepResult = data.getWorkflowStepResult();
                    Intrinsics.checkNotNull((Object)workflowStepResult);
                    WorkflowStep step = workflowStepResult.getStep();
                    if (step.getWantsVideoFramePage()) {
                        WorkflowStepResult workflowStepResult2 = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults().get(step);
                        if ((workflowStepResult2 != null ? workflowStepResult2.getVideoFramePage() : null) == null && !step.getWantsCapturedPage()) {
                            flowable = WorkflowCameraPresenter.access$saveCameraFrame(this.this$0, data).flatMap((Function)new Function<Page, Publisher<? extends Signal>>(this, step, data){
                                final /* synthetic */ resume$$inlined$let$lambda$4 this$0;
                                final /* synthetic */ WorkflowStep $step;
                                final /* synthetic */ WorkflowFrameHandler.DetectedFrameData $data;
                                {
                                    this.this$0 = var1_1;
                                    this.$step = workflowStep;
                                    this.$data = detectedFrameData;
                                }

                                public final Publisher<? extends Signal> apply(@NotNull Page it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    WorkflowCameraPresenter workflowCameraPresenter = this.this$0.this$0;
                                    WorkflowFrameHandler.DetectedFrameData detectedFrameData = this.$data;
                                    Intrinsics.checkNotNullExpressionValue((Object)detectedFrameData, (String)"data");
                                    return (Publisher)WorkflowCameraPresenter.access$saveDetectionResult(workflowCameraPresenter, this.$step, detectedFrameData, it);
                                }
                            });
                            return (Publisher)flowable;
                        }
                    }
                    flowable = WorkflowCameraPresenter.access$saveDetectionResult(this.this$0, step, data, null);
                    return (Publisher)flowable;
                }
            }).subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe((Consumer)resume.3.6.INSTANCE, (Consumer)new Consumer<Throwable>(this){
                final /* synthetic */ WorkflowCameraPresenter this$0;
                {
                    this.this$0 = workflowCameraPresenter;
                }

                public final void accept(Throwable error) {
                    WorkflowCameraPresenter.access$restartCurrentStep(this.this$0);
                    WorkflowCameraPresenter.access$getLogger$p(this.this$0).logException(error);
                }
            }));
            this.subscriptions.add(this.beepFlow.onBackpressureDrop().subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe((Consumer)new Consumer<Signal>(this){
                final /* synthetic */ WorkflowCameraPresenter this$0;
                {
                    this.this$0 = workflowCameraPresenter;
                }

                public final void accept(Signal it) {
                    WorkflowCameraPresenter.access$getNavigator$p(this.this$0).navigate((Object)"NAVIGATE_PLAY_BEEP");
                }
            }));
            ((IWorkflowCameraView.State)state2).getCameraOpened().onNext((Object)Signal.INSTANCE.signal());
        }
    }

    public void pause() {
        super.pause();
        PublishProcessor<Signal> publishProcessor = (PublishProcessor<Signal>)this.getState();
        if (publishProcessor != null && (publishProcessor = publishProcessor.getCameraClosed()) != null) {
            publishProcessor.onNext((Object)Signal.INSTANCE.signal());
        }
        this.subscriptions.clear();
        this.checkCameraPermissionUseCase = null;
    }

    @Override
    public void onCameraOpened() {
        block0: {
            BehaviorProcessor<Boolean> behaviorProcessor = (BehaviorProcessor<Boolean>)this.getState();
            if (behaviorProcessor == null || (behaviorProcessor = behaviorProcessor.getPictureProcessing()) == null) break block0;
            behaviorProcessor.onNext((Object)false);
        }
    }

    @Override
    public void onActivateCameraPermission() {
        this.navigator.navigate((Object)NAVIGATE_CAMERA_PERMISSION_SETTINGS);
    }

    @Override
    public void onCancelClicked() {
        if (this.cleanupOnCancel) {
            this.removeCachedPages();
        }
        this.subscriptions.clear();
        this.navigator.navigate((Object)NAVIGATE_CANCEL_SNAPPING);
    }

    private final void removeCachedPages() {
        boolean bl = false;
        List pages = new ArrayList();
        Map $this$forEach$iv = this.stepsCache.getStepResults();
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl2 = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Page page;
            Page page2;
            boolean bl3;
            boolean bl4;
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl5 = false;
            if (((WorkflowStepResult)it.getValue()).getCapturedPage() != null) {
                bl4 = false;
                bl3 = false;
                page = page2;
                boolean bl6 = false;
                pages.add(page);
            }
            if (((WorkflowStepResult)it.getValue()).getVideoFramePage() == null) continue;
            bl4 = false;
            bl3 = false;
            page = page2;
            boolean bl7 = false;
            pages.add(page);
        }
        this.removeDraftPageUseCase.removeDraftPages(pages).subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe((Action)removeCachedPages.2.INSTANCE, (Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            public final void accept(Throwable e) {
                WorkflowCameraPresenter.access$getLogger$p(this.this$0).logException(e);
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        });
    }

    @Override
    public void onLicenseInvalid() {
        this.subscriptions.clear();
        this.navigator.navigate((Object)NAVIGATE_CANCEL_LICENSE_INVALID);
    }

    @Override
    public void onFlashClicked() {
        block0: {
            IWorkflowCameraView.State state = (IWorkflowCameraView.State)this.getState();
            if (state == null) break block0;
            IWorkflowCameraView.State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            IWorkflowCameraView.State it = state2;
            boolean bl3 = false;
            it.getFlash().onNext((Object)((Boolean)it.getFlash().getValue() == false ? 1 : 0));
        }
    }

    @Override
    public void onNewDetectionResult(@NotNull WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)detectedFrameData, (String)"detectedFrameData");
            WorkflowStepResult workflowStepResult = detectedFrameData.getWorkflowStepResult();
            Intrinsics.checkNotNull((Object)workflowStepResult);
            WorkflowStep detectedFrameStep = workflowStepResult.getStep();
            WorkflowStep workflowStep = this.stepsCache.getCurrentStep();
            if (workflowStep == null) break block1;
            WorkflowStep workflowStep2 = workflowStep;
            boolean bl = false;
            boolean bl2 = false;
            WorkflowStep it = workflowStep2;
            boolean bl3 = false;
            workflowStep = Intrinsics.areEqual((Object)it, (Object)detectedFrameStep) ? workflowStep2 : null;
            if (workflowStep != null) {
                workflowStep2 = workflowStep;
                bl = false;
                bl2 = false;
                WorkflowStep $this$run = workflowStep2;
                boolean bl4 = false;
                this.validateStepResult(detectedFrameData);
            }
        }
    }

    @Override
    public void onErrorDialogClosed() {
        block0: {
            BehaviorProcessor<Boolean> behaviorProcessor = (BehaviorProcessor<Boolean>)this.getState();
            if (behaviorProcessor == null || (behaviorProcessor = behaviorProcessor.getErrorProcessing()) == null) break block0;
            behaviorProcessor.onNext((Object)false);
        }
    }

    private final Flowable<Signal> saveDetectionResult(WorkflowStep detectedFrameStep, WorkflowFrameHandler.DetectedFrameData detectedFrameData, Page framePage) {
        Flowable flowable = Flowable.create((FlowableOnSubscribe)((FlowableOnSubscribe)new FlowableOnSubscribe<Signal>(this, detectedFrameStep, detectedFrameData, framePage){
            final /* synthetic */ WorkflowCameraPresenter this$0;
            final /* synthetic */ WorkflowStep $detectedFrameStep;
            final /* synthetic */ WorkflowFrameHandler.DetectedFrameData $detectedFrameData;
            final /* synthetic */ Page $framePage;

            public final void subscribe(@NotNull FlowableEmitter<Signal> source) {
                WorkflowStepResult it;
                boolean bl;
                boolean bl2;
                WorkflowStepResult workflowStepResult;
                WorkflowStepResult workflowStepResult2;
                WorkflowStep workflowStep;
                Map map;
                block7: {
                    block6: {
                        Intrinsics.checkNotNullParameter(source, (String)"source");
                        ((Map)WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepFrameData()).put(this.$detectedFrameStep, new StepFrameData(this.$detectedFrameData));
                        WorkflowStepResult existingResult = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults().get(this.$detectedFrameStep);
                        if (existingResult == null && WorkflowCameraPresenter.access$isBeepableStep(this.this$0, this.$detectedFrameStep)) {
                            WorkflowCameraPresenter.access$getBeepFlow$p(this.this$0).onNext((Object)Signal.INSTANCE.signal());
                        }
                        map = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults();
                        workflowStep = this.$detectedFrameStep;
                        workflowStepResult2 = existingResult;
                        if (workflowStepResult2 == null) break block6;
                        workflowStepResult = workflowStepResult2;
                        bl2 = false;
                        bl = false;
                        WorkflowStepResult workflowStepResult3 = workflowStepResult;
                        WorkflowStep workflowStep2 = workflowStep;
                        Map map2 = map;
                        boolean bl3 = false;
                        WorkflowStepResult workflowStepResult4 = this.$detectedFrameData.getWorkflowStepResult();
                        Intrinsics.checkNotNull((Object)workflowStepResult4);
                        workflowStepResult4.setCapturedPage(it.getCapturedPage());
                        this.$detectedFrameData.getWorkflowStepResult().setVideoFramePage(it.getVideoFramePage());
                        WorkflowStepResult workflowStepResult5 = this.$detectedFrameData.getWorkflowStepResult();
                        map = map2;
                        workflowStep = workflowStep2;
                        workflowStepResult2 = workflowStepResult5;
                        if (workflowStepResult2 != null) break block7;
                    }
                    WorkflowStepResult workflowStepResult6 = this.$detectedFrameData.getWorkflowStepResult();
                    workflowStepResult2 = workflowStepResult6;
                    Intrinsics.checkNotNull((Object)workflowStepResult6);
                }
                map.put(workflowStep, workflowStepResult2);
                Page page = this.$framePage;
                if (page != null) {
                    workflowStepResult = page;
                    bl2 = false;
                    bl = false;
                    it = workflowStepResult;
                    boolean bl4 = false;
                    WorkflowStepResult workflowStepResult7 = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults().get(this.$detectedFrameStep);
                    Intrinsics.checkNotNull((Object)workflowStepResult7);
                    workflowStepResult7.setVideoFramePage((Page)it);
                }
                if (!this.$detectedFrameStep.getWantsCapturedPage()) {
                    WorkflowCameraPresenter.access$goToNextStepOrShowResult(this.this$0);
                }
                source.onNext((Object)Signal.INSTANCE.signal());
                source.onComplete();
            }
            {
                this.this$0 = workflowCameraPresenter;
                this.$detectedFrameStep = workflowStep;
                this.$detectedFrameData = detectedFrameData;
                this.$framePage = page;
            }
        }), (BackpressureStrategy)BackpressureStrategy.DROP);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"Flowable.create({ source\u2026ackpressureStrategy.DROP)");
        return flowable;
    }

    static /* synthetic */ Flowable saveDetectionResult$default(WorkflowCameraPresenter workflowCameraPresenter, WorkflowStep workflowStep, WorkflowFrameHandler.DetectedFrameData detectedFrameData, Page page, int n, Object object) {
        if ((n & 4) != 0) {
            page = null;
        }
        return workflowCameraPresenter.saveDetectionResult(workflowStep, detectedFrameData, page);
    }

    private final boolean isBeepableStep(WorkflowStep detectedFrameStep) {
        WorkflowStep workflowStep;
        return !detectedFrameStep.getWantsCapturedPage() && ((workflowStep = detectedFrameStep) instanceof ScanMachineReadableZoneWorkflowStep ? true : (workflowStep instanceof ScanPayFormWorkflowStep ? true : (workflowStep instanceof ScanDisabilityCertificateWorkflowStep ? true : workflowStep instanceof ScanBarCodeWorkflowStep)));
    }

    private final Flowable<Page> saveCameraFrame(WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
        byte[] byArray = detectedFrameData.getFrame();
        int n = detectedFrameData.getFrameOrientation();
        int n2 = detectedFrameData.getFrameWidth();
        int n3 = detectedFrameData.getFrameHeight();
        WorkflowStepResult workflowStepResult = detectedFrameData.getWorkflowStepResult();
        Intrinsics.checkNotNull((Object)workflowStepResult);
        List<PageAspectRatio> list = workflowStepResult.getStep().getRequiredAspectRatios();
        RectF rectF = detectedFrameData.getRectOfInterest();
        if (rectF == null) {
            rectF = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
        }
        return this.saveCameraFrameUseCase.saveCameraFrame(byArray, n, n2, n3, this.imageScale, list, rectF, this.documentImageSizeLimit);
    }

    private final void validateStepResult(WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
        WorkflowStepError validationError;
        WorkflowStepError workflowStepError;
        WorkflowStepResult workflowStepResult = detectedFrameData.getWorkflowStepResult();
        Intrinsics.checkNotNull((Object)workflowStepResult);
        WorkflowStep workflowStep = workflowStepResult.getStep();
        if (workflowStep instanceof ScanDocumentPageWorkflowStep) {
            if (detectedFrameData.getDetectionResult() == DetectionResult.OK) {
                this.frameDataFlow.onNext((Object)detectedFrameData);
            }
        } else if (detectedFrameData.getWorkflowStepResult().getStep().getWantsCapturedPage() && detectedFrameData.getDetectionResult() == DetectionResult.OK) {
            this.frameDataFlow.onNext((Object)detectedFrameData);
        } else if (!detectedFrameData.getWorkflowStepResult().getStep().getWantsCapturedPage() && (workflowStepError = (validationError = detectedFrameData.getWorkflowStepResult().getStep().getWorkflowStepValidation().invoke(detectedFrameData.getWorkflowStepResult()))) == null) {
            this.frameDataFlow.onNext((Object)detectedFrameData);
            workflowStepError = Unit.INSTANCE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void pageSnapped(@NotNull byte[] image, @NotNull CaptureInfo captureInfo) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)captureInfo, (String)"captureInfo");
        WorkflowStep workflowStep = this.stepsCache.getCurrentStep();
        if (workflowStep != null) {
            if (workflowStep.getWantsCapturedPage()) {
                this.storePageInDraftRepository(image, captureInfo);
                return;
            }
        }
        this.goToNextStepOrShowResult();
    }

    @Override
    public void cameraPermissionGranted() {
        block0: {
            BehaviorProcessor<Boolean> behaviorProcessor = (BehaviorProcessor<Boolean>)this.getState();
            if (behaviorProcessor == null || (behaviorProcessor = behaviorProcessor.getCameraPermissionGranted()) == null) break block0;
            behaviorProcessor.onNext((Object)true);
        }
    }

    @Override
    public void cameraPermissionDenied() {
        block0: {
            BehaviorProcessor<Boolean> behaviorProcessor = (BehaviorProcessor<Boolean>)this.getState();
            if (behaviorProcessor == null || (behaviorProcessor = behaviorProcessor.getCameraPermissionGranted()) == null) break block0;
            behaviorProcessor.onNext((Object)false);
        }
    }

    private final void storePageInDraftRepository(byte[] image, CaptureInfo captureInfo) {
        block1: {
            IWorkflowCameraView.State state = (IWorkflowCameraView.State)this.getState();
            if (state == null) break block1;
            IWorkflowCameraView.State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            IWorkflowCameraView.State state3 = state2;
            boolean bl3 = false;
            state3.getPictureProcessing().onNext((Object)true);
            Disposable disposable = this.saveTakenPictureSubscription;
            if (disposable != null) {
                disposable.dispose();
            }
            this.saveTakenPictureSubscription = this.detectOrSkip(image, captureInfo).flatMap((Function)new Function<WorkflowStepResult, SingleSource<? extends Page>>(this, image, captureInfo){
                final /* synthetic */ WorkflowCameraPresenter this$0;
                final /* synthetic */ byte[] $image$inlined;
                final /* synthetic */ CaptureInfo $captureInfo$inlined;
                {
                    this.this$0 = workflowCameraPresenter;
                    this.$image$inlined = byArray;
                    this.$captureInfo$inlined = captureInfo;
                }

                public final SingleSource<? extends Page> apply(@NotNull WorkflowStepResult it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    WorkflowStepResult workflowStepResult = it;
                    boolean bl = false;
                    boolean bl2 = false;
                    WorkflowStepResult it2 = workflowStepResult;
                    boolean bl3 = false;
                    WorkflowStepResult existingResult = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).currentStepResult();
                    if (existingResult == null) {
                        Map map = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults();
                        WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                        Intrinsics.checkNotNull((Object)workflowStep);
                        map.put(workflowStep, it2);
                    } else {
                        WorkflowStepResult mergedResult = it2;
                        mergedResult.setCapturedPage(existingResult.getCapturedPage());
                        mergedResult.setVideoFramePage(existingResult.getVideoFramePage());
                        Map map = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults();
                        WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                        Intrinsics.checkNotNull((Object)workflowStep);
                        map.put(workflowStep, mergedResult);
                    }
                    SaveTakenPictureUseCase saveTakenPictureUseCase = WorkflowCameraPresenter.access$getSaveTakenPictureUseCase$p(this.this$0);
                    float f = WorkflowCameraPresenter.access$getImageScale$p(this.this$0);
                    WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                    Intrinsics.checkNotNull((Object)workflowStep);
                    List<PageAspectRatio> list = workflowStep.getRequiredAspectRatios();
                    StepFrameData stepFrameData = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).currentStepFrameData();
                    if (stepFrameData == null || (stepFrameData = stepFrameData.getRectOfInterest()) == null) {
                        stepFrameData = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
                    }
                    return (SingleSource)saveTakenPictureUseCase.saveTakenPicture(this.$image$inlined, this.$captureInfo$inlined, f, list, (RectF)stepFrameData, WorkflowCameraPresenter.access$getDocumentImageSizeLimit$p(this.this$0));
                }
            }).subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe((Consumer)new Consumer<Page>(state3, this, image, captureInfo){
                final /* synthetic */ IWorkflowCameraView.State $state;
                final /* synthetic */ WorkflowCameraPresenter this$0;
                final /* synthetic */ byte[] $image$inlined;
                final /* synthetic */ CaptureInfo $captureInfo$inlined;
                {
                    this.$state = state;
                    this.this$0 = workflowCameraPresenter;
                    this.$image$inlined = byArray;
                    this.$captureInfo$inlined = captureInfo;
                }

                public final void accept(Page it) {
                    WorkflowStepResult existingResult = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).currentStepResult();
                    if (existingResult == null) {
                        Map map = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults();
                        WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                        Intrinsics.checkNotNull((Object)workflowStep);
                        WorkflowStep workflowStep2 = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                        Intrinsics.checkNotNull((Object)workflowStep2);
                        map.put(workflowStep, new BasicWorkflowStepResult(workflowStep2, it, null, 4, null));
                    } else {
                        existingResult.setCapturedPage(it);
                        Map map = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults();
                        WorkflowStep workflowStep = WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getCurrentStep();
                        Intrinsics.checkNotNull((Object)workflowStep);
                        map.put(workflowStep, existingResult);
                    }
                    this.$state.getPictureProcessing().onNext((Object)false);
                    WorkflowCameraPresenter.access$goToNextStepOrShowResult(this.this$0);
                }
            }, (Consumer)new Consumer<Throwable>(state3, this, image, captureInfo){
                final /* synthetic */ IWorkflowCameraView.State $state;
                final /* synthetic */ WorkflowCameraPresenter this$0;
                final /* synthetic */ byte[] $image$inlined;
                final /* synthetic */ CaptureInfo $captureInfo$inlined;
                {
                    this.$state = state;
                    this.this$0 = workflowCameraPresenter;
                    this.$image$inlined = byArray;
                    this.$captureInfo$inlined = captureInfo;
                }

                public final void accept(Throwable error) {
                    if (error instanceof WorkflowDetectionUseCase.InvalidDetectionResult) {
                        this.$state.getErrorProcessing().onNext((Object)true);
                        if (((WorkflowDetectionUseCase.InvalidDetectionResult)error).getWorkflowStepError().getShowMode() == WorkflowStepError.ShowMode.TOAST) {
                            WorkflowCameraPresenter.access$disableErrorProcessingWithDelay(this.this$0);
                        }
                        this.$state.getWorkflowStepError().onNext((Object)((WorkflowDetectionUseCase.InvalidDetectionResult)error).getWorkflowStepError());
                    }
                    WorkflowCameraPresenter.access$restartCurrentStep(this.this$0);
                    WorkflowCameraPresenter.access$getLogger$p(this.this$0).logException(error);
                }
            });
        }
    }

    private final void disableErrorProcessingWithDelay() {
        this.subscriptions.add(Flowable.timer((long)2L, (TimeUnit)TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Long>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            public final void accept(Long it) {
                block0: {
                    BehaviorProcessor<Boolean> behaviorProcessor = WorkflowCameraPresenter.access$getState$p(this.this$0);
                    if (behaviorProcessor == null || (behaviorProcessor = behaviorProcessor.getErrorProcessing()) == null) break block0;
                    behaviorProcessor.onNext((Object)false);
                }
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        }));
    }

    private final Single<? extends WorkflowStepResult> detectOrSkip(byte[] image, CaptureInfo captureInfo) {
        Single<WorkflowStepResult> single;
        WorkflowStep workflowStep = this.stepsCache.getCurrentStep();
        Intrinsics.checkNotNull((Object)workflowStep);
        if (workflowStep.getWantsCapturedPage()) {
            WorkflowStep workflowStep2 = this.stepsCache.getCurrentStep();
            Intrinsics.checkNotNull((Object)workflowStep2);
            single = this.workflowDetectionUseCase.detect(workflowStep2, image, captureInfo, this.calculateFinderRectF());
        } else {
            single = Single.just((Object)this.stepsCache.currentStepResult());
        }
        return single;
    }

    private final void restartCurrentStep() {
        block4: {
            BehaviorProcessor<Boolean> behaviorProcessor = (BehaviorProcessor<Boolean>)this.getState();
            if (behaviorProcessor != null && (behaviorProcessor = behaviorProcessor.getPictureProcessing()) != null) {
                behaviorProcessor.onNext((Object)false);
            }
            WorkflowStepResult workflowStepResult = this.stepsCache.currentStepResult();
            if (workflowStepResult != null) {
                Page it;
                boolean bl;
                boolean bl2;
                Page page;
                WorkflowStepResult workflowStepResult2 = workflowStepResult;
                boolean bl3 = false;
                boolean bl4 = false;
                WorkflowStepResult result = workflowStepResult2;
                boolean bl5 = false;
                Page page2 = result.getVideoFramePage();
                if (page2 != null) {
                    page = page2;
                    bl2 = false;
                    bl = false;
                    it = page;
                    boolean bl6 = false;
                    this.removeDraftPageUseCase.removeDraftPage(it).subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe((Action)restartCurrentStep.1.1.1.INSTANCE, (Consumer)new Consumer<Throwable>(this){
                        final /* synthetic */ WorkflowCameraPresenter this$0;
                        {
                            this.this$0 = workflowCameraPresenter;
                        }

                        public final void accept(Throwable e) {
                            WorkflowCameraPresenter.access$getLogger$p(this.this$0).logException(e);
                        }
                    });
                }
                Page page3 = result.getCapturedPage();
                if (page3 != null) {
                    page = page3;
                    bl2 = false;
                    bl = false;
                    it = page;
                    boolean bl7 = false;
                    this.removeDraftPageUseCase.removeDraftPage(it).subscribeOn(this.backgroundTaskScheduler).observeOn(this.uiScheduler).subscribe((Action)restartCurrentStep.1.2.1.INSTANCE, (Consumer)new Consumer<Throwable>(this){
                        final /* synthetic */ WorkflowCameraPresenter this$0;
                        {
                            this.this$0 = workflowCameraPresenter;
                        }

                        public final void accept(Throwable e) {
                            WorkflowCameraPresenter.access$getLogger$p(this.this$0).logException(e);
                        }
                    });
                }
            }
            HashMap<WorkflowStep, WorkflowStepResult> hashMap = this.stepsCache.getStepResults();
            WorkflowStep workflowStep = this.stepsCache.getCurrentStep();
            Intrinsics.checkNotNull((Object)workflowStep);
            hashMap.remove(workflowStep);
            HashMap<WorkflowStep, StepFrameData> hashMap2 = this.stepsCache.getStepFrameData();
            WorkflowStep workflowStep2 = this.stepsCache.getCurrentStep();
            Intrinsics.checkNotNull((Object)workflowStep2);
            hashMap2.remove(workflowStep2);
            BehaviorProcessor<WorkflowStep> behaviorProcessor2 = (BehaviorProcessor<WorkflowStep>)this.getState();
            if (behaviorProcessor2 == null || (behaviorProcessor2 = behaviorProcessor2.getCurrentStep()) == null) break block4;
            behaviorProcessor2.onNext((Object)this.stepsCache.getCurrentStep());
        }
    }

    private final RectF calculateFinderRectF() {
        RectF rectF;
        StepFrameData frameData = this.stepsCache.currentStepFrameData();
        StepFrameData stepFrameData = frameData;
        if (stepFrameData != null && (stepFrameData = stepFrameData.getFinderRect()) != null) {
            StepFrameData stepFrameData2 = stepFrameData;
            boolean bl = false;
            boolean bl2 = false;
            StepFrameData it = stepFrameData2;
            boolean bl3 = false;
            int frameWidth = frameData.getFrameWidth();
            int frameHeight = frameData.getFrameHeight();
            int frameOrientation = frameData.getFrameOrientation();
            int rotatedFrameWidth = frameWidth;
            int rotatedFrameHeight = frameHeight;
            if (frameOrientation % 180 != 0) {
                rotatedFrameWidth = frameHeight;
                rotatedFrameHeight = frameWidth;
            }
            rectF = new RectF((float)((Rect)it).left / (float)rotatedFrameWidth, (float)((Rect)it).top / (float)rotatedFrameHeight, (float)((Rect)it).right / (float)rotatedFrameWidth, (float)((Rect)it).bottom / (float)rotatedFrameHeight);
        } else {
            rectF = null;
        }
        return rectF;
    }

    private final void goToNextStepOrShowResult() {
        WorkflowStep workflowStep = this.stepsCache.getCurrentStep();
        boolean bl = false;
        boolean bl2 = false;
        WorkflowStep it = workflowStep;
        boolean bl3 = false;
        int currentStateIndex = CollectionsKt.indexOf(this.workflow.getSteps(), (Object)it);
        if (currentStateIndex != CollectionsKt.getLastIndex(this.workflow.getSteps())) {
            this.stepsCache.setCurrentStep(this.workflow.getSteps().get(currentStateIndex + 1));
            BehaviorProcessor<WorkflowStep> behaviorProcessor = (BehaviorProcessor<WorkflowStep>)this.getState();
            if (behaviorProcessor != null && (behaviorProcessor = behaviorProcessor.getCurrentStep()) != null) {
                behaviorProcessor.onNext((Object)this.stepsCache.getCurrentStep());
            }
        } else {
            this.finalizePagesAndShowResult();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void finalizePagesAndShowResult() {
        void $this$mapNotNullTo$iv$iv;
        this.subscriptions.clear();
        ArrayList<Page> pagesToFinalize = new ArrayList<Page>();
        Iterable $this$mapNotNull$iv = this.workflow.getSteps();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WorkflowStepResult workflowStepResult;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            WorkflowStep it = (WorkflowStep)element$iv$iv;
            boolean bl2 = false;
            if (this.stepsCache.getStepResults().get(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            WorkflowStepResult it$iv$iv = workflowStepResult;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Page page;
            Page page2;
            boolean bl;
            WorkflowStepResult it = (WorkflowStepResult)element$iv;
            boolean bl6 = false;
            if (it.getCapturedPage() != null) {
                Page page3;
                boolean bl7 = false;
                bl = false;
                page2 = page3;
                boolean bl8 = false;
                pagesToFinalize.add(page2);
            }
            if (it.getVideoFramePage() == null) continue;
            boolean bl9 = false;
            bl = false;
            page2 = page;
            boolean bl10 = false;
            pagesToFinalize.add(page2);
        }
        this.finalizePagesUseCase.finalizePages((List<Page>)pagesToFinalize).subscribe(new Action(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                WorkflowStep it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = this.this$0.getWorkflow$rtu_ui_bundle_release().getSteps();
                Workflow workflow = this.this$0.getWorkflow$rtu_ui_bundle_release();
                Navigator navigator = WorkflowCameraPresenter.access$getNavigator$p(this.this$0);
                boolean $i$f$filter = false;
                void var3_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (WorkflowStep)element$iv$iv;
                    boolean bl = false;
                    if (!(WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults().get(it) != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection<WorkflowStepResult> collection = (List)destination$iv$iv;
                $this$filter$iv = collection;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    WorkflowStepResult workflowStepResult;
                    it = (WorkflowStep)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)WorkflowCameraPresenter.access$getStepsCache$p(this.this$0).getStepResults().get(it));
                    Intrinsics.checkNotNullExpressionValue((Object)workflowStepResult, (String)"stepsCache.stepResults[it]!!");
                    collection.add(workflowStepResult);
                }
                collection = (List)destination$iv$iv;
                List list = collection;
                Workflow workflow2 = workflow;
                navigator.navigate((Object)new FinishWorkflow(workflow2, list));
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        }, (Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ WorkflowCameraPresenter this$0;

            public final void accept(Throwable it) {
                WorkflowCameraPresenter.access$getLogger$p(this.this$0).logException(it);
                if (WorkflowCameraPresenter.access$getCleanupOnCancel$p(this.this$0)) {
                    WorkflowCameraPresenter.access$removeCachedPages(this.this$0);
                }
                WorkflowCameraPresenter.access$getNavigator$p(this.this$0).navigate((Object)"NAVIGATE_CANCEL_SNAPPING");
            }
            {
                this.this$0 = workflowCameraPresenter;
            }
        });
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        this.flashConfiguration = flashEnabled;
    }

    public final void setShutterSoundEnabled(boolean shutterSoundEnabled) {
        this.shutterSoundEnabledConfiguration = shutterSoundEnabled;
    }

    public final void setImageScale(float imageScale) {
        this.imageScale = imageScale;
    }

    public final void setDocumentImageSizeLimit(@NotNull PageStorageProcessor.Configuration.Size documentImageSizeLimit) {
        Intrinsics.checkNotNullParameter((Object)documentImageSizeLimit, (String)"documentImageSizeLimit");
        this.documentImageSizeLimit = documentImageSizeLimit;
    }

    public final void setCleanupOnCancel(boolean cleanupOnCancel) {
        this.cleanupOnCancel = cleanupOnCancel;
    }

    @Nullable
    public final CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return this.checkCameraPermissionUseCase;
    }

    public final void setCheckCameraPermissionUseCase(@Nullable CheckCameraPermissionUseCase checkCameraPermissionUseCase) {
        this.checkCameraPermissionUseCase = checkCameraPermissionUseCase;
    }

    @Inject
    public WorkflowCameraPresenter(@Nullable CheckCameraPermissionUseCase checkCameraPermissionUseCase, @NotNull SaveTakenPictureUseCase saveTakenPictureUseCase, @NotNull SaveCameraFrameUseCase saveCameraFrameUseCase, @NotNull WorkflowDetectionUseCase workflowDetectionUseCase, @NotNull RemoveDraftPageUseCase removeDraftPageUseCase, @NotNull FinalizePagesUseCase finalizePagesUseCase, @NotNull Navigator navigator, @BackgroundTaskScheduler @NotNull Scheduler backgroundTaskScheduler, @UiScheduler @NotNull Scheduler uiScheduler) {
        Intrinsics.checkNotNullParameter((Object)saveTakenPictureUseCase, (String)"saveTakenPictureUseCase");
        Intrinsics.checkNotNullParameter((Object)saveCameraFrameUseCase, (String)"saveCameraFrameUseCase");
        Intrinsics.checkNotNullParameter((Object)workflowDetectionUseCase, (String)"workflowDetectionUseCase");
        Intrinsics.checkNotNullParameter((Object)removeDraftPageUseCase, (String)"removeDraftPageUseCase");
        Intrinsics.checkNotNullParameter((Object)finalizePagesUseCase, (String)"finalizePagesUseCase");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskScheduler, (String)"backgroundTaskScheduler");
        Intrinsics.checkNotNullParameter((Object)uiScheduler, (String)"uiScheduler");
        this.checkCameraPermissionUseCase = checkCameraPermissionUseCase;
        this.saveTakenPictureUseCase = saveTakenPictureUseCase;
        this.saveCameraFrameUseCase = saveCameraFrameUseCase;
        this.workflowDetectionUseCase = workflowDetectionUseCase;
        this.removeDraftPageUseCase = removeDraftPageUseCase;
        this.finalizePagesUseCase = finalizePagesUseCase;
        this.navigator = navigator;
        this.backgroundTaskScheduler = backgroundTaskScheduler;
        this.uiScheduler = uiScheduler;
        this.subscriptions = new CompositeDisposable();
        this.workflow = new Workflow(null, null, 3, null);
        this.stepsCache = new WorkflowStepsCache(null, null, null, 7, null);
        this.frameDataFlow = PublishProcessor.create();
        this.beepFlow = PublishProcessor.create();
        this.imageScale = 1.0f;
        this.cleanupOnCancel = true;
        this.documentImageSizeLimit = PageStorageProcessor.Configuration.Companion.DEFAULT().getDocumentImageSizeLimit();
        this.logger = LoggerProvider.getLogger();
    }

    public static final /* synthetic */ Navigator access$getNavigator$p(WorkflowCameraPresenter $this) {
        return $this.navigator;
    }

    public static final /* synthetic */ WorkflowStepsCache access$getStepsCache$p(WorkflowCameraPresenter $this) {
        return $this.stepsCache;
    }

    public static final /* synthetic */ Flowable access$saveCameraFrame(WorkflowCameraPresenter $this, WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
        return $this.saveCameraFrame(detectedFrameData);
    }

    public static final /* synthetic */ Flowable access$saveDetectionResult(WorkflowCameraPresenter $this, WorkflowStep detectedFrameStep, WorkflowFrameHandler.DetectedFrameData detectedFrameData, Page framePage) {
        return $this.saveDetectionResult(detectedFrameStep, detectedFrameData, framePage);
    }

    public static final /* synthetic */ void access$restartCurrentStep(WorkflowCameraPresenter $this) {
        $this.restartCurrentStep();
    }

    public static final /* synthetic */ Logger access$getLogger$p(WorkflowCameraPresenter $this) {
        return $this.logger;
    }

    public static final /* synthetic */ boolean access$isBeepableStep(WorkflowCameraPresenter $this, WorkflowStep detectedFrameStep) {
        return $this.isBeepableStep(detectedFrameStep);
    }

    public static final /* synthetic */ PublishProcessor access$getBeepFlow$p(WorkflowCameraPresenter $this) {
        return $this.beepFlow;
    }

    public static final /* synthetic */ void access$goToNextStepOrShowResult(WorkflowCameraPresenter $this) {
        $this.goToNextStepOrShowResult();
    }

    public static final /* synthetic */ SaveTakenPictureUseCase access$getSaveTakenPictureUseCase$p(WorkflowCameraPresenter $this) {
        return $this.saveTakenPictureUseCase;
    }

    public static final /* synthetic */ float access$getImageScale$p(WorkflowCameraPresenter $this) {
        return $this.imageScale;
    }

    public static final /* synthetic */ void access$setImageScale$p(WorkflowCameraPresenter $this, float f) {
        $this.imageScale = f;
    }

    public static final /* synthetic */ PageStorageProcessor.Configuration.Size access$getDocumentImageSizeLimit$p(WorkflowCameraPresenter $this) {
        return $this.documentImageSizeLimit;
    }

    public static final /* synthetic */ void access$setDocumentImageSizeLimit$p(WorkflowCameraPresenter $this, PageStorageProcessor.Configuration.Size size) {
        $this.documentImageSizeLimit = size;
    }

    public static final /* synthetic */ void access$disableErrorProcessingWithDelay(WorkflowCameraPresenter $this) {
        $this.disableErrorProcessingWithDelay();
    }

    public static final /* synthetic */ IWorkflowCameraView.State access$getState$p(WorkflowCameraPresenter $this) {
        return (IWorkflowCameraView.State)$this.getState();
    }

    public static final /* synthetic */ void access$setState$p(WorkflowCameraPresenter $this, IWorkflowCameraView.State state) {
        $this.setState(state);
    }

    public static final /* synthetic */ boolean access$getCleanupOnCancel$p(WorkflowCameraPresenter $this) {
        return $this.cleanupOnCancel;
    }

    public static final /* synthetic */ void access$setCleanupOnCancel$p(WorkflowCameraPresenter $this, boolean bl) {
        $this.cleanupOnCancel = bl;
    }

    public static final /* synthetic */ void access$removeCachedPages(WorkflowCameraPresenter $this) {
        $this.removeCachedPages();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$FinishWorkflow;", "", "workflow", "Lio/scanbot/sdk/ui/entity/workflow/Workflow;", "workflowResults", "", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "(Lio/scanbot/sdk/ui/entity/workflow/Workflow;Ljava/util/List;)V", "getWorkflow", "()Lio/scanbot/sdk/ui/entity/workflow/Workflow;", "getWorkflowResults", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "rtu-ui-bundle_release"})
    public static final class FinishWorkflow {
        @NotNull
        private final Workflow workflow;
        @NotNull
        private final List<WorkflowStepResult> workflowResults;

        @NotNull
        public final Workflow getWorkflow() {
            return this.workflow;
        }

        @NotNull
        public final List<WorkflowStepResult> getWorkflowResults() {
            return this.workflowResults;
        }

        public FinishWorkflow(@NotNull Workflow workflow, @NotNull List<? extends WorkflowStepResult> workflowResults) {
            Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
            Intrinsics.checkNotNullParameter(workflowResults, (String)"workflowResults");
            this.workflow = workflow;
            this.workflowResults = workflowResults;
        }

        @NotNull
        public final Workflow component1() {
            return this.workflow;
        }

        @NotNull
        public final List<WorkflowStepResult> component2() {
            return this.workflowResults;
        }

        @NotNull
        public final FinishWorkflow copy(@NotNull Workflow workflow, @NotNull List<? extends WorkflowStepResult> workflowResults) {
            Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
            Intrinsics.checkNotNullParameter(workflowResults, (String)"workflowResults");
            return new FinishWorkflow(workflow, workflowResults);
        }

        public static /* synthetic */ FinishWorkflow copy$default(FinishWorkflow finishWorkflow2, Workflow workflow, List list, int n, Object object) {
            if ((n & 1) != 0) {
                workflow = finishWorkflow2.workflow;
            }
            if ((n & 2) != 0) {
                list = finishWorkflow2.workflowResults;
            }
            return finishWorkflow2.copy(workflow, list);
        }

        @NotNull
        public String toString() {
            return "FinishWorkflow(workflow=" + this.workflow + ", workflowResults=" + this.workflowResults + ")";
        }

        public int hashCode() {
            Workflow workflow = this.workflow;
            List<WorkflowStepResult> list = this.workflowResults;
            return (workflow != null ? ((Object)workflow).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FinishWorkflow)) break block3;
                    FinishWorkflow finishWorkflow2 = (FinishWorkflow)object;
                    if (!Intrinsics.areEqual((Object)this.workflow, (Object)finishWorkflow2.workflow) || !Intrinsics.areEqual(this.workflowResults, finishWorkflow2.workflowResults)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B]\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012$\b\u0002\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006`\u0007\u0012$\b\u0002\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t`\u0007\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J%\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006`\u0007H\u00c6\u0003J%\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t`\u0007H\u00c6\u0003Ja\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032$\b\u0002\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006`\u00072$\b\u0002\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t`\u0007H\u00c6\u0001J\b\u0010\u0016\u001a\u0004\u0018\u00010\tJ\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$WorkflowStepsCache;", "", "currentStep", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "stepResults", "Ljava/util/HashMap;", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "Lkotlin/collections/HashMap;", "stepFrameData", "Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$StepFrameData;", "(Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;Ljava/util/HashMap;Ljava/util/HashMap;)V", "getCurrentStep", "()Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "setCurrentStep", "(Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;)V", "getStepFrameData", "()Ljava/util/HashMap;", "getStepResults", "component1", "component2", "component3", "copy", "currentStepFrameData", "currentStepResult", "equals", "", "other", "hashCode", "", "toString", "", "rtu-ui-bundle_release"})
    private static final class WorkflowStepsCache {
        @Nullable
        private WorkflowStep currentStep;
        @NotNull
        private final HashMap<WorkflowStep, WorkflowStepResult> stepResults;
        @NotNull
        private final HashMap<WorkflowStep, StepFrameData> stepFrameData;

        @Nullable
        public final WorkflowStepResult currentStepResult() {
            Map map = this.stepResults;
            WorkflowStep workflowStep = this.currentStep;
            boolean bl = false;
            return (WorkflowStepResult)map.get(workflowStep);
        }

        @Nullable
        public final StepFrameData currentStepFrameData() {
            Map map = this.stepFrameData;
            WorkflowStep workflowStep = this.currentStep;
            boolean bl = false;
            return (StepFrameData)map.get(workflowStep);
        }

        @Nullable
        public final WorkflowStep getCurrentStep() {
            return this.currentStep;
        }

        public final void setCurrentStep(@Nullable WorkflowStep workflowStep) {
            this.currentStep = workflowStep;
        }

        @NotNull
        public final HashMap<WorkflowStep, WorkflowStepResult> getStepResults() {
            return this.stepResults;
        }

        @NotNull
        public final HashMap<WorkflowStep, StepFrameData> getStepFrameData() {
            return this.stepFrameData;
        }

        public WorkflowStepsCache(@Nullable WorkflowStep currentStep, @NotNull HashMap<WorkflowStep, WorkflowStepResult> stepResults, @NotNull HashMap<WorkflowStep, StepFrameData> stepFrameData) {
            Intrinsics.checkNotNullParameter(stepResults, (String)"stepResults");
            Intrinsics.checkNotNullParameter(stepFrameData, (String)"stepFrameData");
            this.currentStep = currentStep;
            this.stepResults = stepResults;
            this.stepFrameData = stepFrameData;
        }

        public /* synthetic */ WorkflowStepsCache(WorkflowStep workflowStep, HashMap hashMap, HashMap hashMap2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            boolean bl;
            if ((n & 1) != 0) {
                workflowStep = null;
            }
            if ((n & 2) != 0) {
                bl = false;
                hashMap = new HashMap<WorkflowStep, WorkflowStepResult>();
            }
            if ((n & 4) != 0) {
                bl = false;
                hashMap2 = new HashMap();
            }
            this(workflowStep, hashMap, hashMap2);
        }

        public WorkflowStepsCache() {
            this(null, null, null, 7, null);
        }

        @Nullable
        public final WorkflowStep component1() {
            return this.currentStep;
        }

        @NotNull
        public final HashMap<WorkflowStep, WorkflowStepResult> component2() {
            return this.stepResults;
        }

        @NotNull
        public final HashMap<WorkflowStep, StepFrameData> component3() {
            return this.stepFrameData;
        }

        @NotNull
        public final WorkflowStepsCache copy(@Nullable WorkflowStep currentStep, @NotNull HashMap<WorkflowStep, WorkflowStepResult> stepResults, @NotNull HashMap<WorkflowStep, StepFrameData> stepFrameData) {
            Intrinsics.checkNotNullParameter(stepResults, (String)"stepResults");
            Intrinsics.checkNotNullParameter(stepFrameData, (String)"stepFrameData");
            return new WorkflowStepsCache(currentStep, stepResults, stepFrameData);
        }

        public static /* synthetic */ WorkflowStepsCache copy$default(WorkflowStepsCache workflowStepsCache, WorkflowStep workflowStep, HashMap hashMap, HashMap hashMap2, int n, Object object) {
            if ((n & 1) != 0) {
                workflowStep = workflowStepsCache.currentStep;
            }
            if ((n & 2) != 0) {
                hashMap = workflowStepsCache.stepResults;
            }
            if ((n & 4) != 0) {
                hashMap2 = workflowStepsCache.stepFrameData;
            }
            return workflowStepsCache.copy(workflowStep, hashMap, hashMap2);
        }

        @NotNull
        public String toString() {
            return "WorkflowStepsCache(currentStep=" + this.currentStep + ", stepResults=" + this.stepResults + ", stepFrameData=" + this.stepFrameData + ")";
        }

        public int hashCode() {
            WorkflowStep workflowStep = this.currentStep;
            HashMap<WorkflowStep, WorkflowStepResult> hashMap = this.stepResults;
            HashMap<WorkflowStep, StepFrameData> hashMap2 = this.stepFrameData;
            return ((workflowStep != null ? workflowStep.hashCode() : 0) * 31 + (hashMap != null ? ((Object)hashMap).hashCode() : 0)) * 31 + (hashMap2 != null ? ((Object)hashMap2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof WorkflowStepsCache)) break block3;
                    WorkflowStepsCache workflowStepsCache = (WorkflowStepsCache)object;
                    if (!Intrinsics.areEqual((Object)this.currentStep, (Object)workflowStepsCache.currentStep) || !Intrinsics.areEqual(this.stepResults, workflowStepsCache.stepResults) || !Intrinsics.areEqual(this.stepFrameData, workflowStepsCache.stepFrameData)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B;\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u00c6\u0003J?\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$StepFrameData;", "", "detectedFrameData", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "(Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;)V", "frameOrientation", "", "frameWidth", "frameHeight", "finderRect", "Landroid/graphics/Rect;", "rectOfInterest", "Landroid/graphics/RectF;", "(IIILandroid/graphics/Rect;Landroid/graphics/RectF;)V", "getFinderRect", "()Landroid/graphics/Rect;", "getFrameHeight", "()I", "getFrameOrientation", "getFrameWidth", "getRectOfInterest", "()Landroid/graphics/RectF;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "rtu-ui-bundle_release"})
    private static final class StepFrameData {
        private final int frameOrientation;
        private final int frameWidth;
        private final int frameHeight;
        @Nullable
        private final Rect finderRect;
        @Nullable
        private final RectF rectOfInterest;

        public final int getFrameOrientation() {
            return this.frameOrientation;
        }

        public final int getFrameWidth() {
            return this.frameWidth;
        }

        public final int getFrameHeight() {
            return this.frameHeight;
        }

        @Nullable
        public final Rect getFinderRect() {
            return this.finderRect;
        }

        @Nullable
        public final RectF getRectOfInterest() {
            return this.rectOfInterest;
        }

        public StepFrameData(int frameOrientation, int frameWidth, int frameHeight, @Nullable Rect finderRect, @Nullable RectF rectOfInterest) {
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.finderRect = finderRect;
            this.rectOfInterest = rectOfInterest;
        }

        public /* synthetic */ StepFrameData(int n, int n2, int n3, Rect rect, RectF rectF, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            if ((n4 & 8) != 0) {
                rect = null;
            }
            if ((n4 & 0x10) != 0) {
                rectF = null;
            }
            this(n, n2, n3, rect, rectF);
        }

        public StepFrameData() {
            this(0, 0, 0, null, null, 31, null);
        }

        public StepFrameData(@NotNull WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
            Intrinsics.checkNotNullParameter((Object)detectedFrameData, (String)"detectedFrameData");
            this(detectedFrameData.getFrameOrientation(), detectedFrameData.getFrameWidth(), detectedFrameData.getFrameHeight(), detectedFrameData.getFinderRect(), detectedFrameData.getRectOfInterest());
        }

        public final int component1() {
            return this.frameOrientation;
        }

        public final int component2() {
            return this.frameWidth;
        }

        public final int component3() {
            return this.frameHeight;
        }

        @Nullable
        public final Rect component4() {
            return this.finderRect;
        }

        @Nullable
        public final RectF component5() {
            return this.rectOfInterest;
        }

        @NotNull
        public final StepFrameData copy(int frameOrientation, int frameWidth, int frameHeight, @Nullable Rect finderRect, @Nullable RectF rectOfInterest) {
            return new StepFrameData(frameOrientation, frameWidth, frameHeight, finderRect, rectOfInterest);
        }

        public static /* synthetic */ StepFrameData copy$default(StepFrameData stepFrameData, int n, int n2, int n3, Rect rect, RectF rectF, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = stepFrameData.frameOrientation;
            }
            if ((n4 & 2) != 0) {
                n2 = stepFrameData.frameWidth;
            }
            if ((n4 & 4) != 0) {
                n3 = stepFrameData.frameHeight;
            }
            if ((n4 & 8) != 0) {
                rect = stepFrameData.finderRect;
            }
            if ((n4 & 0x10) != 0) {
                rectF = stepFrameData.rectOfInterest;
            }
            return stepFrameData.copy(n, n2, n3, rect, rectF);
        }

        @NotNull
        public String toString() {
            return "StepFrameData(frameOrientation=" + this.frameOrientation + ", frameWidth=" + this.frameWidth + ", frameHeight=" + this.frameHeight + ", finderRect=" + this.finderRect + ", rectOfInterest=" + this.rectOfInterest + ")";
        }

        public int hashCode() {
            Rect rect = this.finderRect;
            RectF rectF = this.rectOfInterest;
            return (((Integer.hashCode(this.frameOrientation) * 31 + Integer.hashCode(this.frameWidth)) * 31 + Integer.hashCode(this.frameHeight)) * 31 + (rect != null ? rect.hashCode() : 0)) * 31 + (rectF != null ? rectF.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StepFrameData)) break block3;
                    StepFrameData stepFrameData = (StepFrameData)object;
                    if (this.frameOrientation != stepFrameData.frameOrientation || this.frameWidth != stepFrameData.frameWidth || this.frameHeight != stepFrameData.frameHeight || !Intrinsics.areEqual((Object)this.finderRect, (Object)stepFrameData.finderRect) || !Intrinsics.areEqual((Object)this.rectOfInterest, (Object)stepFrameData.rectOfInterest)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk/ui/view/workflow/WorkflowCameraPresenter$Companion;", "", "()V", "ERROR_PROCESSING_DELAY_IN_SECONDS", "", "NAVIGATE_CAMERA_PERMISSION_SETTINGS", "", "NAVIGATE_CANCEL_LICENSE_INVALID", "NAVIGATE_CANCEL_SNAPPING", "NAVIGATE_CLOSE_SNAPPING", "NAVIGATE_PLAY_BEEP", "NAVIGATE_REQUEST_CAMERA_PERMISSION", "rtu-ui-bundle_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

