/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.workflow.camera;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.core.contourdetector.DetectionStatus;
import io.scanbot.sdk.core.contourdetector.PageAspectRatio;
import io.scanbot.sdk.di.SdkComponent;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.entity.workflow.ContourDetectorWorkflowStepResult;
import io.scanbot.sdk.ui.entity.workflow.PayFormWorkflowStepResult;
import io.scanbot.sdk.ui.entity.workflow.ScanBarCodeWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanDisabilityCertificateWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanMachineReadableZoneWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.ScanPayFormWorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.WorkflowScannersFactory;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStep;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStepResult;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 -2\u00020\u0001:\u0004-./0B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007J\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017H\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010&\u001a\u00020\n2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(H\u0004J\u000e\u0010+\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "handlers", "Ljava/util/LinkedHashSet;", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$ResultHandler;", "Lkotlin/collections/LinkedHashSet;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "scanbotSDK", "Lio/scanbot/sdk/ScanbotSDK;", "getScanbotSDK", "()Lio/scanbot/sdk/ScanbotSDK;", "workflowScannersFactory", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowScannersFactory;", "workflowStep", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "getWorkflowStep", "()Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;", "setWorkflowStep", "(Lio/scanbot/sdk/ui/entity/workflow/WorkflowStep;)V", "addResultHandler", "", "handler", "detect", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "getFeatureByWorkflowStep", "Lio/scanbot/sap/SdkFeature;", "step", "handleFrame", "notifyHandlers", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "Lio/scanbot/sdk/SdkLicenseError;", "removeResultHandler", "setWorkflowScannersFactory", "Companion", "DetectedFrameData", "ResultHandler", "WorkflowResultHandler", "rtu-ui-bundle_release"})
public class WorkflowFrameHandler
implements FrameHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScanbotSDK scanbotSDK;
    @NotNull
    private final LinkedHashSet<ResultHandler> handlers;
    @NotNull
    private final Logger logger;
    private boolean isEnabled;
    @Nullable
    private WorkflowStep workflowStep;
    private WorkflowScannersFactory workflowScannersFactory;

    public WorkflowFrameHandler(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.scanbotSDK = new ScanbotSDK(context);
        this.handlers = new LinkedHashSet();
        this.logger = LoggerProvider.getLogger();
        this.isEnabled = true;
    }

    @NotNull
    protected final ScanbotSDK getScanbotSDK() {
        return this.scanbotSDK;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Nullable
    public final WorkflowStep getWorkflowStep() {
        return this.workflowStep;
    }

    public final void setWorkflowStep(@Nullable WorkflowStep workflowStep) {
        this.workflowStep = workflowStep;
    }

    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        Intrinsics.checkNotNullParameter((Object)previewFrame, (String)"previewFrame");
        this.logger.logMethod();
        if (!this.isEnabled) {
            return false;
        }
        WorkflowStep workflowStep = this.workflowStep;
        if (workflowStep == null) {
            return false;
        }
        WorkflowStep currentStep = workflowStep;
        SdkComponent sdkComponent = this.scanbotSDK.getSdkComponent();
        Intrinsics.checkNotNull((Object)sdkComponent);
        SapManager sapManager = sdkComponent.sapManager();
        if (!sapManager.checkLicenseStatus(this.getFeatureByWorkflowStep(currentStep)).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<DetectedFrameData, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Failure((Object)new SdkLicenseError(sapManager.getLicenseStatus().getLicenseStatusMessage()))));
            return false;
        }
        return this.detect(currentStep, previewFrame);
    }

    private final SdkFeature getFeatureByWorkflowStep(WorkflowStep step) {
        WorkflowStep workflowStep = step;
        return workflowStep instanceof ScanMachineReadableZoneWorkflowStep ? SdkFeature.MRZRecognition : (workflowStep instanceof ScanBarCodeWorkflowStep ? SdkFeature.Barcode : (workflowStep instanceof ScanDisabilityCertificateWorkflowStep ? SdkFeature.MedicalCertRecognition : (workflowStep instanceof ScanPayFormWorkflowStep ? SdkFeature.PayformDetection : SdkFeature.NoSdkFeature)));
    }

    private final boolean detect(WorkflowStep workflowStep, FrameHandler.Frame previewFrame) {
        DetectionStatus detectionStatus = null;
        detectionStatus = DetectionStatus.ERROR_NOTHING_DETECTED;
        List polygon = null;
        polygon = CollectionsKt.emptyList();
        double detectionScore = 0.0;
        try {
            WorkflowStepResult workflowStepResult;
            WorkflowScannersFactory workflowScannersFactory = this.workflowScannersFactory;
            if (workflowScannersFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowScannersFactory");
                workflowScannersFactory = null;
            }
            WorkflowStepResult workflowStepResult2 = workflowStepResult = workflowScannersFactory.scannerForStep(workflowStep).scanOnCameraFrame(previewFrame);
            if (workflowStepResult2 != null) {
                WorkflowStepResult it = workflowStepResult2;
                boolean bl = false;
                if (it instanceof PayFormWorkflowStepResult) {
                    List list = ((PayFormWorkflowStepResult)it).getPolygon();
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    polygon = list;
                } else if (it instanceof ContourDetectorWorkflowStepResult) {
                    detectionStatus = ((ContourDetectorWorkflowStepResult)it).getDetectionStatus();
                    List list = ((ContourDetectorWorkflowStepResult)it).getPolygon();
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    polygon = list;
                    detectionScore = ((ContourDetectorWorkflowStepResult)it).getDetectionScore();
                }
            }
            DetectedFrameData detectedFrame = new DetectedFrameData(detectionStatus, polygon, workflowStep.getWantsVideoFramePage() ? previewFrame.getFrame() : new byte[]{}, previewFrame.getFrameOrientation(), previewFrame.getWidth(), previewFrame.getHeight(), detectionScore, previewFrame.getFinderRect(), previewFrame.getVisibleRect(), workflowStep.getRequiredAspectRatios(), workflowStepResult);
            return this.notifyHandlers((FrameHandlerResult<DetectedFrameData, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Success((Object)detectedFrame)));
        }
        catch (IOException e) {
            LoggerProvider.getLogger().logException((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            boolean bl = false;
            boolean bl2 = this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            boolean bl = false;
            boolean bl2 = this.handlers.remove(handler);
        }
    }

    public final void setWorkflowScannersFactory(@NotNull WorkflowScannersFactory workflowScannersFactory) {
        Intrinsics.checkNotNullParameter((Object)workflowScannersFactory, (String)"workflowScannersFactory");
        this.workflowScannersFactory = workflowScannersFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean notifyHandlers(@NotNull FrameHandlerResult<DetectedFrameData, SdkLicenseError> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        boolean handled = false;
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            boolean bl = false;
            for (ResultHandler handler : this.handlers) {
                handled |= handler.handle(result);
            }
            Unit unit = Unit.INSTANCE;
        }
        return handled;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "Lio/scanbot/sdk/SdkLicenseError;", "rtu-ui-bundle_release"})
    public static interface ResultHandler
    extends BaseResultHandler<DetectedFrameData, SdkLicenseError> {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$WorkflowResultHandler;", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$ResultHandler;", "()V", "rtu-ui-bundle_release"})
    public static abstract class WorkflowResultHandler
    implements ResultHandler {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u0017J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0016H\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010/\u001a\u00020\bH\u00c6\u0003J\t\u00100\u001a\u00020\nH\u00c6\u0003J\t\u00101\u001a\u00020\nH\u00c6\u0003J\t\u00102\u001a\u00020\nH\u00c6\u0003J\t\u00103\u001a\u00020\u000eH\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u0089\u0001\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00c6\u0001J\u0013\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010:\u001a\u00020\nH\u00d6\u0001J\t\u0010;\u001a\u00020<H\u00d6\u0001R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006="}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "", "detectionStatus", "Lio/scanbot/sdk/core/contourdetector/DetectionStatus;", "polygon", "", "Landroid/graphics/PointF;", "frame", "", "frameOrientation", "", "frameWidth", "frameHeight", "detectionScore", "", "finderRect", "Landroid/graphics/Rect;", "rectOfInterest", "Landroid/graphics/RectF;", "requiredAspectRatios", "Lio/scanbot/sdk/core/contourdetector/PageAspectRatio;", "workflowStepResult", "Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "(Lio/scanbot/sdk/core/contourdetector/DetectionStatus;Ljava/util/List;[BIIIDLandroid/graphics/Rect;Landroid/graphics/RectF;Ljava/util/List;Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;)V", "getDetectionScore", "()D", "getDetectionStatus", "()Lio/scanbot/sdk/core/contourdetector/DetectionStatus;", "getFinderRect", "()Landroid/graphics/Rect;", "getFrame", "()[B", "getFrameHeight", "()I", "getFrameOrientation", "getFrameWidth", "getPolygon", "()Ljava/util/List;", "getRectOfInterest", "()Landroid/graphics/RectF;", "getRequiredAspectRatios", "getWorkflowStepResult", "()Lio/scanbot/sdk/ui/entity/workflow/WorkflowStepResult;", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "", "rtu-ui-bundle_release"})
    public static final class DetectedFrameData {
        @NotNull
        private final DetectionStatus detectionStatus;
        @NotNull
        private final List<PointF> polygon;
        @NotNull
        private final byte[] frame;
        private final int frameOrientation;
        private final int frameWidth;
        private final int frameHeight;
        private final double detectionScore;
        @Nullable
        private final Rect finderRect;
        @Nullable
        private final RectF rectOfInterest;
        @NotNull
        private final List<PageAspectRatio> requiredAspectRatios;
        @Nullable
        private final WorkflowStepResult workflowStepResult;

        public DetectedFrameData(@NotNull DetectionStatus detectionStatus, @NotNull List<? extends PointF> polygon, @NotNull byte[] frame, int frameOrientation, int frameWidth, int frameHeight, double detectionScore, @Nullable Rect finderRect, @Nullable RectF rectOfInterest, @NotNull List<PageAspectRatio> requiredAspectRatios, @Nullable WorkflowStepResult workflowStepResult) {
            Intrinsics.checkNotNullParameter((Object)detectionStatus, (String)"detectionStatus");
            Intrinsics.checkNotNullParameter(polygon, (String)"polygon");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter(requiredAspectRatios, (String)"requiredAspectRatios");
            this.detectionStatus = detectionStatus;
            this.polygon = polygon;
            this.frame = frame;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.detectionScore = detectionScore;
            this.finderRect = finderRect;
            this.rectOfInterest = rectOfInterest;
            this.requiredAspectRatios = requiredAspectRatios;
            this.workflowStepResult = workflowStepResult;
        }

        public /* synthetic */ DetectedFrameData(DetectionStatus detectionStatus, List list, byte[] byArray, int n, int n2, int n3, double d, Rect rect, RectF rectF, List list2, WorkflowStepResult workflowStepResult, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                detectionStatus = DetectionStatus.ERROR_NOTHING_DETECTED;
            }
            if ((n4 & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n4 & 4) != 0) {
                byArray = new byte[]{};
            }
            if ((n4 & 8) != 0) {
                n = 0;
            }
            if ((n4 & 0x10) != 0) {
                n2 = 0;
            }
            if ((n4 & 0x20) != 0) {
                n3 = 0;
            }
            if ((n4 & 0x40) != 0) {
                d = 0.0;
            }
            if ((n4 & 0x80) != 0) {
                rect = null;
            }
            if ((n4 & 0x100) != 0) {
                rectF = null;
            }
            if ((n4 & 0x200) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(detectionStatus, list, byArray, n, n2, n3, d, rect, rectF, list2, workflowStepResult);
        }

        @NotNull
        public final DetectionStatus getDetectionStatus() {
            return this.detectionStatus;
        }

        @NotNull
        public final List<PointF> getPolygon() {
            return this.polygon;
        }

        @NotNull
        public final byte[] getFrame() {
            return this.frame;
        }

        public final int getFrameOrientation() {
            return this.frameOrientation;
        }

        public final int getFrameWidth() {
            return this.frameWidth;
        }

        public final int getFrameHeight() {
            return this.frameHeight;
        }

        public final double getDetectionScore() {
            return this.detectionScore;
        }

        @Nullable
        public final Rect getFinderRect() {
            return this.finderRect;
        }

        @Nullable
        public final RectF getRectOfInterest() {
            return this.rectOfInterest;
        }

        @NotNull
        public final List<PageAspectRatio> getRequiredAspectRatios() {
            return this.requiredAspectRatios;
        }

        @Nullable
        public final WorkflowStepResult getWorkflowStepResult() {
            return this.workflowStepResult;
        }

        @NotNull
        public final DetectionStatus component1() {
            return this.detectionStatus;
        }

        @NotNull
        public final List<PointF> component2() {
            return this.polygon;
        }

        @NotNull
        public final byte[] component3() {
            return this.frame;
        }

        public final int component4() {
            return this.frameOrientation;
        }

        public final int component5() {
            return this.frameWidth;
        }

        public final int component6() {
            return this.frameHeight;
        }

        public final double component7() {
            return this.detectionScore;
        }

        @Nullable
        public final Rect component8() {
            return this.finderRect;
        }

        @Nullable
        public final RectF component9() {
            return this.rectOfInterest;
        }

        @NotNull
        public final List<PageAspectRatio> component10() {
            return this.requiredAspectRatios;
        }

        @Nullable
        public final WorkflowStepResult component11() {
            return this.workflowStepResult;
        }

        @NotNull
        public final DetectedFrameData copy(@NotNull DetectionStatus detectionStatus, @NotNull List<? extends PointF> polygon, @NotNull byte[] frame, int frameOrientation, int frameWidth, int frameHeight, double detectionScore, @Nullable Rect finderRect, @Nullable RectF rectOfInterest, @NotNull List<PageAspectRatio> requiredAspectRatios, @Nullable WorkflowStepResult workflowStepResult) {
            Intrinsics.checkNotNullParameter((Object)detectionStatus, (String)"detectionStatus");
            Intrinsics.checkNotNullParameter(polygon, (String)"polygon");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter(requiredAspectRatios, (String)"requiredAspectRatios");
            return new DetectedFrameData(detectionStatus, polygon, frame, frameOrientation, frameWidth, frameHeight, detectionScore, finderRect, rectOfInterest, requiredAspectRatios, workflowStepResult);
        }

        public static /* synthetic */ DetectedFrameData copy$default(DetectedFrameData detectedFrameData, DetectionStatus detectionStatus, List list, byte[] byArray, int n, int n2, int n3, double d, Rect rect, RectF rectF, List list2, WorkflowStepResult workflowStepResult, int n4, Object object) {
            if ((n4 & 1) != 0) {
                detectionStatus = detectedFrameData.detectionStatus;
            }
            if ((n4 & 2) != 0) {
                list = detectedFrameData.polygon;
            }
            if ((n4 & 4) != 0) {
                byArray = detectedFrameData.frame;
            }
            if ((n4 & 8) != 0) {
                n = detectedFrameData.frameOrientation;
            }
            if ((n4 & 0x10) != 0) {
                n2 = detectedFrameData.frameWidth;
            }
            if ((n4 & 0x20) != 0) {
                n3 = detectedFrameData.frameHeight;
            }
            if ((n4 & 0x40) != 0) {
                d = detectedFrameData.detectionScore;
            }
            if ((n4 & 0x80) != 0) {
                rect = detectedFrameData.finderRect;
            }
            if ((n4 & 0x100) != 0) {
                rectF = detectedFrameData.rectOfInterest;
            }
            if ((n4 & 0x200) != 0) {
                list2 = detectedFrameData.requiredAspectRatios;
            }
            if ((n4 & 0x400) != 0) {
                workflowStepResult = detectedFrameData.workflowStepResult;
            }
            return detectedFrameData.copy(detectionStatus, list, byArray, n, n2, n3, d, rect, rectF, list2, workflowStepResult);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DetectedFrameData(detectionStatus=").append(this.detectionStatus).append(", polygon=").append(this.polygon).append(", frame=").append(Arrays.toString(this.frame)).append(", frameOrientation=").append(this.frameOrientation).append(", frameWidth=").append(this.frameWidth).append(", frameHeight=").append(this.frameHeight).append(", detectionScore=").append(this.detectionScore).append(", finderRect=").append(this.finderRect).append(", rectOfInterest=").append(this.rectOfInterest).append(", requiredAspectRatios=").append(this.requiredAspectRatios).append(", workflowStepResult=").append(this.workflowStepResult).append(')');
            return stringBuilder.toString();
        }

        public int hashCode() {
            int result = this.detectionStatus.hashCode();
            result = result * 31 + ((Object)this.polygon).hashCode();
            result = result * 31 + Arrays.hashCode(this.frame);
            result = result * 31 + Integer.hashCode(this.frameOrientation);
            result = result * 31 + Integer.hashCode(this.frameWidth);
            result = result * 31 + Integer.hashCode(this.frameHeight);
            result = result * 31 + Double.hashCode(this.detectionScore);
            result = result * 31 + (this.finderRect == null ? 0 : this.finderRect.hashCode());
            result = result * 31 + (this.rectOfInterest == null ? 0 : this.rectOfInterest.hashCode());
            result = result * 31 + ((Object)this.requiredAspectRatios).hashCode();
            result = result * 31 + (this.workflowStepResult == null ? 0 : this.workflowStepResult.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DetectedFrameData)) {
                return false;
            }
            DetectedFrameData detectedFrameData = (DetectedFrameData)other;
            if (this.detectionStatus != detectedFrameData.detectionStatus) {
                return false;
            }
            if (!Intrinsics.areEqual(this.polygon, detectedFrameData.polygon)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.frame, (Object)detectedFrameData.frame)) {
                return false;
            }
            if (this.frameOrientation != detectedFrameData.frameOrientation) {
                return false;
            }
            if (this.frameWidth != detectedFrameData.frameWidth) {
                return false;
            }
            if (this.frameHeight != detectedFrameData.frameHeight) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.detectionScore, (Object)detectedFrameData.detectionScore)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.finderRect, (Object)detectedFrameData.finderRect)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rectOfInterest, (Object)detectedFrameData.rectOfInterest)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.requiredAspectRatios, detectedFrameData.requiredAspectRatios)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.workflowStepResult, (Object)detectedFrameData.workflowStepResult);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$Companion;", "", "()V", "attach", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "rtu-ui-bundle_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkflowFrameHandler attach(@NotNull IScanbotCameraView cameraView) {
            Intrinsics.checkNotNullParameter((Object)cameraView, (String)"cameraView");
            WorkflowFrameHandler workflowFrameHandler = (WorkflowFrameHandler)cameraView.getAttachedFrameHandler(WorkflowFrameHandler.class);
            if (workflowFrameHandler == null) {
                Context context = ((View)cameraView).getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"cameraView as View).context");
                workflowFrameHandler = new WorkflowFrameHandler(context);
            }
            WorkflowFrameHandler frameHandler = workflowFrameHandler;
            cameraView.addFrameHandler((FrameHandler)frameHandler);
            return frameHandler;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

