/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import io.scanbot.sdk.check.CheckRecognizer;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui.di.components.CheckRecognizerComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.CheckModule;
import io.scanbot.sdk.ui.di.modules.CheckModule_ProvideCheckCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.CheckModule_ProvideCheckRecognizerResultRepository$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.DispatchersModule;
import io.scanbot.sdk.ui.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.result.ResultRepository;
import io.scanbot.sdk.ui.view.base.NFBaseActivity;
import io.scanbot.sdk.ui.view.base.NFBaseActivity_MembersInjector;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.check.BaseCheckRecognizerActivity;
import io.scanbot.sdk.ui.view.check.BaseCheckRecognizerActivity_MembersInjector;
import io.scanbot.sdk.ui.view.check.CheckCameraViewModel;
import io.scanbot.sdk.ui.view.check.CheckRecognizerActivity;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerCheckRecognizerComponent {
    private DaggerCheckRecognizerComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class CheckRecognizerComponentImpl
    implements CheckRecognizerComponent {
        private final SDKUIComponent sDKUIComponent;
        private final CheckRecognizerComponentImpl checkRecognizerComponentImpl = this;
        private Provider<CheckRecognizer> checkRecognizerProvider;
        private Provider<ContourDetector> contourDetectorProvider;
        private Provider<ImageProcessor> imageProcessorProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<Set<ResultRepository<Object>>> resultRepositoriesProvider;
        private Provider<ResultRepository<Object>> provideCheckRecognizerResultRepository$rtu_ui_bundle_releaseProvider;
        private Provider<ViewModel> provideCheckCameraViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        private Provider<ViewModel> provideBarcodeCameraViewModelProvider2;
        private Provider<Map<Class<? extends ViewModel>, Provider<ViewModel>>> mapOfClassOfAndProviderOfViewModelProvider;
        private Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        private CheckRecognizerComponentImpl(CheckModule checkModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(checkModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private void initialize(CheckModule checkModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.checkRecognizerProvider = new CheckRecognizerProvider(sDKUIComponentParam);
            this.contourDetectorProvider = new ContourDetectorProvider(sDKUIComponentParam);
            this.imageProcessorProvider = new ImageProcessorProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.resultRepositoriesProvider = new ResultRepositoriesProvider(sDKUIComponentParam);
            this.provideCheckRecognizerResultRepository$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)CheckModule_ProvideCheckRecognizerResultRepository$rtu_ui_bundle_releaseFactory.create(checkModuleParam, this.resultRepositoriesProvider));
            this.provideCheckCameraViewModelProvider = DoubleCheck.provider((Provider)CheckModule_ProvideCheckCameraViewModelFactory.create(checkModuleParam, this.checkRecognizerProvider, this.contourDetectorProvider, this.imageProcessorProvider, this.provideBarcodeCameraViewModelProvider, this.provideCheckRecognizerResultRepository$rtu_ui_bundle_releaseProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider2 = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)2).put(CheckCameraViewModel.class, this.provideCheckCameraViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider2).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(CheckRecognizerActivity activity) {
            this.injectCheckRecognizerActivity(activity);
        }

        private CheckRecognizerActivity injectCheckRecognizerActivity(CheckRecognizerActivity instance) {
            NFBaseActivity_MembersInjector.injectCameraUiSettings((NFBaseActivity)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseCheckRecognizerActivity_MembersInjector.injectFactory((BaseCheckRecognizerActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }

        private static final class ResultRepositoriesProvider
        implements Provider<Set<ResultRepository<Object>>> {
            private final SDKUIComponent sDKUIComponent;

            ResultRepositoriesProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Set<ResultRepository<Object>> get() {
                return (Set)Preconditions.checkNotNullFromComponent(this.sDKUIComponent.resultRepositories());
            }
        }

        private static final class ImageProcessorProvider
        implements Provider<ImageProcessor> {
            private final SDKUIComponent sDKUIComponent;

            ImageProcessorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public ImageProcessor get() {
                return (ImageProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.imageProcessor());
            }
        }

        private static final class ContourDetectorProvider
        implements Provider<ContourDetector> {
            private final SDKUIComponent sDKUIComponent;

            ContourDetectorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public ContourDetector get() {
                return (ContourDetector)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.contourDetector());
            }
        }

        private static final class CheckRecognizerProvider
        implements Provider<CheckRecognizer> {
            private final SDKUIComponent sDKUIComponent;

            CheckRecognizerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public CheckRecognizer get() {
                return (CheckRecognizer)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.checkRecognizer());
            }
        }
    }

    public static final class Builder {
        private CheckModule checkModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder checkModule(CheckModule checkModule) {
            this.checkModule = (CheckModule)Preconditions.checkNotNull((Object)checkModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public CheckRecognizerComponent build() {
            if (this.checkModule == null) {
                this.checkModule = new CheckModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new CheckRecognizerComponentImpl(this.checkModule, this.viewModelFactoryModule, this.permissionsModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }
}

