/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import io.scanbot.multipleobjectsscanner.MultipleObjectsDetector;
import io.scanbot.sdk.docprocessing.PageProcessor;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.di.components.MultipleObjectsDetectorComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.BusinessCardsScannerViewModule;
import io.scanbot.sdk.ui.di.modules.BusinessCardsScannerViewModule_ProvideBusinessCardsScannerViewModelFactory;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.view.base.BaseFragment;
import io.scanbot.sdk.ui.view.base.BaseFragment_MembersInjector;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import io.scanbot.sdk.ui.view.interactor.DetectSaveMultipleObjectsUseCase;
import io.scanbot.sdk.ui.view.interactor.DetectSaveMultipleObjectsUseCase_Factory;
import io.scanbot.sdk.ui.view.multiple_objects.BaseMultipleObjectsDetectorFragment;
import io.scanbot.sdk.ui.view.multiple_objects.BaseMultipleObjectsDetectorFragment_MembersInjector;
import io.scanbot.sdk.ui.view.multiple_objects.BusinessCardsScannerViewModel;
import io.scanbot.sdk.ui.view.multiple_objects.MultipleObjectsDetectorFragment;
import java.util.Map;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerMultipleObjectsDetectorComponent {
    private DaggerMultipleObjectsDetectorComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class MultipleObjectsDetectorComponentImpl
    implements MultipleObjectsDetectorComponent {
        private final SDKUIComponent sDKUIComponent;
        private final MultipleObjectsDetectorComponentImpl multipleObjectsDetectorComponentImpl = this;
        private Provider<MultipleObjectsDetector> multipleObjectsDetectorProvider;
        private Provider<PageProcessor> pageProcessorProvider;
        private Provider<PageFileStorage> pageFileStorageProvider;
        private Provider<ImageProcessor> imageProcessorProvider;
        private Provider<DetectSaveMultipleObjectsUseCase> detectSaveMultipleObjectsUseCaseProvider;
        private Provider<ViewModel> provideBusinessCardsScannerViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        private Provider<ViewModel> provideBarcodeCameraViewModelProvider;
        private Provider<Map<Class<? extends ViewModel>, Provider<ViewModel>>> mapOfClassOfAndProviderOfViewModelProvider;
        private Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        private MultipleObjectsDetectorComponentImpl(BusinessCardsScannerViewModule businessCardsScannerViewModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(businessCardsScannerViewModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, sDKUIComponentParam);
        }

        private void initialize(BusinessCardsScannerViewModule businessCardsScannerViewModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.multipleObjectsDetectorProvider = new MultipleObjectsDetectorProvider(sDKUIComponentParam);
            this.pageProcessorProvider = new PageProcessorProvider(sDKUIComponentParam);
            this.pageFileStorageProvider = new PageFileStorageProvider(sDKUIComponentParam);
            this.imageProcessorProvider = new ImageProcessorProvider(sDKUIComponentParam);
            this.detectSaveMultipleObjectsUseCaseProvider = DetectSaveMultipleObjectsUseCase_Factory.create(this.pageProcessorProvider, this.pageFileStorageProvider, this.imageProcessorProvider, this.multipleObjectsDetectorProvider);
            this.provideBusinessCardsScannerViewModelProvider = DoubleCheck.provider((Provider)BusinessCardsScannerViewModule_ProvideBusinessCardsScannerViewModelFactory.create(businessCardsScannerViewModuleParam, this.multipleObjectsDetectorProvider, this.detectSaveMultipleObjectsUseCaseProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)2).put(BusinessCardsScannerViewModel.class, this.provideBusinessCardsScannerViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(MultipleObjectsDetectorFragment fragment) {
            this.injectMultipleObjectsDetectorFragment(fragment);
        }

        private MultipleObjectsDetectorFragment injectMultipleObjectsDetectorFragment(MultipleObjectsDetectorFragment instance) {
            BaseFragment_MembersInjector.injectCameraUiSettings((BaseFragment)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseMultipleObjectsDetectorFragment_MembersInjector.injectFactory((BaseMultipleObjectsDetectorFragment)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }

        private static final class ImageProcessorProvider
        implements Provider<ImageProcessor> {
            private final SDKUIComponent sDKUIComponent;

            ImageProcessorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public ImageProcessor get() {
                return (ImageProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.imageProcessor());
            }
        }

        private static final class PageFileStorageProvider
        implements Provider<PageFileStorage> {
            private final SDKUIComponent sDKUIComponent;

            PageFileStorageProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public PageFileStorage get() {
                return (PageFileStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.pageFileStorage());
            }
        }

        private static final class PageProcessorProvider
        implements Provider<PageProcessor> {
            private final SDKUIComponent sDKUIComponent;

            PageProcessorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public PageProcessor get() {
                return (PageProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.pageProcessor());
            }
        }

        private static final class MultipleObjectsDetectorProvider
        implements Provider<MultipleObjectsDetector> {
            private final SDKUIComponent sDKUIComponent;

            MultipleObjectsDetectorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public MultipleObjectsDetector get() {
                return (MultipleObjectsDetector)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.multipleObjectsDetector());
            }
        }
    }

    public static final class Builder {
        private BusinessCardsScannerViewModule businessCardsScannerViewModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder businessCardsScannerViewModule(BusinessCardsScannerViewModule businessCardsScannerViewModule) {
            this.businessCardsScannerViewModule = (BusinessCardsScannerViewModule)Preconditions.checkNotNull((Object)businessCardsScannerViewModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public MultipleObjectsDetectorComponent build() {
            if (this.businessCardsScannerViewModule == null) {
                this.businessCardsScannerViewModule = new BusinessCardsScannerViewModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new MultipleObjectsDetectorComponentImpl(this.businessCardsScannerViewModule, this.viewModelFactoryModule, this.permissionsModule, this.sDKUIComponent);
        }
    }
}

