/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.components.VinScannerComponent;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.di.modules.VinScannerModule;
import io.scanbot.sdk.ui.di.modules.VinScannerModule_ProvideVinScannerViewModelFactory;
import io.scanbot.sdk.ui.view.base.NFBaseActivity;
import io.scanbot.sdk.ui.view.base.NFBaseActivity_MembersInjector;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import io.scanbot.sdk.ui.view.vin.BaseVinScannerActivity;
import io.scanbot.sdk.ui.view.vin.BaseVinScannerActivity_MembersInjector;
import io.scanbot.sdk.ui.view.vin.VinScannerActivity;
import io.scanbot.sdk.ui.view.vin.VinScannerViewModel;
import io.scanbot.sdk.vin.VinScanner;
import java.util.Map;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerVinScannerComponent {
    private DaggerVinScannerComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class VinScannerComponentImpl
    implements VinScannerComponent {
        private final SDKUIComponent sDKUIComponent;
        private final VinScannerComponentImpl vinScannerComponentImpl = this;
        private Provider<VinScanner> vinScannerProvider;
        private Provider<ViewModel> provideVinScannerViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        private Provider<ViewModel> provideBarcodeCameraViewModelProvider;
        private Provider<Map<Class<? extends ViewModel>, Provider<ViewModel>>> mapOfClassOfAndProviderOfViewModelProvider;
        private Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        private VinScannerComponentImpl(VinScannerModule vinScannerModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(vinScannerModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, sDKUIComponentParam);
        }

        private void initialize(VinScannerModule vinScannerModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.vinScannerProvider = new VinScannerProvider(sDKUIComponentParam);
            this.provideVinScannerViewModelProvider = DoubleCheck.provider((Provider)VinScannerModule_ProvideVinScannerViewModelFactory.create(vinScannerModuleParam, this.vinScannerProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)2).put(VinScannerViewModel.class, this.provideVinScannerViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(VinScannerActivity vinScannerActivity) {
            this.injectVinScannerActivity(vinScannerActivity);
        }

        private VinScannerActivity injectVinScannerActivity(VinScannerActivity instance) {
            NFBaseActivity_MembersInjector.injectCameraUiSettings((NFBaseActivity)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseVinScannerActivity_MembersInjector.injectFactory((BaseVinScannerActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }

        private static final class VinScannerProvider
        implements Provider<VinScanner> {
            private final SDKUIComponent sDKUIComponent;

            VinScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public VinScanner get() {
                return (VinScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.vinScanner());
            }
        }
    }

    public static final class Builder {
        private VinScannerModule vinScannerModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder vinScannerModule(VinScannerModule vinScannerModule) {
            this.vinScannerModule = (VinScannerModule)Preconditions.checkNotNull((Object)vinScannerModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public VinScannerComponent build() {
            if (this.vinScannerModule == null) {
                this.vinScannerModule = new VinScannerModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new VinScannerComponentImpl(this.vinScannerModule, this.viewModelFactoryModule, this.permissionsModule, this.sDKUIComponent);
        }
    }
}

